// Gestionnaire de validation de formulaire
// Fonction générique
	// formValidForm est la fonction générale
	// formValidFormByKey est spécifique aux formulaires où cette fonctionnalité est implémentées
	// confirmExecute demande une confirmation à l'éxécution d'une action

function validateField(field){
	// valide un champ de formulaire et renvoie un objet de validation de la forme
	// {'name':nom du champ, 'value':attribut value du champ, 'checked': si il y a lieu}
	var valid = new Object();
	var nom = field.name;
    var val = field.value;
	if (field.getAttributeNode('_blur') != null){
		a = field.getAttributeNode('_blur').value;
        b = eval(a);
        if (!(b)){
			stopLoader();
			return false;
		}
	}
    if ((field.type == 'select-multiple')){
		// si on a un select multiple on doit aller chercher les valeurs selectionnees
		_select = field;
		val = new Array();
		for (k=0; k<_select.options.length;k++){
			if (_select.options[k].selected){
				val.push(_select.options[k].value);
			}
		}
	}
	if ((field.type == 'checkbox') ||  (field.type == 'radio')){
		// si on a un bouton radio ou une checkbox, il a un attribut checked
		checked = field.checked;
        valid['checked'] = String(checked);
    }
    valid['name'] = nom;
    valid['value'] = val;
	return valid;
}

function formValidForm(server, actionName, forms, balise, params){
        // valide les formulaires : forms = [liste de formulaire]
	// renvoit un objet {Nom du form:[{name:nomdevariable, value:valeur,
						//checked:'true'/'false'(que pour ceux qui ont l'attr)}]}
    // balise: balise html de la page ou placer la réponse
    // params: paramètres autres à passer directement
	var result = new Object();
        var i = 0;
        for (i=0; i<forms.length; i++){
                formname = forms[i];
                form = $(formname);
            if (form != null){
                var formResult = new Array();
                for (j=0; j<form.elements.length; j++){
                                var valid = validateField(form.elements[j]);
				if (valid!=false){
                                formResult.push(valid);}
				else{
					return;
				     }
                        }
                        result[formname] = formResult;
                }
            }
                var return_json = new Object();
        return_json['form_result'] = result
        return_json = return_json.toJSONString();
        return_params = new Array();
        return_params.push(['JSONstr', return_json]);
        if (params != undefined){
            for (i=0; i< params.length; i++){
    			return_params.push(params[i]);
            }
		}
        call_plugin(server, actionName, return_params, balise);
}

function formValidFormByKey(server, actionName, forms, balise){
        // valide les formulaires par le clavier : forms = [liste de formulaire]
	// renvoit un objet {Nom du form:[{name:nomdevariable, value:valeur,
						//checked:'true'/'false'(que pour ceux qui ont l'attr)}]}
	var result = new Object();
        var i = 0;
        for (i=0; i<forms.length; i++){
                formname = forms[i];
                form = $(formname);
            if (form != null){
                var formResult = new Array();
                for (j=0; j<form.elements.length; j++){
                                var valid = validateField(form.elements[j]);
                                formResult.push(valid);
                        }
                        result[formname] = formResult;
                }
            }
                var return_json = new Object();
                return_json['form_result'] = result
                return_json = return_json.toJSONString();
                call_plugin(server, actionName, [['JSONstr', return_json]], balise);
}

function formConfirmExecute(msg, func){
                var a = confirm(msg);
                if (a){
                        eval(func);
                }
}
// ###################################################################
// Outil spécifiques

function formGetCheckedElement(tagFrom){
/* renvoit la liste des checkbox selectionne pour le formulaire tagFrom*/
        var checked=new Array();
        for (var i=0; i< tagFrom.length; i++){
                var check=new Object;
                a = tagFrom.elements[i];
                if (a.checked){
                        check['name'] = a.name;
                        check['value'] = a.value;
                        checked.push(check);
                }
        }
        return checked;
}
function formTransferAllList(from, to){
        tagFrom = $(from);
    tagTo = $(to);
    tags = formGetListElements(tagFrom);
    for (var i=0; i< tags.length; i++){
        a = tags[i];
        input = "<input type='checkbox' name='"+a.name+"' value='"+a.value+"'   >"+ a.name+"</input>";
        trtag = document.getElementById(a.name);
        trtag.parentNode.removeChild(trtag);
        tagTo.innerHTML += "<tr id='"+a.name+"'><td>"+input+"</td></tr>";
    }
}
function formTransferListElement(from, to){
/* transfert les éléments sélectionnés du formulaire from vers le tableau to */
    tagFrom = $(from);
    tagTo = $(to);
    checked = formGetCheckedElement(tagFrom);
    for (var i=0; i< checked.length; i++){
        a = checked[i];
        input = "<input type='checkbox' name='"+a.name+"' value='"+a.value+"'	>"+ a.name+"</input>";
        trtag = document.getElementById(a.name);
        trtag.parentNode.removeChild(trtag);
        tagTo.innerHTML += "<tr id='"+a.name+"'><td>"+input+"</td></tr>";
    }
}
function formSelectInvert(p_oForm, root) {
/* selectionne l'inverse pour le formulaire (celui-ci ne doit contenir que des checkbox)*/
    _form = $(p_oForm);
    for (var i = 0; i < _form.length; i++) {
	 if (typeof(root) == 'undefined'){
		 _form.elements[i].checked = !_form.elements[i].checked;
	}else{
		if (_form.elements[i].name.indexOf(root) != -1) _form.elements[i].checked = !_form.elements[i].checked;
	}
    }
}
function formSelectNone(p_oForm, root) {
/* selection vide pour le formulaire (celui-ci ne doit contenir que des checkbox)*/
    _form = $(p_oForm);
    for (var i = 0; i < _form.length; i++) {
	if (typeof(root) == 'undefined'){
		 _form.elements[i].checked = false;
	}else{
		if (_form.elements[i].name.indexOf(root) != -1) _form.elements[i].checked = false;

	}
    }
}
function formSelectAll(p_oForm, root) {
/* selectionne tous les éléments du formulaire (celui-ci ne doit contenir que des checkbox)*/
    _form = $(p_oForm);
    for (var i = 0; i < _form.length; i++) {
	if (typeof(root) == 'undefined') _form.elements[i].checked = true;
	else{
		if (_form.elements[i].name.indexOf(root) != -1) _form.elements[i].checked = true;
	}
    }
}
function formGetListElements(tagFrom){
        /* renvoit la liste des éléments présents dans les parties droites et gauches
                d'un outil de transfert de liste à liste*/
        var valids=new Array();
        for (var i=0; i< tagFrom.length; i++){
                var valid=new Object;
                a = tagFrom.elements[i];
                valid['name'] = a.name;
                valid['value'] = a.value;
                valids.push(valid);
        }
        return valids;
}
function formAddNameToList1(name, to){
// ajoute le contenu d'un input à un tableau de checkbox avec sticky bit (pour horus)
	tag = $(name);
        tagTo = $(to);
        val = tag.value;
        if (val != undefined){
            if ($(val) != undefined){
                window.alert("Une balise du même nom a été trouvée dans la page (le partage " + val + " ne peut être associé au groupe)");
                return;
             }
                input = "<input type='checkbox' name='"+val+"' value='"+val+"'	>"+ val+"</input>";
                sticky = "<input type='checkbox' name='sticky"+val+"' value='"+val+"'></input>";
                tagTo.innerHTML += "<tr id='"+val+"'><td>"+input+sticky+" sticky bit activé</td></tr>";
        }
}
function formAddNameToList2(name, to){
// ajoute le contenu d'un input à un tableau de checkbox sans sticky bit
	tag = $(name);
        tagTo = $(to);
        val = tag.value;
        if (val != undefined){
                input = "<input type='checkbox' name='"+val+"' value='"+val+"'	>"+ val+"</input>";
                tagTo.innerHTML += "<tr id='"+val+"'><td>"+input+"</td></tr>";
        }
}
function formAddNameToList3(name, to){
// ajoute le contenu d'un select à un tableau de checkbox sans sticky bit
	tag = $(name);
        tagTo = $(to);
	for (i=tag.options.length-1; i>=0; i--){
	    if (tag.options[i].selected == true){
        	val = tag.options[i].value;
	        tag.options[i].parentNode.removeChild(tag.options[i]);
        	if (val != undefined){
                    input = "<input type='checkbox' name='"+val+"' value='"+val+"'	>"+ val+"</input>";
	            tagTo.innerHTML += "<tr id='"+val+"'><td>"+input+"</td></tr>";
        	}
	    }
	}
}

function formRemoveFromList(from, to){
// supprime les lignes sélectionnées d'un formulaire composé de checkbox
    tag = $(from);
    if (to) tagTo = $(to);
        checked = formGetCheckedElement(tag);
        for (i=0; i<checked.length;i++){
                name = checked[i].name;
                if (name.substr(0,6)!='sticky'){
                rmtag = $(name);
                rmtag.parentNode.removeChild(rmtag);}
                if (to) {
                    tagTo.childNodes[1].innerHTML += "<option value=\"" + name + "\">" + name + "</option>";
                };
        }
}

function formCheckActif(formname){
        form = $(formname);
        count = form.elements.length;
        for (i=0; i<count ; i++){
                if (form.elements[i].value == 'actif'){
                                form.elements[i].checked = 'true';
                        }
        }
}
function formCheckInactif(formname){
        form = $(formname);
        count = form.elements.length;
        for (i=0; i<count ; i++){
                if (form.elements[i].value == 'inactif'){
                       form.elements[i].checked = 'true';
                        }
        }
}
function getForm(name){
    return document.forms[name]
}
