#*-*coding:utf-8*-*
""" gestion des formulaires des règles de pare-feu """
from twisted.python import log
from amon.era import regles
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import form as F
from ead2.backend.actions.amon import amon_tools
from ead2.backend.actions.lib.widgets import main

zone_indices = {'admin':0,
                'pedago':1,
                'generales':None}

def by_libelle(a,b):
    aname = a['libelle']
    bname = b['libelle']
    if aname > bname:
        return 1
    else:
        return -1

def get_regles_form(zone):
    rules = regles.load(zone_indices[zone], libelle=True)
    checkboxes = []
    for rule in rules:
        actif = F.Radio(name=rule['desc'], value='actif', inline=True)
        inactif = F.Radio(name=rule['desc'], value='inactif', inline=True)
        if rule['val'] == '1':
            inactif.check()
        else:
            actif.check()
        checkboxes.append({'libelle':rule['libelle'],
                      'actif':actif,
                      'inactif': inactif})
    checkboxes.sort(by_libelle)
    return dict(entete="Activez/Désactivez des règles optionnelles",
                rules=checkboxes)

def get_validate_btn(server_nb, name):
    """ renvoie la description du bouton valider """
    href = tools.make_form_link(server_nb, name, True, ['mod_regles'], 'div_msg')
    title = "Modifier les règles optionnelles du pare-feu"
    libelle = "Valider"
    return dict(validate=main.Bouton(href=href, libelle=libelle, title=title))

def mod_regles(zone, resultat):
    """
        valide la modification des règles optionnelles du pare-feu
        resultat : liste de regles de la forme:
            {nom de la règle:inactif/actif}
            transforme pour era:
                inactif -> 1
                actif -> 3
    """
    rules = regles.load(zone_indices[zone])
    message = "Modification des règles optionnelles :\\n"

    for rule in rules:
        if resultat.has_key(rule['desc']):
            if resultat[rule['desc']] == 'actif':
                if rule['val'] != '3':
                    rule['val'] = '3'
                    message += "   - La règle %s a été activée\\n"%rule['desc']
            else:
                if rule['val'] != '1':
                    rule['val'] = '1'
                    message += "   - La règle %s a été désactivée\\n"%rule['desc']
    regles.save(rules)
    if amon_tools.bastion_restart():
        message += "Le pare-feu a été redémarré."
    else:
        message += "Erreur au redémarrage du pare-feu."
    return dict(message=message)
