# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Eole - 2015 (Ministère Écologie - CPII)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action quota_disk*
#
# Modifie les quotas
#
###########################################################################

"""Actions permettant de gérer les quotas"""
from twisted.python import log
from fichier.quota import set_user_quota, get_user_quota, set_group_quota, get_group_quota, is_quota
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M, form as F, ajax
from ead2.backend.actions.esbl import quota_tools as Q
from ead2.lib.error import MissingKey, MissingValue, \
BadPassword, BadLogin, BadDriveLetter

titre = 'Quota disque'
used_templates = ['form', 'main', 'formselect', 'listlist',
                  'accordion', 'checklist']

def _get_groups():
    """ renvoie la liste des groupes """
    try:
        grs = Q.getent_groups()
    except:
        grs = []
    return grs

def _get_users():
    """ renvoie la liste des utilisateurs """
    try:
        usrs = Q.getent_users()
    except Exception as e:
        print e
        usrs = []
    return usrs


class QuotaDiskUser(Action):
    """ modification d'utilisateur """
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'quota_disk_user'
    libelle = "Quota disque utilisateur"
    category = "Outils/Quota"
    description = 'quota disque pour un utilisateur'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'current_user'])
    form_result = Dict(default={},
                       doc="retour de formulaire en Json",
                       keys=['user',])

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - Tente de récupérer le nom de l'utilisateur
                en cours de traitement
            2 - Renvoie le formulaire de modification utilisateur
            3 - Traite le retour formulaire et valide la
                modification d'utilisateur
        """
        params, self.server_nb = tools.get_request(self.request)
        self.current_user = ''
        ## 3 -
        if self.form_result != {}:
            try:
                datas = self.modify_user(self.form_result)
                datas['toexec'] = ajax.call(self.server_nb, self.name,
                                            current_user=self.current_user)
            except (Exception, MissingKey, MissingValue, BadPassword) as mess:
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='quota_user',
                                  templates=used_templates)
        ## 1 -
        if 'current_user' in params.keys():
            self.current_user = params['current_user'][0]
        ## 2 -
        menu = Q.get_quota_menu(self.server_nb, self.name)
        sstitre = self.description
        result = {'sstitre':sstitre,
                  'titre':titre,
                  'menus':menu}
        result.update(self._get_form())
        return self.send_all(result,
                             template='quota_user',
                             templates=used_templates)

    def _get_form(self):
        """ renvoie les données pour le formulaire de modification utilisateur """
        usrs = _get_users()
        # choix du nom de user
        onchangelink = 'this.options[this.selectedIndex].value'
        user_name = F.Select(name='user_name',
                             libelle="Nom de l'utilisateur",
                             onchange=ajax.call(self.server_nb,
                                                self.name,
                                                js_args=True,
                                                current_user=onchangelink))

        if not self.current_user: # on a pas encore choisi de user
            default = ''
            user_name.add_option(default, default=True)
            for usr in usrs:
                user_name.add_option(usr)
            return dict(user_select=user_name)
        else:
            usrs.remove(self.current_user)
            default = self.current_user
        user_name.add_option(default, default=True)
        for usr in usrs:
            user_name.add_option(usr)

        datas = self._get_user_data()
        # quota
        current_quota = datas.get('current_quota', '')
        quota = F.Input('quota', "Quota utilisateur",
                        default=current_quota, inline=True)

        return dict(user_select=user_name,
                    quota=quota,
                    validate=self._get_valid_btn(),)

    def modify_user(self, dico):
        """ modifie les attributs d'un utilisateur depuis un dico de type: {'user':dico de modif, 'unactive':, 'active':}
            :user:
                :user_name: nom de l'utilisateur
                :quota:
        """
        # recuperation du formulaire
        if not dico.has_key('user'):
            raise MissingKey, "Erreur : il manque des données pour la validation de formulaire."
        recup = tools.format_form_result(dico['user'], True)
        # recuperation du nom d'utilisateur
        self.current_user = recup['user_name']
        if not self.current_user:
            raise Exception, "Erreur : il manque le nom de l'utilisateur dont le quota est à modifier."
        message="Le quota pour l'utilisateur %s a bien été modifié" % self.current_user
        # recuperation des infos utilisateurs
        user_datas = self._get_user_data()

        # modification du quota de l'utilisateur
        quota = recup.get('quota', None)
        if quota != None and quota != user_datas.get('current_quota', ''):
            if not is_quota(quota):
                raise Exception, "Erreur : Le quota doit être un nombre."
            if set_user_quota(self.current_user, quota) != 0:
                raise Exception, "Erreur : erreur d'attribution de quota."
        return dict(message=message)

    def _get_user_data(self):
        """ renvoie les attributs de user """
        user = self.current_user
        if not user:
            return {}
        quota = get_user_quota(user)
        return {'current_quota':str(quota)}

    def _get_valid_btn(self):
        """ renvoie la description du bouton valider """
        href = ajax.valid(self.server_nb, self.name,
                        ['user',],
                        'user_msg_div_container')
        return M.Bouton(href=href,
                        libelle="Valider",
                        title="Modifier le quota")

class QuotaDiskGroup(Action):
    """Modification des quotas disque pour les groupes"""
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'quota_disk_group'
    libelle = "Quota disque groupe"
    category = "Outils/Quota"
    description = 'quota disque pour un groupe'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'current_user'])
    form_result = Dict(default={},
                       doc="retour de formulaire en Json",
                       keys=['group',])

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - Tente de récupérer le nom de l'utilisateur
                en cours de traitement
            2 - Renvoie le formulaire de modification utilisateur
            3 - Traite le retour formulaire et valide la
                modification d'utilisateur
        """
        params, self.server_nb = tools.get_request(self.request)
        self.current_group = ''
        ## 3 -
        if self.form_result != {}:
            try:
                datas = self.modify_user(self.form_result)
                datas['toexec'] = ajax.call(self.server_nb, self.name,
                                            current_user=self.current_user)
            except (Exception, MissingKey, MissingValue, BadPassword), mess:
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='quota_group',
                                  templates=used_templates)
        ## 1 -
        if 'current_user' in params.keys():
            self.current_group = params['current_user'][0]
        ## 2 -
        menu = Q.get_quota_menu(self.server_nb, self.name)
        sstitre = self.description
        result = {'sstitre':sstitre,
                  'titre':titre,
                  'menus':menu}
        result.update(self._get_form())
        return self.send_all(result,
                             template='quota_group',
                             templates=used_templates)

    def _get_form(self):
        """ renvoie les données pour le formulaire de modification utilisateur """
        grps = _get_groups()
        # choix du nom de user
        onchangelink = 'this.options[this.selectedIndex].value'
        group_name = F.Select(name='group_name',
                             libelle="Nom du groupe",
                             onchange=ajax.call(self.server_nb,
                                                self.name,
                                                js_args=True,
                                                current_user=onchangelink))

        if not self.current_group: # on a pas encore choisi de user
            default = ''
            group_name.add_option(default, default=True)
            for grp in grps:
                group_name.add_option(grp)
            return dict(group_select=group_name)
        else:
            grps.remove(self.current_group)
            default = self.current_group
        group_name.add_option(default, default=True)
        for grp in grps:
            group_name.add_option(grp)

        datas = self._get_group_data()

        # quota
        current_quota = datas.get('current_quota', '')
        quota = F.Input('quota', "Quota groupe",
                        default=current_quota, inline=True)

        return dict(group_select=group_name,
                    quota=quota,
                    validate=self._get_valid_btn(),)

    def modify_user(self, dico):
        """ modifie les attributs d'un utilisateur depuis un dico de type: {'user':dico de modif, 'unactive':, 'active':}
            :user:
                :user_name: nom de l'utilisateur
                :quota:
        """
        # recuperation du formulaire
        if not dico.has_key('group'):
            raise MissingKey, "Erreur : il manque des données pour la validation de formulaire."
        recup = tools.format_form_result(dico['group'], True)
        # recuperation du nom d'utilisateur
        self.current_user = recup['group_name']
        if not self.current_user:
            raise Exception, "Erreur : il manque le nom du groupe dont le quota est à modifier."
        message="Le quota du groupe %s a bien été modifié" % self.current_user
        # recuperation des infos utilisateurs
        user_datas = self._get_group_data()

        # modification du quota de l'utilisateur
        quota = recup.get('quota', None)
        if quota != None and quota != user_datas.get('current_quota', ''):
            if not is_quota(quota):
                raise Exception, "Erreur : Le quota doit être un nombre."
            elif set_group_quota(self.current_user, quota) != 0:
                raise Exception, "Erreur : erreur d'attribution de quota."
        return dict(message=message)

    def _get_group_data(self):
        """ renvoie les attributs de user """
        group = self.current_group
        if not group:
            return {}
        quota = get_group_quota(group)
        return {'current_quota':str(quota)}

    def _get_valid_btn(self):
        """ renvoie la description du bouton valider """
        href = ajax.valid(self.server_nb, self.name,
                        ['group',],
                        'user_msg_div_container')
        return M.Bouton(href=href,
                        libelle="Valider",
                        title="Modifier le quota")

