# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action gestion_account_suppr
#
# Force la suppression des comptes du domaine
#
###########################################################################
""" Actions permettant la suppression de compte du domaine """
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.tools import get_request, make_form_link, \
make_confirm_link, format_form_result, make_js_link
from ead2.backend.actions.horus import gestion_tools as G
from horus import backend as horus

titre = 'Gestion des comptes Machines'

class GestionAccountDelete(Action):
    """ gere la suppression de partage """
    user_description = Dict(default={}, doc="description de l'éxécutant",
            keys=['ip', 'name', 'role'])
    name = 'gestion_account_suppr'
    libelle = "Machines"
    category = "Gestion"
    description = 'Supprimer un compte machine'
    request = Dict(default={},
            doc="arguments de la requete en cours cote frontend",
            keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
            keys=['account'])

    def execute(self):
        """ renvoit les données pour l'affichage
            1 - renvoie le formulaire (select)
            2 - supprime le compte
        """
        params, server_nb = get_request(self.request)
        menu = [{"href":"", "title":'', 'icone':'/image/del_account.gif',
            'libelle':"Suppression de compte"}]
        sstitre = self.description
        ## 2 -
        if self.form_result != {}:
            try:
                result = self.del_account(self.form_result)
                result['toexec'] = make_js_link(server_nb, self.name)
            except Exception, mess:
                result = dict(message=mess.message)
            self.form_result = {}
            return self.send_frag(result, template='horus_gestion_account',
                    templates=['main', 'formselect'])

        ## 1 -
        result = {'sstitre':"",
                  'titre':self.description,
                  'menus':menu}
        result['retour']  = G.get_return_btn(server_nb)
        result.update(self._get_form())
        result['validate'] = self._get_valid_btn(server_nb)
        return self.send_all(result, template='horus_gestion_account',
                templates=['main', 'formselect'])

    def _get_form(self):
        """ renvoie la description d'une balise select
        pour la selection d'un poste à supprimer """
        postes = {'name':'account_name',
                 'options':[{'name':'',
                            'options':[{'name':poste, 'libelle':poste} for poste in horus.get_workstations()]}],
                 'libelle':'Comptes enregistrés'}
        return dict(postes=postes)

    def del_account(self, dico):
        """ supprimer un compte """
        if not dico.has_key('account'):
            raise Exception, "Il manque des données pour la suppression de compte."
        result = format_form_result(dico['account'])
        if not result.has_key('account_name') or result['account_name'] == '':
            raise Exception, "Aucun compte n'a été sélectionné pour suppression."
        compte = result['account_name']
        if not horus.del_workstation(compte):
            raise Exception, "Erreur : une erreur s'est produite à la suppression du compte."
        return dict(message="Le compte %s a bien été supprimé." % compte)

    def _get_valid_btn(self, server_nb):
        """ renvoit la description du bouton valider """
        validate = {}
        href = make_form_link(server_nb, self.name, False, ['account'],
                balise='msg_container')
        validate['href'] = make_confirm_link("Êtes-vous sûr de vouloir supprimer ce compte?", href)
        validate['icone'] = "/image/ok.gif"
        validate['libelle'] = "Valider"
        validate['title'] = "Supprimer ce compte"
        return validate

