#-*-coding:utf-8-*-
"""
   Utilitaires de rangement
"""

def store_by_keys(dict_list, keynames):
    """
        keynames : ((clé1, str_tmpl1),...) où clé est une clé de dico et str_tmpl un template
                                                               pour le nom de la nouvelle clé
        dict_list : liste de dictionnaire ayant clé1,clé2... dans leur clé

        Crée un dico
        {str_tmpl1 % 'val1':{str_tmpl2 % 'val2':
                        [item ayant pour valeur val1 pour la clé1 et val2 pour la clé2]}}

    """
    for key, str_tmpl in keynames:
        dict_list = store_by_key(dict_list, (key, str_tmpl))
    return dict_list

def store_by_key(dict_list, (keyname, str_tmpl)):
    """
        dict_list : list de dictionnaire
        keyname: clé à utiliser pour le rangement
        store_func: fonction utilisée pour trier les sous-listes

        Renvoie un dictionnaire
        {str_tmpl % value:[item tel que item[keyname] == value]}

    """
    stored_items = dict()
    if isinstance(dict_list, list):
        for item in dict_list:
            newkey = str_tmpl % item[keyname]
            stored_items.setdefault(newkey, []).append(item)
        return stored_items
    elif isinstance(dict_list, dict):
        for key, value in dict_list.items():
            dict_list[key] = store_by_key(value, (keyname, str_tmpl))
        return dict_list
