# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action bande_passante
#
# Permet de tester la bande passante
#
###########################################################################
""" Action de test de bande passante """

from twisted.python import log
from ead2.backend.lib.action import * # import des actions et des types
from ead2.backend.actions.tools import get_request, make_form_link
from ead2.backend.actions.tools import format_form_result
from ead2.backend.config.filenames import bande_passante

from ead2.backend.actions.lib.bp_test.client_bp import defer_connect
from ead2.backend.actions.amon import amon_tools as t
import datetime
import time
from os.path import isfile

#template ( widgets utilises pour la mise en forme)
used_templates = ['main', 'form', 'formselect', 'accordion']
## tableau de débit en Kb/s
ref_debits = [("Modem 56 Kbps (7 Ko/s)", 7, "#ffa904"),
          ("Câble/ADSL/Numéris 128 Kbps (16 Ko/s)", 16, "#ffa904"),
          ("Câble 256 Kbps (32 Ko/s)", 32, "#ffa904"),
          ("Câble/ADSL 512 Kbps (64 Ko/s)", 64, "#ffa904"),
          ("Câble 1024 Kbps (128 Ko/s)", 128, "#ffa904"),
          ("Câble/ADSL/T1 1500 Kbps (187.5 Ko/s)", 187.5, "#ffa904"),
          ("Câble/ADSL 2 Mbps (256 Ko/s)", 256, "#ffa904"),
          ("Câble/ADSL 5 Mbps (640 Ko/s)", 640, "#ffa904"),
          ("Câble/ADSL 8 Mbps (1 Mo/s)", 1024, "#ffa904"),
          ("Câble/ADSL 20 Mbps (2.5 Mo/s)", 2560, "#ffa904")]


bp_record = bande_passante['record']

def write_bp_config(ip, port):
    """ ecrit la configuration du serveur de bande passante """
    bp = file(bande_passante['server'],'w')
    bp.write('%s:%s'%(ip, port))
    bp.close()
    return True

def read_bp_config():
    """ renvoie la configuration du serveur de bande passante """
    if isfile(bande_passante['server']):
        conf = file(bande_passante['server']).read().splitlines()[0]
        ip, port = conf.split(':')[0], conf.split(':')[1]
        return ip, port
    return None


class BandePassante(Action):
    """ interface de test de bande passante """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'bande_passante'
    libelle = "Bande passante"
    description = "Testeur de bande passante"
    category = "Outils"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                                keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                                     keys = ['bp_server'])
    def execute(self):
        """ renvoie les données pour la mise en forme
            1 - renvoie un formulaire
            2 - valide le formulaire
            3 - teste la bande passante et renvoie le résultat, le graphe et l'historique
        """
        params, self.server_nb = get_request(self.request)
        self.bp_ip, self.bp_port, self.bp_test, self.dico = [None, None, False, None]
        self.result = {'titre': self.description}
        ## 2 -
        if self.form_result != {}:
            self._valid_form()
            self.form_result = {}
        self.result.update(self._get_form())
        self.result['message'] = "Cet outil vous permet de tester la connexion entre votre serveur et un serveur de bande passante."
        ## 3 -
        if self.bp_test and None not in [self.bp_ip, self.bp_port]:
            a = self.test_bp()
            a.addCallback(self.deferred_record)
            a.addCallback(self.deferred_send)
            a.addErrback(self.error)
            return a
        ## 1 -
        self.result['resultat'] = {}
        self.result['validate'] = {'href':make_form_link(self.server_nb, self.name, True, ['bp_server']),
                'icone':'/image/amon/ok.gif', 'libelle':'Tester', 'title':"Tester à l'aide du serveur"}
        recorded = t.get_lines(bp_record)
        if len(recorded)>3:
            recorded = recorded[-3:]
        self.result['last'] = [{'up':val.split(':')[0], 'down':val.split(':')[1], "date":val.split(':')[2]} for val in recorded]
        self.result['last'].reverse()
        return self.send_all(self.result, template='amon_bande_passante', templates=used_templates)

    def deferred_record(self, deferred_datas):
        """
        Traitement du résultat du test de bande passante
        """
        ## construction de la date
        a = datetime.date.today()
        month_list = ["", "janvier", "février", "mars", "avril", "mai", "juin", "juillet",
                        "aout", "septembre", "octobre", "novembre", "décembre"]
        hour = "%s h %s" % (time.localtime()[3], time.localtime()[4])
        date = "Test effectué le %s %s à %s" % (a.day, month_list[a.month], hour)
        ## conversion en Kb/s
        bit_up = self.dico['up'] * 8
        bit_down = self.dico['down'] * 8
        if bit_down > 8*1024:
            my_down = "Votre ligne %.1f Mb/s (%.1f Mo/s)" % (bit_down/1024, self.dico['down']/1024)
        else:
            my_down = "Votre ligne %.2f Kb/s (%.2f Ko/s)" % (bit_down, self.dico['down'])

        ## insertion du débit local dans la liste de débit de référence
        debits = [a for a in ref_debits]
        for num, deb in enumerate(debits):
            if self.dico['down'] < deb[1]:
                debits.insert(num, (my_down, self.dico['down'], "#344af1"))
                break
            elif (num+1) == len(debits):
                debits.append((my_down, self.dico['down'], "#344af1"))
                break
        self.result['debits'] = debits
        up = "%.2f (Kb/s) ou  %.2f (Ko/s)" % (bit_up, self.dico['up'])
        down = "%.2f (Kb/s) ou  %.2f (Ko/s)" % (bit_down, self.dico['down'])
        self.result['resultat'] = {"up":up, 'down':down}
        recorded = t.get_lines(bp_record)
        ## Le fichier conserve les 50 derniers essais
        tokeep = recorded[-49:]
        tokeep.append('%s:%s:%s' % (up, down, date))
        t.write_file(bp_record, tokeep)
        ## L'historique affiche les 3 essais précédents
        self.result['last'] = [{'up':val.split(':')[0], 'down':val.split(':')[1], "date":val.split(':')[2]} for val in recorded[-3:]]
        self.result['last'].reverse()
        return

    def deferred_send(self, deferred_datas):
        """ fonction renvoyant l'affichage lors de la réussite du test de bande passante """
        self.result['validate'] = {'href':make_form_link(self.server_nb, self.name, True, ['bp_server']),
                'icone':'/image/amon/ok.gif', 'libelle':'Tester', 'title':"Tester à l'aide du serveur"}
        return self.send_all(self.result, template='amon_bande_passante', templates=used_templates)

    def error(self, deferred_error):
        log.err("Erreur : bande_passante.py, %s"%deferred_error)
        self.result['resultat'] = {"up":"Une erreur est survenue le serveur de bande passante ne répond pas.", 'down':""}
        recorded = t.get_lines(bp_record)
        if len(recorded)>3:
            recorded = recorded[-3:]
        self.result['last'] = [{'up':val.split(':')[0], 'down':val.split(':')[1], "date":val.split(':')[2]} for val in recorded]
        self.result['validate'] = {'href':make_form_link(self.server_nb, self.name, True, ['bp_server']),
                'icone':'/image/amon/ok.gif', 'libelle':'Tester', 'title':"Tester à l'aide du serveur"}
        return self.send_all(self.result, template='amon_bande_passante', templates=used_templates)

    def _get_form(self):
        ip = {'name':'ip', 'onblur':"testVoid('ip', 'error_ip')",
                    'libelle':"Ip ou nom du serveur de bande passante"}
        port = {'name':'port', 'onblur':"testNumber('port', 'error_port')",
                    'libelle':"Port du serveur de bande passante"}
        test = {'default_value':'test', 'name':'test'}
        if read_bp_config() != None:
            self.bp_ip, self.bp_port = read_bp_config()
            ip['default_value'] = self.bp_ip
            port['default_value'] = self.bp_port
        return dict(ip=ip, port=port, test=test)

    def _valid_form(self):
        """ valide la configuration du port et de l'url """
        if not self.form_result.has_key('bp_server'):
            return ''
        result = format_form_result(self.form_result['bp_server'])
        if result.has_key('ip'):
            self.bp_ip = result['ip']
            if result.has_key('port'):
                self.bp_port = result['port']
                write_bp_config(self.bp_ip, self.bp_port)
                if result.has_key('test'):
                    self.bp_test = True
                return True
        return False

    def ret(self, dico):
        self.dico = dico
        up, down = dico['up'], dico['down']
        return dico

    def err(self, toto):
        log.err("Erreur: bande_passante.py, erreur lors du test de bande passante %s"%toto)
        return ''

    def test_bp(self):
        if [self.bp_ip, self.bp_port] != [None, None]:
            a = defer_connect(self.bp_ip, self.bp_port)
            a.addCallback(self.ret)
            a.addErrback(self.err)
            return a
        self.dico = ''
