# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
###########################################################################
"""
Librairie pour la gestion des imprimantes
"""
import commands
from ead2.backend.config.filenames import printers_conf

# script shell de gestion des imprimantes
printer_script = printers_conf['script']

def _parse_printers(printers_str):
    """ parse le résultat du script /usr/share/ead/printers.sh all
        les tests s'effectue sur les deux langues (an et fr)
        normalement dans l'ead2 c'est fr.
    """
    printers = []
    printer = {}
    for line in printers_str.splitlines():
        line = line.strip()
        # à noter l'apostrophe exceptionnel !
        if line.startswith("printer") or line.startswith("l’imprimante"):
            if printer != {}:
                printers.append(printer)
                printer = {}
            elt = line.split()
            printer_name = elt[1]
            printer['name'] = printer_name
            if "disabled" in line or "désactivée" in line:
                printer['stopped'] = 'ok'
            elif "idle" in line or "ne fait rien" in line:
                printer['stopped'] = "idle"
            else:
                printer['stopped'] = ""
        elif line.startswith('Description'):
            description = line[13:].strip()
            if "No Information Available" in description:
                printer['description'] = "Description : %s" % printer_name
            else:
                printer['description'] = line
        elif line.startswith('Location') or line.startswith('Emplacement'):
            lieu = line.split(':')[1]
            if 'Location Unknown' in lieu:
                printer['lieu'] = "Emplacement non renseigné"
            else:
                printer['lieu'] = "Emplacement : %s" % lieu
    if printer != {}:
        printers.append(printer)
    return printers

def _get_printers():
    """ renvoie la description des imprimantes disponibles """
    cmd = "%s all 2>&1" % printer_script
    return_code, printers_str = commands.getstatusoutput(cmd)
    if return_code:
        raise Exception, "Erreur à la récupération de la liste des imprimantes."
    printers = _parse_printers(printers_str)
    return printers

def stop_printer(printer_name):
    """ stoppe une imprimante """
    cmd = "%s disable %s 2>&1" % (printer_script, printer_name)
    return_code, return_str = commands.getstatusoutput(cmd)
    if return_code:
        raise Exception, "Erreur à l'arrêt de l'imprimante %s, \\n %s" % (printer_name, return_str)
    # on controle que ça a marché
    printers = _get_printers()
    for printer in printers:
        if printer['name'] == printer_name:
            if printer['stopped'] != 'ok':
                return "Compte rendu de l'arrêt de %s \\n Erreur : vérifiez votre configuration." % printer_name
    return "Compte rendu de l'arrêt de %s \\n Réussite de l'arrêt de l'imprimante" % printer_name

def start_printer(printer_name):
    """ démarre une imprimante """
    cmd = "%s enable %s 2>&1" % (printer_script, printer_name)
    return_code, return_str = commands.getstatusoutput(cmd)
    if return_code:
        raise Exception, "Erreur au redémarrage de l'imprimante %s, \\n %s" % (printer_name, return_str)
    # on controle que ça a marché
    printers = _get_printers()
    for printer in printers:
        if printer['name'] == printer_name:
            if printer['stopped'] == 'ok':
                return "Compte rendu du démarrage de %s. \\n Erreur : vérifiez votre configuration." % printer_name
    return "Compte rendu du démarrage de %s. \\n Réussite du démarrage de l'imprimante." % printer_name

def _get_printers_job(printer_name=None, completed=False):
    """ renvoie la liste des travaux pour printer_name
        :completed:True/False  <travaux terminé>/<travaux en cours>
    """
    jobs = []
    if completed:
        cmd = "%s completed" % printer_script
    else:
        cmd = "%s not-completed" % printer_script
    if printer_name:
        cmd += " %s 2>&1" % printer_name
    else:
        cmd += " 2>&1"
    return_code, return_str = commands.getstatusoutput(cmd)
    if return_code not in [256, 0]:
        raise Exception, "Erreur lors de la récupération des travaux sur %s." % printer_name
    for job in return_str.splitlines():
        job = job.split()
        user = job[1]
        printid = job[0]
        date = job[3] + ' ' + job[4] + ' ' + job[5] + ' ' + job[6]
        heure = job[7]
        jobs.append({'user':user, 'date':date, 'printid':printid, 'heure':heure})
    return jobs

def cancel_print(printid):
    """ annulation d'un travail d'impression """
    cmd = "%s cancel %s" % (printer_script, printid)
    return_code, return_str = commands.getstatusoutput(cmd)
    if return_code:
        raise Exception, "Erreur lors de l'annulation de %s" % printid
    return "L'impression %s a bien été annulée." % printid


