#-*-coding:utf-8-*-
"""
    Gestionnaire de magic number
"""
from twisted.internet import reactor

from ead2.config.config import (MAGIC_NUMBER_TIMEOUT,
                                      EXPIRED_SESSION_TIMEOUT)
from ead2.lib.crypto import create_key
from ead2.lib.i18n_backend import _

EXPIRE_SESSION = "Fin de la session pour le magic_number : %s"
PURGE_SESSION = "Purge des traces de la session pour le magic_number : %s"

def get_login(datas):
    """
        Renvoie un login en fonction
        des données utilisateurs transmises
    """
    print(datas)
    if 'user' in datas.keys():
        username = datas['user'][0]
    elif 'uid' in datas.keys():
        username = datas['uid'][0]
    elif 'pam' in datas.keys():
        username = datas['pam']
    else:
        username = _("Unknown")
    print username
    return username

class Avatar:
    """
        Représentation d'un user dans une session
    """
    __userdatas = None
    __userlogin = None
    def __init__(self, datas, def_login):
        """
            @datas: données utilisateurs obtenues à l'authentification
        """
        self.__userdatas = datas
        if datas:
            self.__userlogin = get_login(datas)
        else:
            self.__userlogin = def_login

    def get_datas(self):
        return self.__userdatas

    def get_login(self):
        return self.__userlogin

class Magic(dict):
    """
        Gère les magic numbers
    """
    expired = []
    current = {}
    _languages = {}
    _app_tickets = {}

    def store(self, magic_number, (data, identifier), language, app_ticket=None):
        """
            store session infos
        """
        defered = reactor.callLater(MAGIC_NUMBER_TIMEOUT, self._remove,
                                                          magic_number)
        user = Avatar(data, identifier)
        self.current[magic_number] = [defered, user, identifier]
        self._languages[magic_number] = language
        self._app_tickets[magic_number] = app_ticket

    def get_data(self, magic_number):
        """
            Renvoie les datas stockés dans la session pour le mn donné
        """
        return self.get_user(magic_number).get_datas()

    def get_username(self, magic_number):
        """
            Renvoie le username associé à la session du magic number donné
        """
        return self.get_user(magic_number).get_login()

    def get_user(self, magic_number):
        """
            Renvoie l'avatar associé à la session courante
        """
        return self.current.get(magic_number)[1]

    def get_identifier(self, magic_number):
        """
            Renvoie l'identifiant stocké dans la session pour le mn donné
        """
        return self.current.get(magic_number)[2]

    def create(self, app_ticket, app_path):
        """
            Renvoie un magicnumber
        """
        return create_key(app_ticket, app_path)

    def lang(self, magic_number):
        """
            Renvoie la langue de la session liée au magic_number donné
        """
        return self._languages[magic_number]

    def check(self, magic_number):
        """
            Vérifie si le magic_number est bon
        """
        if magic_number in self.current.keys():
            self._renew(magic_number)
            return True
        else:
            return False

    def check_expired(self, magic_number):
        """
            Vérifie si le magic_number invalide est expiré
        """
        if magic_number in self.expired:
            return True
        else:
            return False

    def remove_ticket(self, app_ticket):
        """
            supprime un ticket d'application et invalide la session associée
        """
        for magic_number, app_t in self._app_tickets.items():
            if app_t == app_ticket:
                self._remove(magic_number)
                del(self._app_tickets[magic_number])
                return True
        return False

    def _renew(self, magic_number):
        """
            Remet le timeout d'un magic number à zéro
        """
        if magic_number in self.current.keys():
            defered = self.current[magic_number][0]
            defered.cancel()
            defered = reactor.callLater(MAGIC_NUMBER_TIMEOUT, self._remove,
                                                              magic_number)
            self.current[magic_number][0] = defered

    def _remove(self, magic_number):
        """
            Enlève un magic number du cache
        """
        print(EXPIRE_SESSION % magic_number)
        if magic_number in self.current.keys():
            #ajoute au cache des sessions expirees
            if magic_number not in self.expired:
                self.expired.append(magic_number)
                reactor.callLater(EXPIRED_SESSION_TIMEOUT,
                                     self._remove_expired, magic_number)
            del(self.current[magic_number])

    def _remove_expired(self, magic_number):
        """
            Supprime un magic_number du cache des sessions expirées
        """
        print(PURGE_SESSION % magic_number)
        if magic_number in self.expired:
            self.expired.remove(magic_number)
            del(self._languages[magic_number])
            del(self._app_tickets[magic_number])
