# -*- coding: utf-8 -*-
"""
    Fonctions utiles

"""
import socket
from twisted.python import log
from ead2.frontend.web.config import ACTION_SOCKET_TIMEOUT
from ead2.config.config import AUTH_SERVER_ADDR, AUTH_FORM_PORT,  AUTH_FORM_URL, ip_locale
from ead2.frontend.web.config import STYLE_DIR
from os import listdir
from os.path import join, isdir
from nevow import inevow
import urllib2

def get_dispo_styles():
    """ renvoit la liste des styles a choisir
        liste le rep style/choice
    """
    path = join(STYLE_DIR, 'choice')
    if isdir(path):
        files = [f for f in listdir(path) if ('css' in f and '~' not in f)]
        return files
    return []

def url_authform(current_url):
    """ renvoie l'url du formulaire en fonction de la provenance du client
    """
    if AUTH_SERVER_ADDR == ip_locale:
        parsed_url = list(urllib2.urlparse.urlsplit(str(current_url)))
        adress = urllib2.splitport(parsed_url[1])[0]
        return "https://%s:%s" % (adress, AUTH_FORM_PORT)
    else:
        return AUTH_FORM_URL

def _init_session(session, request):
    """
        initialise des paramètres
        de session pour l'ead
        (à purger)
    """
    if not hasattr(session, 'magic_number'):
        session.magic_number = None
    if not hasattr(session, 'language'):
        session.language = 'fr'
    # stockage des design disponibles
    if not hasattr(session, 'styles'):
        session.styles = get_dispo_styles()
    # design de l'EAD (style par défaut)
    if not hasattr(session, 'style'):
        style = request.getCookie('ead2style')
        if style != None :
            # style récupéré dans le cookie
            session.style = style
        else:
            # style par défaut
            session.style = 'main1.css'
        # (re)mise à jour du cookie
        request.addCookie('ead2style', session.style, path='/', max_age=3600*24*365) #1an
   # menu de l'application
    if not hasattr(session, 'menu'):
        session.menu = None
   #identifiant du serveur en cour de traitement (numéro dans la liste)
    if not hasattr(session, 'module_name'):
        session.module_name = None
    if not hasattr(session, 'current_server'):
        session.current_server = None
   # gestion des actions en cour de traitement
    if not hasattr(session, 'current_action'):
        session.current_action = None
    if not hasattr(session, 'current_action_args'):
        session.current_action_args = None
   # variable pour signifier le retour des actions frontend (add_server ...
    if not hasattr(session, 'validate_error'):
        session.validate_error = None
    if not hasattr(session, 'validate_msg'):
        session.validate_msg = None
   #proxy xml-rpc pointant vers le backend
    if not hasattr(session, 'ead_server'):
        session.ead_server = None
    if not hasattr(session, 'role'):
        session.role = None
    return session

def purge_session_params(session):
    """
        purge les variables liées à la session en cour (pour le logout)
    """
    reset_session_params(session)
    session.magic_number = None
    session.role = None
    session.current_action = None
    session.current_action_args = None
    session.current_server = None

def reset_session_params(session):
    """ remet les parametres de session pour la redirection vers la page d'acceuil"""
    session.current_server = None
    session.menu = None
    session.ead_server = None
    session.validate_msg = None

def get_menu(ctx):
    """ gere la recuperation du menu aupres du serveur"""
    session = inevow.ISession(ctx)
    if session.menu is not None:
        return
    code, menu = _get_menu(ctx)
    if code:
        if menu.has_key('role'):
            session.role = menu['role']
            menu.pop('role')
    # si l'on a le menu on le met dans la session
        session.menu = menu
    else:
    # si l'on a pas le menu la premiere fois on retente
        code, menu = _get_menu(ctx)
        if code:
            session.role = menu['role']
            menu.pop('role')
            session.menu = menu

def _get_menu(ctx):
    """
        recupère le menu auprès du serveur
    """
    session = inevow.ISession(ctx)
    if session.ead_server is not None:
        magic_number = session.magic_number
        if magic_number:
            try:
                socket.setdefaulttimeout(ACTION_SOCKET_TIMEOUT)
                code, data = session.ead_server.get_menu(magic_number)
                if data['menu'] == {}:
                    log.err("Le menu renvoyé est vide, l'utilisateur a-t-il des droits ?")
                    return None, {}
            except:
                log.err("Erreur serveur à la récupération du menu")
                return None, {}
            if code in (3, 4):
                log.err("Erreur : %s" % (code,))
                return None, {}
            if code != 0:
                log.err("Erreur Menu %d: %s" % (code, data))
                return None, {}
            try:
                menu = data
                return True, menu
            except:
                log.err("Erreur au chargement du menu => retour à la page d'accueil")
                return None, {}
    log.err( "Il manque des informations dans la session : serveur ou Magic Number")
    return None, {}

def check_logoutrequest(request, check_client = True):
    # valide qu'un message de type logoutRequest reçu est valide
    req_msg = request.args['logoutRequest'][0]
    log.err('logoutRequest : %s' % req_msg)
    expr_search = "<samlp:SessionIndex>%s"
    ticket = False
    # on vérifie que la demande vient bien du serveur d'authentification configuré
    AUTH_IP = socket.gethostbyname(AUTH_SERVER_ADDR)
    if check_client and str(request.getClientIP()) != AUTH_IP:
        log.err('Requête de déconnexion envoyée par un client non autorisé (%s)' % str(request.getClient()))
        return ''
    ticket_format = ('ST-%s', 'PT-%s')
    for ticket in ticket_format:
        if expr_search % (ticket % (AUTH_SERVER_ADDR,),) in req_msg:
            app_ticket = req_msg[req_msg.index('<samlp:SessionIndex>') + 20:req_msg.index('</samlp:SessionIndex>')]
            return app_ticket
    return ''
