# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
# Gere les menus de l'interface
#
###########################################################################
""" fonction de structuration des menus sur amon
    on peut ici configurer quelles actions sont présentées dans quelle rubrique

    par contre, le point d'entrée d'une rubrique est configuré dans les fichiers
    d'action (voir attribut category
"""

from twisted.python import log
from ead2.backend.actions import tools

menu_rules = "p2p", 'horaire'
menu_postes = 'navigation_destination', 'navigation_poste'

def get_postes_menu(server_nb, page, zone):
    return [pages[item]['item'](server_nb, page, zone)for item in menu_postes]

def get_rules_menu(server_nb, page):
    return [pages[item]['item'](server_nb, page)for item in menu_rules]

def get_poste(server_nb,  page, zone):
    item = {'href':tools.make_js_link(server_nb, 'navigation_poste_%s'%zone),
             'libelle':"Sources interdites",
             'icone':'/image/amon/banned_poste.png',
             'title':pages['navigation_poste']['msg']}
    if page == 'navigation_poste':
        item['href'] = ''
    return item

def get_regles(server_nb,  page):
    item = {'href':tools.make_js_link(server_nb, 'regles'),
             'libelle':"Regles de Pare-Feu", 'icone':'/image/amon/regles.png',
             'title':pages['regles']['msg']}
    if page == 'regles':
        item['href'] = ''
    return item

def get_interdits(server_nb,  page, zone):
    item = {'href':tools.make_js_link(server_nb, 'navigation_destination_%s'%zone),
             'libelle':"Destinations interdites", 'icone':'/image/amon/noaccess.png',
              'title':pages['navigation_destination']['msg']}
    if page == 'navigation_destination':
        item['href'] = ''
    return item

def get_p2p(server_nb,  page):
    item = {'href':tools.make_js_link(server_nb, 'peertopeer'),
             'libelle':"Peer to Peer", 'icone':'/image/amon/p2p.png',
              'title':pages['p2p']['msg']}
    if page == 'p2p':
        item['href'] = ''
    return item

def get_horaire(server_nb,  page):
    item = {'href':tools.make_js_link(server_nb, 'horaire'),
             'libelle':"Horaires du pare-feu", 'icone':'/image/amon/hour.png',
              'title':pages['horaire']['msg']}
    if page == 'horaire':
        item['href'] = ''
    return item

def _get_menu(server_nb,  page, zone=None):
    if zone is not None:
        return pages[page]['menu'](server_nb,  page, zone)
    else:
        return pages[page]['menu'](server_nb,  page)

pages = {'navigation_poste':{'msg':"Interdire des Sources (postes)",
                  'menu':get_postes_menu,
                  'item':get_poste},

          'regles':{'msg':"Gestion des règles du Pare-Feu",
                    'menu':get_rules_menu,
                    'item':get_regles},

          'navigation_destination':{'msg':"Interdire des destinations",
                       'menu':get_postes_menu,
                       'item':get_interdits},

          "p2p":{'msg':"Interdiction des échanges de fichiers (peer to peer)",
                 'menu':get_rules_menu,
                 'item':get_p2p},

          'horaire':{'msg':"Horaires d'ouverture du pare-feu",
                     'menu':get_rules_menu,
                     'item':get_horaire},

         }

page_msgs = {'filtres':"Activation des listes de sites optionnelles",
             'filtrage':"Mode de filtrage pour la navigation",
             'blacklist':"Gestion des domaines interdits",
             'whitelist':"Gestion des domaines autorisés",
             "extensions":"Interdictions d'extension",
             "mime":"Interdiction de type mime",
             "whitesitelist":"Ajout de site pour le mode liste blanche",}


def get_filters_menus(server_nb, page, zone):
    """renvoie la description du menu de la section filtrage """
    item1 = {'href':tools.make_js_link(server_nb, 'opt_filters_%s'%zone),
             'libelle':"Listes",
             'icone':'/image/amon/filters.png',
             'title':page_msgs['filtres']}

    item2 = {'href':tools.make_js_link(server_nb, 'filtrage_%s'%zone),
             'libelle':"Mode de filtrage",
             'icone':'/image/amon/filters.png',
             'title':page_msgs['filtrage']}

    item3 = {'href':tools.make_js_link(server_nb, 'sites_interdits_%s'%zone),
             'libelle':'Domaines interdits',
             'icone':'/image/amon/filters.png',
             'title':page_msgs['blacklist']}

    item4 = {'href':tools.make_js_link(server_nb, 'sites_autorises_%s'%zone),
             'libelle':'Domaines autorisés',
             'icone':'/image/amon/filters.png',
             'title':page_msgs['whitelist']}

    item5 = {'href':tools.make_js_link(server_nb, 'extensions_%s'%zone),
             'libelle':'Extensions',
             'icone':'/image/amon/filters.png',
             'title':page_msgs['extensions']}

    item6 = {'href':tools.make_js_link(server_nb, 'mime_%s'%zone),
             'libelle':'Type MIME',
             'icone':'/image/amon/filters.png',
             'title':page_msgs['mime']}

    item7 = {'href':tools.make_js_link(server_nb, 'navigation_whitesitelist_%s'%zone),
            'libelle':'Sites du mode liste blanche',
            'icone':'/image/amon/filters.png',
            'title':page_msgs['whitesitelist']}

    if page == 'filtres':
        item1['href'] = ''
    elif page == 'filtrage':
        item2['href'] = ''
    elif page == 'blacklist':
        item3['href'] = ''
    elif page == 'whitelist':
        item4['href'] = ''
    elif page == 'extension':
        item5['href'] = ''
    elif page == 'mime':
        item6['href'] = ''
    elif page == "whitesitelist":
        item7['href'] = ''
    return [item1, item2, item3, item4, item5, item6, item7, ]
