# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action BareosConfig
#
# Configure des sauvegardes bareos
#
###########################################################################

""" Actions permettant de gérer les sauvegardes bareos """
from twisted.python import log

from pyeole.bareos import load_bareos_support, save_bareos_support_usb, \
        save_bareos_support_smb, save_bareos_support_manual, \
        test_bareos_support, save_bareos_mail, bareos_active_sd,\
        bareos_active_dir, load_bareos_mail
from pyeole.lock import is_locked

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.tool.bareos import USED_TEMPLATES
from ead2.backend.actions.lib.widgets import main as M, form as F, ajax


def bareos_active():
    """
    vérifie si bareos est activé (compatibilité 2.3)
    """
    return (bareos_active_sd() or bareos_active_dir())

class BareosConfig(Action):
    """
    interface de configuration de l'outil de sauvegarde
    """
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'bareos_config'
    libelle = 'Configuration'
    category = 'Sauvegardes'
    description = "configuration de l'outil de sauvegarde bareos"
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'save_type'])
    form_result = Dict(default={}, doc="retour de formulaire",
                       keys=['config1', 'config2', 'config3'])

    def execute(self):
        """ renvoie les donnees pour la mise en forme de l'action
            1 - Récupère le type de sauvegarde à configurer
            2 - Renvoie le formulaire de configuration bareos
            3 - Traite les retours formulaires et configure la sauvegarde
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':self.description}

        if not bareos_active():# bareos est inactif
            datas = dict(message="Le stockage est désactivé\\nLa configuration n'est pas nécessaire",
                         redirect=ajax.call(self.server_nb,
                                            'main_status',
                                             only=False))
            return self.send_all(datas,
                            template='bareos_config',
                            templates=USED_TEMPLATES)
        else:
            ## 1 -
            if bareos_active_sd():
                if params.has_key('save_type'):
                    self.save_type = params['save_type'][0]
                else:
                    sup = load_bareos_support()['support_type']
                    #si sup == none c'est que la sauvegarde n'est pas configurée
                    #dans ce cas, afficher l'onglet smb vide
                    if sup == 'none':
                        sup = 'smb'
                    self.save_type = sup
            ## 3 -
            if self.form_result != {} :

                try:
                    datas = self.modify_conf()
                    datas['toexec'] = tools.make_js_link(self.server_nb,
                                                         self.name,
                                                         confirm=True)
                except Exception, mess:
                    log.err()
                    datas = dict(message=mess.message)
                self.form_result = {}
                return self.send_frag(datas, template='bareos_config',
                                      templates=USED_TEMPLATES)
            ## 2 -
            result['formulaires'] = []
            if bareos_active_sd():
                if self.save_type == '':
                    # smb par défaut
                    self.save_type = 'smb'
                result['formulaires'].extend([{'titre': 'Support de sauvegarde',
                                       'formulaire':self._get_main_form(),
                                       'name':'config1'},
                                      {'titre':'Paramètres de sauvegarde pour : {0}'.format(self.save_type),
                                         'formulaire':self._get_form(),
                                         'name':'config2'}])
                if self.save_type == 'manual':
                    result['entete_bande'] = """<font color=red>La configuration est <b>manuelle</b>.
                                Voir le template 'bareossupport.conf'.</font>"""
            if bareos_active_dir():
                dic_log = {'titre':"Paramètres d'envoi des logs (Facultatif)",
                                          'formulaire':self._get_log_form(),
                                          'name':'config3'}
                if not bareos_active_sd():
                    #si le sd est désactivé, ajout du bouton de validation
                    dic_log['validate'] = self._get_validate_btn()
                result['formulaires'].append(dic_log)
            if bareos_active_sd():
                result['formulaires'].append({'titre': "Test du montage",
                                         'formulaire':self._get_test_form(),
                                         'name':'test',
                                         'validate':self._get_validate_btn()})

            return self.send_all(result,
                                 template='bareos_config',
                                 templates=USED_TEMPLATES)

    def _get_main_form(self):
        """
        renvoie le formulaire pour le choix
        du type de sauvegarde à configurer
        """
        tag = F.Select(name='support',
                       libelle='Support de sauvegarde',
                       inline=True,
                       onchange=ajax.call(self.server_nb,
                                          self.name,
                                          js_args=True,
                                          save_type='this.options[this.selectedIndex].value'))
        possibilities = {'smb':'SMB',
                         'usb':'Disque USB local',
                         'manual':'Configuration manuelle du support'}
        for name, libelle in possibilities.items():
            if name == self.save_type:
                tag.add_option(name, libelle=libelle, default=True)
            else:
                tag.add_option(name, libelle=libelle)
        tag['_type'] = 'choice'
        return [tag]

    def _get_form(self):
        """
        renvoie le formulaire pour configurer
        les sauvegardes du type self.save_type
        """
        conf = load_bareos_support()
        # configuration usb
        if self.save_type == 'usb':
            tag = F.Input(name='usb_periph',
                          libelle="Chemin d'accès",
                          inline=True,
                          required=True)
            if conf['support_type'] == 'usb':
                tag.default(conf['usb_path'])
            tag['_type'] = 'text_input'
            return [tag]
        # configuration distante
        elif self.save_type == 'smb':
            tag1 = F.Input(name='machine',
                    libelle="Nom machine distante",
                    inline=True,
                    required=True)
            tag1['_type'] = 'text_input'
            tag2 = F.Input(name='ipmachine',
                           libelle="IP machine distante",
                           inline=True,
                           required=True)
            tag2['_type'] = 'text_input'
            tag3 = F.Input(name='partage',
                           libelle="Partage",
                           inline=True,
                           required=True)
            tag3['_type'] = 'text_input'
            tag4 = F.Input(name='login',
                           libelle="Login (facultatif)",
                           inline=True)
            tag4['_type'] = 'text_input'
            tag5 = F.Input(name='password',
                           libelle="Mot de passe (facultatif)",
                           inline=True)
            tag5['_type'] = 'password'
            if conf['support_type'] == 'smb':
                tag1.default(conf['smb_machine'])
                tag2.default(conf['smb_ip'])
                tag3.default(conf['smb_partage'])
                tag4.default(conf['smb_login'])
                tag5.default(conf['smb_password'])

            return [tag1, tag2, tag3, tag4, tag5]
        elif self.save_type == 'manual':
            return []

    def _get_log_form(self):
        """ renvoie le formulaire pour la configuration des logs """
        dic = load_bareos_mail()
        if dic == False:
            dic = {}
        mail = ','.join(dic.get('mail_error', []))
        mailok = ','.join(dic.get('mail_ok', []))
        tag1 = F.Input(name='mail',
                        libelle='Mail admin sauvegarde pour les erreurs',
                        inline=True)
        tag1.default(mail)
        tag1['_type'] = 'text_input'
        tag2 = F.Input(name='mailok',
                       libelle='Mail admin sauvegarde',
                       inline=True)
        tag2.default(mailok)
        tag2['_type'] = 'text_input'
        return [tag1, tag2]

    def _get_test_form(self):
        """ renvoie la partie test de la configuration """
        tag = {'_type':'text'}
        if is_locked(name='eolesauvegarde', level='system'):
            diode = '/image/diode_unknown.png'
            retour = "Test impossible : une sauvegarde est en cours"
        else:
            try:
                status, comment = test_bareos_support()
            except Exception as e:
                status = False
                comment = str(e)
            if status == True:
                diode = '/image/diode_on.png'
            else:
                diode = '/image/diode_off.png'
            retour = comment.replace('\n', '<br />')

        tag['text'] = "<img src=\"%s\"/><br/>" % diode
        tag['text'] += u"{0}<br/>".format(retour)
        return [tag]

    def _get_validate_btn(self):
        """
        renvoie la description du bouton valider
        pour le formulaire form_name
        """

        return M.Submit(href=ajax.valid(self.server_nb,
                                        self.name,
                                        ['config1', 'config2', 'config3'],
                                        container='return_msg_container'),
                        libelle="OK")

    def modify_conf(self):
        """
        valide les modifications de configuration de bareos
        """
        message = ''
        if bareos_active_sd():
            if not self.form_result.has_key('config1'):
                raise Exception, "Erreur: il manque des données pour la configuration de bareos."
            self.save_type = self.form_result['config1'][0]['value'] # recuperation du type de support

            if self.save_type != 'manual':
                if not self.form_result.has_key('config2'):
                    raise Exception, "Erreur: il manque des données pour la configuration de bareos."
                datas = tools.format_form_result(self.form_result['config2'])
            try:
                if self.save_type == 'smb': # modification apportees pour 'smb'
                    smb_machine = datas['machine'].strip()
                    smb_partage = datas['partage'].strip()
                    smb_ip = datas['ipmachine'].strip()
                    smb_login = datas['login'].strip()
                    smb_password = datas['password'].strip()
                    save_bareos_support_smb(smb_machine=smb_machine,
                        smb_partage=smb_partage, smb_ip=smb_ip,
                        smb_login=smb_login, smb_password=smb_password)

                elif self.save_type == 'usb': # modification apportees pour 'usb'
                    save_bareos_support_usb(usb_path=datas['usb_periph'])
                elif self.save_type == 'manual':
                    save_bareos_support_manual()
                else:
                    raise "Le type de support {0} est inconnu.".format(self.save_type)
                message = "La configuration de sauvegarde de type {0} a été effectuée.".format(self.save_type)
            except Exception, err:
                message = "Erreur lors de la configuration du support de sauvegarde :\\n\\t"
                message += err.message

        if bareos_active_dir():
            if not self.form_result.has_key('config3'):
                raise Exception, "Erreur: il manque des données pour la configuration de bareos."
            log_datas = tools.format_form_result(self.form_result['config3']) # modification des parametres de log
            mailok = log_datas['mailok'].strip()
            mailerr = log_datas['mail'].strip()
            try:
                save_bareos_mail(mail_ok=mailok, mail_error=mailerr)
                mail_msg = "La configuration des adresses mails a été effectuée."
            except Exception, err:
                mail_msg = "Erreur lors à la configuration des adresses mails :\\n\\t"
                mail_msg += err.message
            if message != '':
                message += '\\n\\n'
            message += mail_msg

        return {'message': message}
