# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action gestion_share*
#
# Cree, Modifie, Supprime les partages
#
###########################################################################
"""Actions permettant de gérer les partages"""
from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.lib.libead import uni
from ead2.backend.actions.horus import gestion_tools as G
from ead2.lib.error import MissingKey, MissingValue, BadShareName, \
BadDriveLetter, BadPath, BadGroupName
from fichier.models import get_share_models
from horus import backend as horus

titre = 'Gestion des partages'
used_templates = ['main', 'form', 'formselect']
spec_shares = ['applidos', 'minedu', 'icones$', 'groupes']

def _get_shares():
    """ renvoit les données pour la présentation des partages existant """
    try:
        datas = horus.get_special_shares()
## les lettres des special shares sont désormais modifiables ...
#        for key, value in datas.items():
#            if key in spec_shares:
#                datas.pop(key)
#                key += " (Réservé eole)"
#                datas[key] = value
    except:
        datas = {}
    return {"message":"Lettres de partages déjà attribuées", "datas":datas}

class GestionShareCreate(Action):
    """ gere la creation de partage """
    user_description = Dict(default={}, doc="description de l'exécutant",
            keys=['ip', 'name', 'role'])
    name = 'gestion_share_create'
    libelle = "Création"
    category = "Gestion/Partages"
    description = 'Créer un partage'
    request = Dict(default={},
            doc="arguments de la requete en cours cote frontend",
            keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
            keys=['share'])
    server_nb = ''

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - renvoie la description du formulaire de renvoi de partage
            2 - valide le retour formulaire et crée le partage
        """
        params, self.server_nb = tools.get_request(self.request)
        ## 2 -
        if self.form_result != {}:
            try:
                #result.update(self.create_share(self.form_result))
                datas = self.create_share(self.form_result)
                datas['toexec'] = tools.make_js_link(self.server_nb,
                        self.name, confirm=True)
            except (Exception, MissingKey, MissingValue, BadDriveLetter), mess:
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            return self.frag(datas)
        ## 1 -
        menu = G.get_share_menu(self.server_nb, self.name)
        result = {'sstitre':self.description, 'titre':titre, 'menus':menu}
        result.update(self._get_form())
        result.update(self._get_valid_btn())
        result['shares'] = _get_shares()
        return self.frag(result)

    def frag(self, result):
        """ renvoie la description d'un fragment de page """
        dico = {'template':'horus_gestion_share',
                'data':{'content':result, 'templates':used_templates}}
        return 0, uni(str(dico))

    def _get_form(self):
        """ renvoit les données pour le formulaire """
        share_name = {'name':'share_name', 'libelle':"Nom du partage",
                        'onblur':"testVoid('share_name', 'error_share_name')",
                        'inline':'ok'}
        group = {'name':'group', 'libelle':"Groupe associé (existant ou non)",
                    'onblur':"testVoid('group', 'error_group')", 'inline':'ok'}
        filepath = {'name':'filepath',
                'libelle':"Chemin spécifique au partage (facultatif,<br /> /home/workgroups/+nom du partage par defaut)",
                'inline':'ok'}
        disque = {'name':'disque', 'libelle':"Lettre de lecteur", 'inline':'ok'}
        sticky_bit = {'name':'sticky_bit', 'value':'on',
                        'libelle':"Activation du sticky bit", 'inline':'ok'}
        models = get_share_models()
        if 'standard' in models:
            models.remove('standard')
        options = [{'name':model, 'libelle':model}for model in models]
        options.append({'name':'standard', 'libelle':'standard', 'default':'ok'})
        model = {'name':'model',
                 'options':[{'name':'modeles', 'options':options}],
                 'libelle':"Modèle de partage", 'inline':'ok'}
        return dict(share_name=share_name, group=group, filepath=filepath,
                    disque=disque, sticky_bit=sticky_bit, model=model)

    def _get_valid_btn(self):
        """ renvoit la description du bouton valider """
        validate = {}
        validate['href'] = tools.make_form_link(self.server_nb, self.name,
                True, ['share'], 'share_msg_div_container')
        validate['icone'] = "/image/ok.gif"
        validate['libelle'] = "Valider"
        validate['title'] = "Créer ce utilisateur"
        validation = tools.make_key_form_link(self.server_nb, self.name,
                False, ['share'], 'share_msg_div_container')
        return dict(validate=validate, validation=validation)

    def create_share(self, dico):
        """ cree un partage
            :dico: dico venant de l'interface
        """
        if not dico.has_key('share'):
            raise MissingKey, "Erreur : il manque des données pour la création du partage."
        params = tools.format_form_result(dico['share'])
        for key in ['share_name', 'group', 'filepath', 'disque', 'model']:
            if key not in params.keys():
                raise MissingKey, "Erreur : il manque des données pour la création du partage."

        nom, group = params['share_name'], params['group']
        if not tools.test_login(nom):
            raise BadShareName
        if not tools.test_login(group):
            raise BadGroupName

        filepath, disque, model = params['filepath'], params['disque'].upper(), params['model']
        if not filepath: filepath = None
        elif not filepath.startswith('/'):
            raise Exception, "Erreur : le chemin est incorrect (ne commence pas par /)."
        elif not tools.test_path(filepath):
            raise BadPath
        if not model: model = None

        # controle de la lettre de lecteur
        if not disque: disque = None
        else:
            if not ':' in disque: disque = disque+':'
            if not tools.test_drive_letter(disque):
                raise BadDriveLetter

            shares = horus.get_special_shares()
            if disque.upper() in [letter.upper()for letter in shares.values()]:
                raise Exception, "La lettre de lecteur est déjà attribuée"

        if params.has_key('sticky_bit'):
            if params['sticky_bit'] == 'on': sticky_bit = True
            else: sticky_bit = False
        else: sticky_bit = False

        if nom and group:
            message = ''
            if group not in horus.get_groups():
                if not horus.add_group(group):
                    raise Exception, "Echec lors de la creation du groupe %s" % group
                else:
                    message = "Le groupe %s a bien été créé.\\n" % group
            if horus.add_share(nom, group, filepath, disque, sticky_bit, model):
                message += "Le partage %s a bien été créé et associé au groupe %s.\\n \\n" % (nom, group)
                if filepath is not None:
                    if not filepath.startswith('/home/') and not filepath.startswith('/data/'):
                        message += "Attention : seuls les répertoires /home et /data supportent les acls.\\nVous avez défini : %s.\\n" % filepath
                return dict(message=message)
            else:
                raise Exception, "%s \\n Erreur : une erreur s'est produite lors de la création du partage %s" % (message, nom)
        else:
            raise MissingValue, "Il manque des paramètres pour la création du partage %s" % nom

class GestionShareModify(Action):
    """ gere la modification de partage """
    user_description = Dict(default={}, doc="description de l'exécutant",
            keys=['ip', 'name', 'role'])
    name = 'gestion_share_modify'
    libelle = "Modification"
    category = "Gestion/Partages"
    description = 'Modifier un partage'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'current_share'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['share'])
    server_nb = ''

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - récupération du nom du partage si défini
            2 - renvoi du formulaire
            3 - validation et modification du partage
        """
        params, self.server_nb = tools.get_request(self.request)
        ## 3 -
        if self.form_result != {}:
            try:
                datas = self.modify_share(self.form_result)
                datas['toexec'] = tools.make_js_link(self.server_nb,
                        self.name, confirm=True,
                        current_share=self.current_share)
            except (Exception, MissingKey, MissingValue, BadDriveLetter), mess:
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            return self.frag(datas)
        ## 1 -
        if 'current_share' in params.keys():
            self.current_share = params['current_share'][0]
        else:
            self.current_share = ''
        ## 2 -
        result = {'sstitre':self.description, 'titre':titre,
                'menus':G.get_share_menu(self.server_nb, self.name)}
        result.update(self._get_form())
        result['shares'] = _get_shares()
        return self.frag(result)

    def frag(self, result):
        """ renvoie la structure de données pour la mise en forme """
        dico = {'template':'horus_gestion_share',
                'data':{'content':result, 'templates':used_templates}}
        return 0, uni(str(dico))

    def _get_form(self):
        """ renvoie les données pour le formulaire """
        try:
            shares_dict = horus.get_shares()
        except:
            shares_dict = {}
        shares = shares_dict.keys()
        shares.sort()

        ## les special shares sont désormais modifiables ...
        #for sharename in spec_shares:
        #    if sharename in shares: shares.remove(sharename)

        ## on a pas choisi de partage
        if not self.current_share:
            options = [{'name':share, 'libelle':share}for share in shares]
            options.append({'name':'', 'libelle':'', 'default':'ok'})
            share_select = {'name':'share_name',
                    'options':[{'name':'partages existants' ,'options':options}],
                    'libelle':"Nom du partage", 'inline':'ok',
                    'onchange':tools.make_js_link(self.server_nb, self.name, code=True,
                                    current_share='this.options[this.selectedIndex].value')}
            return dict(share_select=share_select)

        ## on a choisi
        if self.current_share in shares:
            shares.remove(self.current_share)
        options = [{'name':share, 'libelle':share}for share in shares]
        options.append({'name':self.current_share, 'libelle':self.current_share, 'default':'ok'})
        share_select = {'_type':'choice',
                        'name':'share_name',
                        'options':[{'name':'partages existants','options':options}],
                        'libelle':"Nom du partage",
                        'inline':'ok',
                        'onchange':tools.make_js_link(self.server_nb, self.name, code=True,
                                current_share='this.options[this.selectedIndex].value')}

        letter = shares_dict[self.current_share]
        if letter == 'None' or letter == '':
            letter = 'aucune'
        disque = {'name':'disque', 'libelle':"Lettre de lecteur",
                  'default_value':letter, 'inline':'ok'}

        path = horus.get_share_filepath(self.current_share)
        filepath = {'name':'filepath', 'libelle':"Chemin du partage",
                'default_value':path, 'inline':'ok', 'disabled':'ok'}

        group = horus.get_share_group(self.current_share)
        group = {'name':'group', 'libelle':"Groupe associé",
                'default_value':group, 'inline':'ok', 'disabled':'ok'}
        try:
            models = get_share_models()
            model = horus.get_share_template(self.current_share)
        except:
            models = []
            model = ''
        if model in models:
            models.remove(model)
        options = [{'name':mod, 'libelle':mod}for mod in models]
        options.append({'name':model, 'libelle':model, 'default':'ok'})
        model = {'name':'model', 'options':[{'name':'modeles', 'options':options}],
                                        'libelle':"Modèle de partage", 'inline':'ok'}
        return dict(share_select=share_select, disque=disque, model=model,
                    filepath=filepath, group=group,
                    validate=self._get_valid_btn())

    def _get_valid_btn(self):
        """ renvoit la description du bouton valider """
        validate = {}
        href = tools.make_form_link(self.server_nb, self.name,
                False, ['share'], 'share_msg_div_container')
        validate['href'] = tools.make_confirm_link("Êtes-vous sûr de vouloir modifier ce partage?", href)
        validate['icone'] = "/image/ok.gif"
        validate['libelle'] = "Valider"
        validate['title'] = "Modifier ce partage"
        return validate

    def modify_share(self, dico):
        """ modifie un partage
            :dico: dico venant de l'interface
        """
        if not dico.has_key('share'):
            raise MissingKey, "Erreur : il manque des données pour la validation du formulaire."
        result = tools.format_form_result(dico['share'])
        for key in ['share_name', 'disque', 'model']:
            if key not in result.keys():
                raise MissingValue, "Erreur : il manque des données pour la modification du partage."

        nom = result['share_name']
        if not nom:
            raise Exception, "Erreur: erreur lors de la modification du partage."
        self.current_share = nom

        old_drive = horus.get_shares()[nom]
        drive = result['disque']
        if drive in ('aucune', ''): drive=''
        else:
            if not ':' in drive: drive += ':'
            if not tools.test_drive_letter(drive):
                raise BadDriveLetter
            shares = horus.get_special_shares()
            drive = drive.upper()
            if drive != old_drive:
                if drive in [letter.upper()for letter in shares.values()]:
                    raise Exception, "La lettre de lecteur est déjà attribuée"

        model = result['model']
        if model == '': model = None

        old_model = horus.get_share_template(nom)
        ## le len() == 1 c'est parce qu'il n'existe qu'un type de modèle attribué par défaut à chaque partage.
        if old_drive == drive and old_model == model:
            raise Exception, "Erreur : aucune modification n'a été effectuée."

        if old_drive == drive:
            horus.mod_share(nom, None, model)
        elif old_model == model:
            horus.mod_share(nom, drive)
        else:
            horus.mod_share(nom, drive, model)
        return dict(message="Le partage %s a bien été modifié" % nom)

class GestionShareDelete(Action):
    """ gere la suppression de partage """
    user_description = Dict(default={}, doc="description de l'exécutant",
            keys=['ip', 'name', 'role'])
    name = 'gestion_share_suppr'
    libelle = "Suppression"
    category = "Gestion/Partages"
    description = 'supprimer un partage'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
            keys=['share'])
    server_nb = ''

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - renvoie les données pour la création du formulaire (select)
            2 - valide la suppression du partage
        """
        params, self.server_nb = tools.get_request(self.request)
        ## 2 -
        if self.form_result != {}:
            try:
                datas = self.del_share(self.form_result)
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name)
            except Exception, mess:
                log.err()
                datas = dict(message=mess.message)
            self.form_result = {}
            return self.frag(datas)
        ## 1 -
        menu = G.get_share_menu(self.server_nb, self.name)
        sstitre = self.description
        result = {'sstitre':sstitre, 'titre':titre, 'menus':menu}
        result.update(self._get_form())
        result['validate'] = self._get_valid_btn()
        return self.frag(result)

    def frag(self, result):
        """ renvoie la structure de données pour la mise en forme """
        dico = {'template':'horus_gestion_share',
                'data':{'content':result, 'templates':used_templates}}
        return 0, uni(str(dico))

    def _get_form(self):
        try:
            shares_dict = horus.get_shares()
        except:
            shares_dict = {}
        shares = shares_dict.keys()
        for sharename in spec_shares:
            if sharename in shares: shares.remove(sharename)
        options = [{'name':share, 'libelle':share}for share in shares]
        share_select = {'name':'share_name',
                'options':[{'name':'partages existants', 'options':options}],
                'libelle':"Nom du partage", 'inline':'ok'}
        share_datas = {'name':'share_datas',
                'libelle':'Supprimer les données associées au partage ?',
                'value':'share_datas', 'inline':'ok'}
        return dict(share_select=share_select,
                    share_datas=share_datas)

    def del_share(self, dico):
        """ supprimer un partage """
        if not dico.has_key('share'):
            raise MissingKey, "Il manque des données pour la suppression de partage."

        result = tools.format_form_result(dico['share'], True)

        share_datas = result['share_datas']

        if not result.has_key('share_name'):
            raise MissingValue, "Il manque des données pour la suppression de partage."
        nom = result['share_name']
        if not nom:
            raise MissingValue, "Il manque des données pour la suppression de partage."
        if horus.del_share(nom, rmdir=share_datas):
            return dict(message="Le partage %s a bien été supprimé"%nom)
        else:
            raise Exception, "Erreur : erreur lors de la suppression de partage."

    def _get_valid_btn(self):
        """ renvoit la description du bouton valider """
        validate = {}
        href = tools.make_form_link(self.server_nb, self.name, False,
                ['share'], 'share_msg_div_container')
        validate['href'] = tools.make_confirm_link("Êtes-vous sûr de vouloir supprimer ce partage?", href)
        validate['icone'] = "/image/ok.gif"
        validate['libelle'] = "Valider"
        validate['title'] = "Supprimer ce partage"
        return validate
