# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Librairie pour la gestion des groupes
"""
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M
from scribe.eolegroup import Group
from ead2.lib.error import BadGroupName, MissingKey, MissingValue
from scribe.ldapconf import SUPPORT_ETAB
if SUPPORT_ETAB:
    from ead2.backend.actions.scribe.tool.etablissements import add_etab

# domaines de messagerie (pour liste déroulante)
LISTE_TYPES = (('restreint', "domaine restreint (conseillé)"),
               ("internet", "domaine internet"))

# liste des templates complémentaires utilisés
used_templates = ['main', 'form', 'formselect', 'accordion',
                  'listlist', 'checklist']

# mapping des variables internes avec celles du backend
# et les affichages
typedict = {'niveau':{'libelle':'niveau', 'tgroupe':'Niveau',
                      'message':'du niveau'},
            'matiere':{'libelle':'matière', 'tgroupe':'Matiere',
                       'message':'de la matière'},
            'groupe':{'libelle':'groupe', 'tgroupe':'Groupe',
                       'message':'du groupe'},
            'classe':{'libelle':'classe', 'tgroupe':'Classe',
                       'message':'de la classe'},
            'option':{'libelle':'option', 'tgroupe':'Option',
                       'message':"de l'option"},
            'service':{'libelle':'service administratif', 'tgroupe':'Service',
                       'message':'du service'},
            'equipe':{'libelle':'équipe pédagogique', 'tgroupe':'Equipe',
                       'message':'xx'},
# FIXME : dépend du code de grouplisting.py
#            'responsable': {'libelle':'responsables de classe',
#                        'tgroupe':'Responsables',
#                        'message':'xx'},
            'administration': {'libelle':'groupe spécial',
                         'tgroupe':'Administrateurs',
                         'message':'xx'},
           }
if SUPPORT_ETAB:
    typedict['etablissement'] =  {'libelle': 'établissement',
                    'tgroupe':'Etablissement', 'message': "de l'établissement"}
ordered_list = ['niveau', 'matiere', 'groupe', 'classe', 'option', 'service',
                'equipe', 'administration']
if SUPPORT_ETAB:
    ordered_list.insert(0, 'etablissement')
# FIXME : dépend du code de grouplisting.py
#ordered_list = ['niveau', 'matiere', 'groupe', 'classe', 'option', 'service',
#                'equipe', 'responsable', 'administration']
# 'responsable'

def posh():
    """ renvoie True si posh est installé et actif """
    #la variable n'existe plus depuis la 2.3 ...
    return False
    #return creoledict.get('posh', 'non') == 'oui'

def _get_menu(server_nb, _type=None):
    """ renvoie la description du menu pour la creation de groupes """

    menus = {
     'classe' : {'icone':'/image/scribe/group.gif', 'libelle':"Classe",
               'title':"Créer une classe",
               'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                         _type='classe')},

     'niveau' : {'icone':'/image/scribe/group.gif', 'libelle':"Niveau",
               'title':"Créer un groupe niveau",
               'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                         _type='niveau')},

     'matiere': {'icone':'/image/scribe/group.gif', 'libelle':"Matière",
            'title':"Créer un groupe matière",
            'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                      _type='matiere')},

     'groupe' : {'icone':'/image/scribe/group.gif', 'libelle':"Groupe",
            'title':"Créer un groupe",
            'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                      _type='groupe')},

     'service': {'icone':'/image/scribe/group.gif', 'libelle':"Service",
            'title':"Créer un service administratif",
            'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                      _type='service')},

     'option' : {'icone':'/image/scribe/group.gif', 'libelle':"Option",
            'title':"Créer une option",
            'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                      _type='option')},

     'listgroup': {'icone':'/image/scribe/group.gif',
            'libelle':"Lister des groupes",
            'title':"Lister des groupes",
            "href":tools.make_js_link(server_nb, 'scribe_group_list')},
    }
    if SUPPORT_ETAB:
        menus['etablissement'] = {'icone':'/image/scribe/group.gif', 'libelle':"Etablissement",
               'title':"Créer un établissement",
               'href':tools.make_js_link(server_nb, 'scribe_group_create',
                                         _type='etablissement')}


    if menus.has_key(_type):
        # le choix courant n'est pas cliquable
        menus[_type]['href'] = ''
    else:
        menus['listgroup']['href'] = ''

    ordered_menu = ['niveau', 'classe', 'option', 'matiere', 'service',
                    'groupe', 'listgroup']
    if SUPPORT_ETAB:
        ordered_menu.insert(0, 'etablissement')

    return dict(menus=[menus[menu] for menu in ordered_menu])

def _get_close_btn(balise):
    """ renvoie la description du bouton de fermeture de la section balise """
    href = "javascript:setVoid('%s');" % balise
    return M.Bouton(href=href, libelle="Fermer",
            icone="/image/supprimer.gif", _class="scribe_close_btn")

def groupe_create(form_result, _type, msgs):
    """ crée un groupe autre qu'une classe
        :form_result: résultat de formulaire de type dico avec pour clé:
            'group_name' : nom du groupe
            'share_status' : droits du partage
            'liste_status' : type de liste de diffusion
         et éventuellement:
            'group_desc'  : description du groupe
            'share_check' : association d'un partage?
            'liste_check' : association d'une liste de diffusion?
            'etab' : association avec un établissement (si nécessaire)
        :_type: type de groupe à créer
        :msgs: message associé au groupe à créer
    """
    missing_group_datas = "Erreur : il manque des données pour la création %s"
    if 'group_name' not in form_result.keys():
        raise MissingKey(missing_group_datas % msgs)
    name = form_result['group_name']
    if not tools.test_login(name):
        raise BadGroupName
    # partage et type de partage
    if form_result.has_key('share_check'):
        if _type in ['Matiere', 'Service']:
            share_status = 'rw'
        else:
            try:
                share_status = form_result['share_status']
            except KeyError:
                raise MissingKey(missing_group_datas % msgs)
    else:
        share_status = ''
    if 'etab' in form_result:
        etab = form_result['etab']
    else:
        etab = None
    # liste et domaine
    if form_result.has_key('liste_check'):
        liste_status = form_result['liste_status']
    else:
        liste_status = ''
    desc = form_result.get('group_desc', '')
    grp = Group()
    grp.add(_type, name, domaine=liste_status, partage=share_status, description=desc, etab=etab)
    return "Réussite de l'ajout %s %s." % (msgs, name)

def etab_create(form_result, _type, msgs):
    """ crée un etablissement
        :form_result: résultat de formulaire de type dico avec pour clé:
            'group_name' : nom du groupe
            'share_status' : droits du partage
            'liste_status' : type de liste de diffusion
         et éventuellement:
            'group_desc'  : description du groupe
            'share_check' : association d'un partage?
            'liste_check' : association d'une liste de diffusion?
            'etab' : association avec un établissement (si nécessaire)
        :_type: type de groupe à créer
        :msgs: message associé au groupe à créer
    """
    missing_group_datas = "Erreur : il manque des données pour la création %s"
    if 'group_name' not in form_result.keys():
        raise MissingKey(missing_group_datas % msgs)
    name = form_result['group_name']
    if not tools.test_login(name):
        raise BadGroupName
    # partage et type de partage
    share_status = 'rw'
    # liste et domaine
    if form_result.has_key('liste_check'):
        liste_status = form_result['liste_status']
    else:
        liste_status = ''
    desc = form_result.get('group_desc', '')
    grp = Group()
    add_etab(name)
    grp.add(_type, name, domaine=liste_status, partage=share_status, description=desc)
    grp.add('Base', 'profs-' + name, partage='rw', etab=name, description='profs-' + name)
    grp.add('Base', 'eleves-' + name, etab=name, description='eleves-' + name)
    return "Réussite de l'ajout %s %s." % (msgs, name)


def classe_create(form_result):
    """ ajoute une classe
        :form_result : résultat de formulaire avec pour clé:
            - group_name : nom de la classe
            - level : niveau de la classe
            - liste_status : type de liste de diffusion
         et éventuellement:
            'group_desc'  : description du groupe
    """
    for i in ['group_name', 'level', 'liste_status']:
        if i not in form_result.keys():
            raise MissingKey, "Erreur : Des données manque pour la création de la classe"
    name = form_result['group_name']
    level = form_result['level']
    liste_status = form_result['liste_status']
    if not tools.test_login(name):
        raise BadGroupName
    for i in name, level, liste_status:
        if not i.strip():
            raise MissingValue, "Il manque des valeurs"
    desc = form_result.get('group_desc')
    grp = Group()
    grp.add_classe(name, level, domaine=liste_status, description=desc)
    return "Réussite de l'ajout de la classe %s" % name

