# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# outils pour Bareos
#
###########################################################################

""" Outils permettant de gérer les sauvegardes bareos """

from pyeole.bareos import load_bareos_support, load_bareos_mail, \
        bareos_active_dir, bareos_active_sd, DAY_TO_STRING

from ead2.backend.actions.lib.widgets import form as F

# templates communs
USED_TEMPLATES = ['main', 'formselect', 'form']


def get_bareos_form(pagename):
    """
        renvoie le formulaire adequat
    """
    form = {'level': _level(pagename)}
    if pagename in ('monthly', 'weekly', 'daily'):
        form['begin'] =  _begin_end(name='jourdebut', default='2', pagename=pagename)
        form['hour'] = _hour()
    if pagename == 'daily':
        form['end'] = _begin_end(name='jourfin', default='6', pagename='end')
    if pagename == 'defered':
        form['scheduled_hour'] = _scheduled_hour()
        form['scheduled_minute'] = _scheduled_minute()
    return form

def _level(pagename):
    """
        Renvoie la balise pour la sélection du niveau de mise à jour
    """
    # niveau de mise à jour
    level = F.Select(name='niveau', libelle="type", inline=True)
    level.add_option('Full', libelle='Totale')
    if pagename != 'monthly':
        level.add_option('Differential', libelle='Différentielle')
        level.add_option('Incremental', libelle='Incrémentale')
        # adaptation de la valeur par défaut
        # en fonction de la fréquence sélectionnée (#3966)
        if pagename != 'direct':
            if pagename == 'weekly':
                level.default('Differential')
            else:
                level.default('Incremental')
    return level

def _begin_end(name, default, pagename=None):
    # choix du jour
    if pagename == 'daily':
        message = 'de'
    elif pagename == 'end':
        message = 'à'
    else:
        message = 'dans'
    ret = F.Select(name=name, libelle='{0} la nuit du'.format(message), inline=True)
    for day, libelle in DAY_TO_STRING.items():
        ret.add_option(str(day), libelle=libelle, group='nuit de la semaine')
    ret.default(default, group='nuit de la semaine')
    return ret

def _hour():
    """
        Choix de l'heure
    """
    hour = F.Select(name='heure', libelle='à', inline=True)
    hours = range(12, 24)
    hours.extend(range(12))
    for i in hours:
        hour.add_option(str(i),
                        libelle="%d:00" % i,
                        group='heure de la journée')
    hour.default('21', group='heure de la journée')
    return hour

def _scheduled_now():
    """
        Différé ou maintenant
    """
    when = F.Select(name='scheduled_now', libelle='', inline=True)
    when.add_option('maintenant')
    when.add_option('différée')
    return when

def _scheduled_hour():
    """
        Choix de l'heure
    """
    hour = F.Select(name='scheduled_hour', libelle='à', inline=True)
    hours = range(12, 24)
    hours.extend(range(12))
    for i in hours:
        i = str(i).rjust(2, '0')
        hour.add_option(i, libelle="%s" % i)
    return hour

def _scheduled_minute():
    """
        Choix de l'heure
    """
    minute = F.Select(name='scheduled_minute', libelle=':', inline=True)
    minutes = range(0,60,10)
    for i in minutes:
        i = str(i).rjust(2, '0')
        minute.add_option(i,
                        libelle="%s" % i)
    return minute

def get_days(_day=None):
    """
        renvoie un dico jouranglais:jourfrancais
        accompagné par un tuple décrivant l'ordre
        :day: jour en anglais (dans ce cas ne renvoie que le jour
                                                     en français)
    """
    days = (('mon', 'lundi'), ('tue', 'mardi'),
            ('wed', 'mercredi'), ('thu', 'jeudi'),
            ('fri', 'vendredi'), ('sat', 'samedi'),
            ('sun', 'dimanche'))
    if _day:
        for day, jour in days:
            if day == _day:
                return day, jour
    else:
        return days

def bareos_configured():
    """
        Teste si bareos est configuré
    """
    if bareos_active_sd():
        sup = load_bareos_support()
        if sup['support_type'] == 'none':
            return False
    if bareos_active_dir():
        sup = load_bareos_mail()
        if not load_bareos_mail:
            return False
    return True

def get_niveau(niveau=None):
    """ renvoie un dico : {'niveau': 'libelle'}
        ou la traduction de l'appelation système"""
    dico = {'Level=Incremental':'Incrémentale', 'Level=Full':'Totale', 'Level=Differential':'Differentielle' }
    dico2 = {'Incremental':'Incrémentale', 'Full':'Totale', 'Differential':'Differentielle'}
    if niveau in dico.keys():
        return dico[niveau]
    elif niveau in dico2.keys():
        return dico2[niveau]
    else:
        return dico
