#-*-coding:utf-8-*-
"""
    Outil pour la communication avec des serveurs xmlrpc
"""
import socket

from ead2.lib.libfrontend import ServerParser
from ead2.config.config import AUTH_SERVER_ADDR, AUTH_FORM_PORT
from ead2.frontend.config.config import SERVERS_FILE
from ead2.frontend.web.config import TEST_SOCKET_TIMEOUT

def servers():
    """
        renvoie le parser de fichier gerant la liste des serveurs
    """
    backends = ServerParser(SERVERS_FILE)
    return backends

def is_server_alive(server_ip, server_port):
    """
        Teste si un serveur est alive
    """
    socket.setdefaulttimeout(TEST_SOCKET_TIMEOUT)
    try:
        socket.socket().connect((server_ip, int(server_port)))
        return True
    except socket.error:
        return False
    except:
        return False

def sso_alive():
    """
        teste si le serveur sso est disponible
    """
    if AUTH_SERVER_ADDR:
        return is_server_alive(AUTH_SERVER_ADDR, int(AUTH_FORM_PORT))
    else:
        return False
