# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
###########################################################################
""" Edition des règles du pare-feu """
from twisted.python import log
from ead2.backend.lib.action import *
from ead2.backend.actions import tools
from ead2.backend.actions.amon import regles_form
# templates additionnels
used_templates = ['main', 'form', 'formselect']

class Regles(Action):
    """ Gere les règles optionnelles du pare-feu
    """
    user_description = Dict(default={}, doc="description de l'exécutant", keys=['ip', 'name', 'role'])
    name = "regles_generales"
    libelle = 'Règles du pare-feu'
    description = 'Définir les règles générales du pare-feu'
    category = "Configuration générale"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['mod_regles'])

    def execute(self):
        """
            renvoie les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result.has_key('mod_regles'):
            try:
                datas = regles_form.mod_regles('generales',
                                tools.format_form_result(self.form_result['mod_regles']))
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except:
                log.err()
                datas = dict(message="Erreur à l'activation/désactivation des règles optionnelles")
            self.form_result = {}
            return self.send_frag(datas, template='amon_regles', templates=used_templates)

        result = dict(titre=self.description)
        result.update(regles_form.get_regles_form('generales'))
        result.update(regles_form.get_validate_btn(self.server_nb, self.name))
        return self.send_all(result, template='amon_regles', templates=used_templates)
