# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Importation aaf
"""
from ead2.backend.lib.action import Dict

from ead2.backend.actions.lib.importation.fichier import BaseImportationFichier
from scribe.importation.config import (AAF_FILES,
                                       AAF_FILEVARNAMES)

class ImportationAaf(BaseImportationFichier):
    """
        Importation de type aaf
        Téléchargement / Parsing / Importation
    """
    data_type = 'aaf'
    name = 'scribe_extraction_aaf'
    description = "Importation de fichier AAF"
    libelle = description
    all_file_descriptions = AAF_FILES
    request_keys = ['server',
                    'action',
                    'category_type',
                    'import_type',
                    'data_type',
                    'nomdefichier',
                    'filename',
                    'finished',
                    'parse',
                    'refresh_parse',
                    'importation',
                    'refresh_importation',
                    ]

    # variable de reception du contenu de fichier (original)
    origfilevarnames  = AAF_FILEVARNAMES

    # pool pour les noms de variables de réception
    filevarnames = []
    request_keys.extend(AAF_FILEVARNAMES['eleve'])
    request_keys.extend(AAF_FILEVARNAMES['enseignant'])
    request = Dict(default={}, keys=request_keys)
    file_download_entete = "Importation de '%s' au format : AAF"

