# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action scribe_user*
# Creation d'utilisateur
# Recherche puis modification d'utilisateur
# modfication de mot de passe
# Supression d'utilisateur
#
###########################################################################
"""Action de creation d'un utilisateur
"""
from twisted.python import log
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.actions import tools
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import main as M
from ead2.backend.actions.scribe.tool import usercreate
from ead2.backend.actions.scribe.tool import getform
from ead2.backend.actions.scribe.tool.user import used_templates, _get_menu


class UserCreate(Action):
    """ création d'utilisateur
    :type: type d'utilisateur en cours de création (élève, prof...)
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_user_create'
    libelle = "Création d'utilisateur"
    category = "Gestion/Utilisateurs/"
    description = 'Créer un utilisateur'
    request = Dict(default={},
            doc="arguments de la requete en cours cote frontend",
            keys=['server', 'action', '_type', 'datas'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['add_user', 'current_type'])

    def execute(self):
        """ renvoit les données pour l'affichage
            1 - récupère le type de l'utilisateur à créer
            2 - renvoie le formulaire de création
                le formulaire est conditionné par le role de l'appelant (cas prof_admin)
            3 - renvoie le menu si besoin
            4 - crée l'utilisateur selon le retour formulaire
                a - récupère les données
                b - controle d'intégrité
                c - crée l'utilisateur
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':"Gestion des utilisateurs"}
        ## 1 -
        self._type = 'pupil'
        if params.has_key('_type'):
            self._type = params['_type'][0].strip()

        if params.has_key('datas'): ## on demande que le formulaire
            result = self._get_form()
            result.update(self._get_valid_btn())
            return self.frag(result)

        if self.form_result != {} :
            if self.form_result.has_key('current_type'):
                self._type = tools.format_form_result(self.form_result['current_type'])['_type']
                self.form_result.pop('current_type')
            try:
                result.update(self._valid_form())
                # si on a créé un user, on vide le formulaire
                result['toexec'] = tools.make_js_link(self.server_nb,
                        self.name, confirm=True,
                        balise='user_create_div_container',
                        datas='form', _type=self._type)
            except (MissingKey, MissingValue, Exception), mess:
                log.err("Erreur dans user.py 1: %s"%mess)
                log.err()
                result['message'] = mess.message.rstrip()
            self.form_result = {}
            return self.frag(result)

        typedico = {'pupil':'élève', 'teacher':'professeur',
                    'responsable':'responsable',
                    'administratif':'administratif', 'other':'invité'
                   }
        result['sstitre'] = "Créer un %s" % typedico[self._type]
        result['_type'] = {'name':'_type', 'default_value':self._type}
        result.update(_get_menu(self.server_nb, self.name, self._type))
        result.update(self._get_form())
        result.update(self._get_valid_btn())
        return self.send_all(result, template='scribe_usercreate',
                             templates=used_templates)

    def frag(self, result):
        """ renvoie la description pour un fragment de page """
        return self.send_frag(result, template='scribe_usercreate',
                              templates=used_templates)

    def _get_form(self):
        """ renvoie la description des formulaires de création d'utilisateurs"""
        if self._type == 'pupil':
            return getform._get_pupil_form()
        elif self._type == 'teacher':
            return getform._get_teacher_form()
        elif self._type == 'responsable':
            return getform._get_responsable_form()
        elif self._type == 'administratif':
            return getform._get_administratif_form()
        elif self._type == 'other':
            return getform._get_other_form()

    def _get_valid_btn(self):
        """ bouton valider pour la creation d'user
        passe en meme temps le type en cours de creation eleve/prof"""
        href = tools.make_form_link(self.server_nb, self.name, True,
                ['current_type', 'add_user'], 'user_create_div_msg')
        return dict(validate=M.Submit(href=href, title="Créer cet utilisateur"))

    def _valid_form(self):
        """ valider les formulaires """
        if self._type == 'pupil':
            return usercreate.create_pupil(self.form_result)
        elif self._type == 'teacher':
            return usercreate.create_teacher(self.form_result)
        elif self._type == 'responsable':
            return usercreate.create_responsable(self.form_result)
        elif self._type == 'administratif':
            return usercreate.create_administratif(self.form_result)
        elif self._type == 'other':
            return usercreate.create_other(self.form_result)

