# -*- coding: utf-8 -*-
"""
    onglet de l'ead
"""
from twisted.python import log

from nevow import loaders, rend, tags as T, inevow

from ead2.frontend.web.config import debug
from ead2.frontend.web.lib.urls import EadUrl
from ead2.frontend.web.lib.servers import servers, is_server_alive

class Tabs(rend.Fragment):
    """ liste des serveurs à administrer """
    docFactory = loaders.xmlstr('''\
                               <div xmlns:nevow="http://nevow.com/ns/nevow/0.1">
                                     <span nevow:render="servers"/>
                                </div>
                                ''')
    def render_servers(self, ctx, data):
        """ :ctx: contexte de la page d'origine """
        session = inevow.ISession(ctx)
        self._url = EadUrl.fromContext(ctx).clear().parentdir().child('')
        if debug:
            log.msg("------------->")
            log.msg("L'url : %s " % self._url)
        self.current_server = session.current_server
        if session.current_server is not None:
            message = "Vous êtes connecté au serveur %s" % self.current_server
        else:
            message = 'Connectez-vous à un serveur'
        message = message.upper()
        return [self._servers()]

    def _servers(self):
        """
            Renvoie les onglets pour les backends enregistrés
        """
        ul_tag = []
        data = servers().get_server()
        keys = data.keys()
        keys.sort()
        for key in keys:
            url, port, comment, cle = data[key]
            backend_ip = EadUrl.fromString(url).netloc
            server_alive = is_server_alive(backend_ip, port)

            li_tag = T.li()
            if server_alive:
                _url = self._url.sibling('connect').child('')
                _url = _url.add('server', key)
                link = str(_url)
                if self.current_server == key:
                    style_a = 'server_active'
                    li_tag.attributes['id'] = 'current'
                else:
                    style_a = 'server_alive'
            else:
                link = str(self._url)
                style_a = 'server_dead'
            li_tag.attributes['class'] = style_a + '_li'

            title = 'Serveur: %s ,  Port = %s' % (comment, port)
            ul_tag.append(li_tag[T.a(_class=style_a,
                                         href=link,
                                         title=title)[comment]
                                    ])
        return T.ul[ul_tag]
