# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action générique
#
#
###########################################################################
from twisted.python import log
from functools import cmp_to_key
from ead2.config.config import SQUID_AUTH, SQUID2_ACTIVATE
from ead2.backend.lib.action import * # import des actions  et types
from ead2.backend.actions import tools
from ead2.backend.actions.amon import amon_tools
from ead2.backend.config.config import TEMP_DIR
from ead2.backend.config.filenames import squidexceptions
from ead2.backend.actions.lib.widgets import form as F, main as M, ajax
from ead2.backend.actions.lib import main
from pyeole.service import manage_services

used_templates = ['main', 'form', 'accordion', 'formselect']

from os.path import join, isfile

def reload_squid_and_e2guardian():
    """
    reload le service squid
    return list of services not properly reloaded
    """
    services = ['squid']
    return_codes = {}
    if SQUID_AUTH and SQUID2_ACTIVATE:
        services.append('squid3-2')
    services.append('eole-guardian')
    return_code = manage_services('reload', services)
    if return_code:
        return False
    return True

def reload_squid():
    """
    reload squid instances
    """
    code = service_code('squid', 'reload', container='proxy')
    if SQUID_AUTH and not code and SQUID2_ACTIVATE:
        code = service_code('squid3-2', 'reload', container='proxy')
    if code :
        return False
    return True

def add_entry(entry, _type="nocache"):
    """
        ajoute une entrée dans le fichier de type _type
    """
    if entry not in get_entrys(_type):
        with open(squidexceptions[_type], 'a') as entries_fd:
            entries_fd.write('%s\n' % entry)
        if _type == 'noauth':
            with open(squidexceptions['{}_squid'.format(_type)], 'a') as entries_fd_squid:
                entries_fd_squid.write('{}\n'.format(entry))
            with open(squidexceptions['{}_e2guardian'.format(_type)], 'a') as entries_fd_e2guardian:
                entries_fd_e2guardian.write('{}\n'.format(entry.lstrip('.')))
        return True
    return False

def del_entry(entry, _type="nocache"):
    """
        supprime la ligne entry dans le fichier de type _type
    """
    all_entrys = get_entrys(_type)
    if entry in all_entrys:
        all_entrys.remove(entry)
        with open(squidexceptions[_type], 'w') as entries_fd:
            entries_fd.write("\n".join(all_entrys))
            entries_fd.write("\n")
        if _type == 'noauth':
            with open(squidexceptions['{}_squid'.format(_type)], 'w') as entries_fd_squid:
                entries_fd_squid.write('\n'.join(all_entrys))
                if all_entrys:
                    entries_fd_squid.write('\n')
            with open(squidexceptions['{}_e2guardian'.format(_type)], 'w') as entries_fd_e2guardian:
                entries_fd_e2guardian.write('\n'.join([e.lstrip('.') for e in all_entrys]))
                if all_entrys:
                    entries_fd_e2guardian.write('\n')
        return True
    return False

def get_entrys(_type="nocache"):
    """
        renvoie la liste des entrées du fichier des types _type
    """
    if isfile(squidexceptions[_type]):
        return [site for site in open(squidexceptions[_type]).read().splitlines() if site]
    return []

def del_site(site, _type="nocache"):
    """ supprime une référence à un site dans le fichier
    """
    if del_entry('.%s' % site, _type):
        return True
    else:
        raise Exception("Erreur: le site n'est pas référencé.")

def del_src(src, _type="srcnocache"):
    """
        supprime une source dans le fichier de type _type
    """
    if del_entry(src, _type):
        return True
    else:
        raise Exception("Erreur: la source n'est pas référencée.")

def add_site(site, _type="nocache"):
    """
        ajoute un site dans le fichier de type _type
    """
    site = amon_tools.format_url(site)
    if not site:
        raise Exception("Erreur: veuillez rentrer une valeur")
    site = ".%s" % site
    if add_entry(site,_type):
        return True
    else:
        raise Exception("Erreur: le site est déjà référencé.")

def add_src(src, _type="srcnocache"):
    """
        ajoute une source dans le fichier de type _type
    """
    if not src:
        raise Exception("Erreur: veuillez rentrer une valeur")
    if add_entry(src, _type):
        return True
    else:
        raise Exception("Erreur: le site est déjà référencé.")

def get_site_form(server_nb, name):
    """
        renvoie la description du formulaire d'entrée des sites
        à ne pas cacher/authentifier
    """
    sitename = F.Input(name='site', libelle='Adresse IP ou domaine (sans le http) à ajouter',
                        required=True)
    cache = F.Checkbox(name='nocache', libelle='Ne pas utiliser le cache du proxy',
                        inline=True, value='ok')
    auth = F.Checkbox(name='noauth', libelle='Ne pas authentifier les accès',
                        inline='ok', value='ok')
    validate = M.Submit(href=ajax.valid(server_nb,
                                        name,
                                        ['addsite'],
                                        container="squid_msg"),
                        title="Ajouter ce site à cette liste")
    return dict(sitename=sitename,
                cache=cache,
                auth=auth,
                validate=validate)

def get_src_form(server_nb, name):
    """
        renvoie la description du formulaire d'entrée des sources à ne pas cacher/authentifier
    """
    srcname =  F.Input(name='src',
                        libelle='Machine ou réseau source à ajouter',
                        required=True)
    cache = F.Checkbox(name='srcnocache',
                        libelle='Ne pas utiliser le cache du proxy',
                        inline=True,
                        value='ok')
    auth = F.Checkbox(name='srcnoauth',
                      libelle='Ne pas authentifier les accès',
                      inline='ok',
                      value='ok')
    validate = M.Submit(href=ajax.valid(server_nb,
                                        name,
                                        ['addsrc'],
                                        container="squid_msg"),
                        title="Ajouter cette source à la liste")
    return dict(srcname=srcname,
                cache=cache,
                auth=auth,
                validate=validate)


class SquidList(main.Main):
    """
        classe générique de gestion de liste
    """
    category = "Configuration générale/Cache et Authentification/"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                        keys=['server', 'action', 'todel', '_type'])#server et action sont les clés systématiques
    form_name = "addentry"
    form_result = Dict(default={}, doc='retour de formulaire', keys=["addentry"])
    template = "amon_squid_list"

    def execute(self):
        self.parse_request()
        if 'todel' in self.params and '_type' in self.params: # le nom du site à supprimer et le type : nocache ou noauth
            try:
                datas = self.valid_del(self.params['todel'][0].strip(),
                                       self.params['_type'][0].strip())
                datas['toexec'] = ajax.call(self.server_nb,
                                            self.name,
                                            only=False)
            except Exception as message:
                log.err()
                datas = dict(message=str(message))
            self.params = {}
            return self.send_frag(datas,
                                  template=self.template,
                                  templates=used_templates)
        # Dans le cas d'un formulaire:
        if self.form_name in self.form_result:
            try:
                # formatage de données pour traitement
                resultat = tools.format_form_result(
                                    self.form_result[self.form_name])
                # datas: dico utilisé pour la templatisation
                datas = self.valid_form(resultat)
                datas['toexec'] = ajax.call(self.server_nb,
                                            self.name,
                                            only=False)
            except Exception as message:
                log.err()
                #si il y a une erreur soulevée par nos soins, on renvoie le message
                datas = dict(message=str(message))
            # Important: on vide le formulaire
            self.form_result = {}
            return self.send_frag(datas,
                                  template=self.template,
                                  templates=used_templates)

        result = dict(titre=self.description) # variable renvoyée utilisée dans le template associé
        result.update(self.get_entrys())
        result.update(self.get_form())
        return self.send_all(result,
                             template=self.template,
                             templates=used_templates)

    def get_entrys(self):
        return {}

    def get_form(self):
        return {}

    def valid_form(self, result):
        return {}

    def valid_del(self, todel, _type):
        return {}

    def sort_entrys(self, a, b):
        """ permet de trier les entrées en fonction du nom ( de domaine ou de la machine source )"""
        if a[0] > b[0]:
            return 1
        elif a[0] == b[0]:
            return 0
        else:
            return -1


class SquidSite(SquidList):
    """
        Gestion d'une liste de sites à ne pas cacher/authentifier
    """
    name = "squid_sitelist" #celui de perm_nomdumodule.ini
    libelle = "Destinations"
    description = "Éditer la liste de destinations à ne pas authentifier"
    form_name = "addsite"
    form_result = Dict(default={}, doc='retour de formulaire', keys=["addsite"])

    def get_entrys(self):
        """
            renvoie la liste des sites avec les données pour la mise
            en forme des boutons supprimer
        """
        sites = []
        cached = [site[1:]for site in get_entrys('nocache')]
        authed = [site[1:]for site in get_entrys('noauth')]

        for site in set(cached).union(set(authed)):

            if site in set(cached):
                href1 = tools.make_js_link(self.server_nb, self.name,
                                                balise="squid_msg",
                                                todel=site,
                                                _type='nocache')
            else:
                href1 = None

            if site in set(authed):
                href2 = tools.make_js_link(self.server_nb, self.name,
                                                balise="squid_msg",
                                                todel=site,
                                                _type='noauth')
            else:
                href2 = None

            icone = "/image/supprimer.gif"
            title = ""
            libelle =""
            _class = "btn"
            if href1:
                btn1 = dict(href=href1, icone=icone, title=title,
                            libelle=libelle, _class=_class)
            else:
                btn1 = ''
            if href2:
                btn2 = dict(href=href2,icone=icone, title=title,
                            libelle=libelle, _class=_class)
            else:
                btn2 = ''
            sites.append((site, btn1, btn2))
        sorted(sites, key=cmp_to_key(self.sort_entrys))
        return dict(sites=sites)

    def get_form(self):
        return get_site_form(self.server_nb, self.name)

    def valid_form(self, result):
        """
            valide l'ajout de site à la liste des sites à ne pas
            authentifier et/ou cacher
        """
        sitename = result['site']
        sitename = amon_tools.format_url(sitename)
        result.pop('site')
        if list(result.keys()):
            for key in list(result.keys()):
                add_site(sitename, key)
            if not reload_squid_and_e2guardian():
                raise Exception("Les modifications ont été appliquées au " \
                "fichier de configuration mais les services n'ont pas pu recharger la configuration")
        else:
            raise Exception("Pensez à cocher une case")

        return dict()

    def valid_del(self, sitename, _type):
        """
            valide la suppression de site de la liste des sites à ne pas autoriser
        """
        del_site(sitename, _type)
        if not reload_squid_and_e2guardian():
            raise Exception("Les modifications ont été appliquées au " \
            "fichier de configuration mais les services n'ont pas pu recharger la configuration")
        return dict()

class SquidSrc(SquidList):
    """
        Gestion d'une liste de sources à ne pas cacher/authentifier
    """
    name = "squid_srclist" #celui de perm_nomdumodule.ini
    libelle = "Sources"
    description = "Éditer la liste de sources à ne pas authentifier"
    form_name = "addsrc"
    form_result = Dict(default={}, doc='retour de formulaire', keys=["addsrc"])

    def get_entrys(self):
        """
            renvoie la liste des sources avec les données pour la mise en
            forme des boutons supprimer
        """
        srcs = []
        cached = get_entrys('srcnocache')
        authed = get_entrys('srcnoauth')

        for src in set(cached).union(set(authed)):

            if src in set(cached):
                href1 = ajax.call(self.server_nb,
                                  self.name,
                                  container="squid_msg",
                                  todel=src,
                                  _type='srcnocache')
            else:
                href1 = None

            if src in set(authed):
                href2 = ajax.call(self.server_nb,
                                  self.name,
                                  container="squid_msg",
                                  todel=src,
                                  _type='srcnoauth')
            else:
                href2 = None

            if href1:
                btn1 = M.SupprBtn(href=href1, libelle="",  _class="btn")
            else:
                btn1 = ''
            if href2:
                btn2 = M.SupprBtn(href=href2, libelle="",  _class="btn")
            else:
                btn2 = ''
            srcs.append((src, btn1, btn2))
        sorted(srcs, key=cmp_to_key(self.sort_entrys))
        return dict(srcs=srcs)

    def get_form(self):
        return get_src_form(self.server_nb, self.name)

    def valid_form(self, result):
        """
            valide l'ajout de source à la liste des sources à ne pas
            authentifier et/ou cacher
        """
        src = result['src']
        result.pop('src')
        if list(result.keys()):
            for key in list(result.keys()):
                add_src(src, key)
            if not reload_squid():
                raise Exception("Les modifications ont été appliquées au " \
             "fichier de configuration mais le service n'a pas pu redémarrer")
        else:
            raise Exception("Pensez à cocher une case")
        return dict()

    def valid_del(self, src, _type):
        """
            valide la suppression de la source des sources à ne pas
            authentifier et/ou cacher
        """
        del_src(src, _type)
        if not reload_squid():
            raise Exception("Les modifications ont été appliquées au fichier " \
                    "de configuration mais le service n'a pas pu redémarrer")
        return dict()

