#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Librarie de fonctions javascripts
#
#
###########################################################################
"""
Librairie de fonctions javascripts pour l'Ead2
"""

def popup(url, name, width=600, height=500, only=True):
    """
        renvoie une fonction javascript d'ouverture de fenêtre
        url: url de la page à ouvrir
        name: titre de la page
        width: largeur de la popup
        height: hauteur de la popup
        only: cette fonction sera la seule du lien True: pas de javascript:
    """
    if only:
        return "javascript:OuvreFenetre('%s', '%s', %s, %s);" % (url, name, width, height)
    else:
        return "OuvreFenetre('%s', '%s', %s, %s);" % (url, name, width, height)

def top(only=False):
    """
        renvoie la fonction javascript renvoyant vers le haut de page
    """
    return "window.scrollTo(0,0);"

def call(server_nb, action_name, container=None, only=True, js_args=False, **args):
    """
        renvoie un appel javascript à une action
        :server_nb: numéro de serveur à appeler
        :action_name: Nom de l'action à appeler
        :container: balise html de réception de l'appel (content par défaut)
        :only: Avec le javascript devant ?
        :js_args: La valeur des arguments est sous forme de javascript ?
    """
    link = ''
    if only:
        link += "javascript:"
    if args == {}:
        if container:
            link += "call_action('%s', '%s', '%s');" % (server_nb, action_name, container)
        else:
            link += "call_action('%s', '%s');" % (server_nb, action_name)
    else:
        link += "call_plugin('%s', '%s', " % (server_nb, action_name)
        options = "["
        virgule = False
        keys = list(args.keys())
        keys.sort()
        for key in keys:
            value = args[key]
            if virgule:
                options += ','
            if js_args:
                options += "['%s', %s]" % (key, value)
            else:
                options += "['%s', '%s']" % (key, value)
            virgule = True
        options += "]"
        if container:
            link += "%s, '%s');" % (options, container)
        else:
            link += "%s);" % options
    return link

def valid(server_nb, action_name, formnames=[], container=None, only=True, **params):
    """
        renvoie un lien javascript de validation de formulaire
        :server_nb: numéro de serveur à appeler
        :action_name: Nom de l'action à appeler
        :only: Avec le javascript devant ?
        :container: balise html de réception de l'appel (content par défaut)
    """
    link = "formValidForm('%s', '%s', ['%s']"%(server_nb, action_name, "', '".join(formnames))
    if container:
        link += ", '%s'" % container
    if params:
        link += ", ["
        virgule = False
        keys = list(params.keys())
        keys.sort()
        for key in keys:
            value = params[key]
            if virgule:
                link += ","
            link += "['%s', '%s']" % (key, value)
            virgule = True
        link += "]"
    link += ");"
    if only:
        link = "javascript:%s" % link
    return link

def keyvalid(server_nb, action_name, formnames=[], container=None, only=False, **params):
    return valid(server_nb, action_name, formnames=[], container=None, only=False, **params)

def transfer(formname, tablename):
    """
        renvoie la fonction javascript pour le transfert
        d'un formulaire à un tableau
    """
    return "javascript:formTransferListElement('%s', '%s');" % (formname, tablename)

def confirm(message, js_code):
    """
        renvoie un lien javascript de confirmation d'éxécution
        :message: message pour demander la confirmation
        :js_code: code javascript à éxécuter
    """
    js_code = js_code.replace("'", "\\'")
    message = message.replace("'", "\\'")
    return "javascript:formConfirmExecute('%s', '%s')" % (message, js_code)

def toggle(html_container, link_id=None, js=True):
    if js:
        my_js_string = "javascript:"
    else:
        my_js_string = ""
    if link_id:
        return "%sIncreaseOnly('%s', '%s');" % (my_js_string, html_container, link_id)
    else:
        return "%sIncreaseOnly('%s');" % (my_js_string,html_container,)

def reduce(html_container, js=True):
    """
        renvoie un lien de réduction pour la balise html_container
        js: avec le javascript devant
    """
    if js:
        my_js_string = "javascript:"
    else:
        my_js_string = ""
    return "%sReduce('%s');" % (my_js_string, html_container,)

