# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007-2013
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Outil de listing des fichiers de logs de e2guardian
#
#
###########################################################################

""" Liste les fichiers de log de e2guardian et les classe par jour """
from os.path import join, isdir
from os import listdir
from datetime import date, timedelta
import locale
import re
from functools import cmp_to_key

from ead2.backend.actions.lib.logparser.config import LOG_DIR, log_root_name

locale.setlocale(locale.LC_ALL, '') #utile pour la méthode strftime


def get_day_label(day):
    """
    Renvoie le nom du jour ou "aujourd'hui".
    :param day: jour
    :type day: datetime.date
    """
    if day == date.today():
        label = "aujourd'hui"
    else:
        label = day.strftime('%A')
    return label


def get_day_file(day, logs):
    """
    Renvoie le nom du fichier susceptible de contenir les données
    du jour demandé.
    :param day: jour de l'année (datetime.date).
    :type day: int
    :param logs: liste des noms de fichiers.
    :type logs: list
    """
    yyyymmdd = day.strftime('%Y%m%d')
    days = {_get_nb_in_name(name): name for name in logs}
    filename = days.get(yyyymmdd, None)
    while filename == None:
        day = day + timedelta(days=1)
        yyyymmdd = day.strftime('%Y%m%d')
        filename = days.get(yyyymmdd, None)
        if day > date.today():
            filename = days[-1]
    return filename


def get_days(logs):
    """
    Renvoie un dico {numéro de semaine: liste des jours au format datetime.date ordonnée en sens inverse}
    :param logs: list des logs présents sur la machine.
    :type logs: int
    """
    today = date.today()
    days = {}
    for index in range(len(logs)):
        day = today - timedelta(days=index)
        days[day.isocalendar()[1]] = days.get(day.isocalendar()[1], []) + [(day, get_day_file(day, logs))]
    return days


def get_logs(zone=0):
    """
    Renvoie la liste des noms de fichier de log concernant une instance
    particulière de e2guardian.
    :param zone: numéro de la zone et de l'instance.
    :type zone: int
    """
    log_name = log_root_name.format(zone)
    name_re = re.compile(r'{0}(-[0-9]{{8}})?(.lzma|.gz)?$'.format(log_name))
    loglist = [_file for _file in listdir(LOG_DIR) if name_re.match(_file)]
    sorted(loglist, key=cmp_to_key(compare_func))
    return loglist


def get_logs_for_form(zone):
    """
    Renvoie le contenu du menu pour le formulaire de l'ead
    :param zone: numéro de la zone et de l'instance.
    :type zone: int
    """
    loglist = get_logs(zone)
    days = get_days(loglist)
    weeks = list(days.keys())
    sorted(weeks, reverse=True)
    menu = [{'name':'', 'options':[{'name':'vide', 'libelle':'-----'}]}]
    for week in weeks:
        menu.append({'name': 'Semaine {0}'.format(week),
            'options': [{'libelle': get_day_label(day[0]), 'name': day[1]} for day in days[week]]})
    return menu


def get_filenames_from_days(day):
    """ renvoie le nom des fichiers de logs du jour day """
    week = int(day[-1:])
    indice = get_today_index() + 7*week
    day_index = day_dict.index(day[:-1])

    print("today %s"%get_today_index())
    print("Day_index %s"%day_index)
    print("week : %s"%week)
    print("indice : %s"%indice)


## utilitaires de comparaison
def compare_func(a, b):
    """ fonction de comparaison """
    un = _get_nb_in_name(a)
    deux = _get_nb_in_name(b)
    print(un, type(un))
    print(deux, type(deux))
    return ( un > deux ) - ( un < deux )

def _get_nb_in_name(name):
    """
    Renvoit la date présente dans un nom de fichier ou -1 si aucune date.
    :param name: nom du fichier
    :type name: str
    """
    result = -1
    regexp = r"log-(?P<date>[0-9]{8})\."
    re_result = re.search(regexp, name)
    if re_result:
        result = int(re_result.group('date'))
    return result
