# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Actions permettant de gérer les groupes """
from twisted.python import log
from scribe.eoleshare import Share
from scribe.eolegroup import Group
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.actions.scribe.tool.group import (used_templates,
     _get_close_btn, posh, LISTE_TYPES)
from ead2.backend.actions.lib.widgets import main as M, form as F


if posh():
    try:
        from posh.backend import db_mapper
    except:
        log.err()

class GroupModify(Action):
    """ Renvoie le formulaire de modification d'un groupe et gère le retour """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_group_modify'
    libelle = "Modifier un groupe"
    category = None
    description = 'Modifier un groupe'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'group_name',
        'add_share', 'add_maillist', 'add_posh'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['list_group', 'add_maillist', 'posh_groups'])

    def execute(self):
        """ renvoit les données pour l'affichage
            1 - ajout d'une mailing liste
                a - renvoie du formulaire
                b - validation de la création de la liste de diffusion
            2 - ajout d'un partage
            3 - envoie du groupe vers posh
        """
        params, self.server_nb = tools.get_request(self.request)
        ## 3 -
        if 'add_posh' in params:
            try:
                result = self.add_groups_to_posh()
            except Exception as error:
                log.err()
                result = dict(message=str(error))
            return self.frag(result)
        ## 2 -
        if 'add_share' in params:
            if 'group_name' in params:
                sharename = params['group_name'][0]
                # FIXME: on ne peut pas choisir le type de partage
                Share().add(sharename, sharename, _type='rw', sync=True)
                message = "Le partage %s a bien été créé" % sharename
            params.pop('add_share')
            return self.frag({'message':message})
        ## 1 - a
        if 'add_maillist' in params:
            if 'group_name' in params:
                name = params['group_name'][0]
            params.pop('add_maillist')
            return self.frag(self._get_add_maillist_form(name))
        ## 1 - b
        if self.form_result != {}:
            if 'add_maillist' in self.form_result:
                try:
                    message = {'message':self.add_maillist()}
                except (MissingValue, MissingKey, Exception) as mess:
                    log.err("Erreur dans group.py : %s" % mess)
                    log.err()
                    message = {'message':str(mess)}
                self.form_result = {}
                return self.frag(message)
        result = {}
        return self.send_all(result, template='scribe_group',
                             templates=used_templates)

    def frag(self, datas):
        """ renvoie un fragment """
        result = datas
        result['toexec'] = tools.make_form_link(self.server_nb,
                                   'scribe_group_list', False,
                                   ['list_group'], "group_list_div_container")
        return self.send_frag(result, template='scribe_group',
                              templates=used_templates)

    def add_maillist(self):
        """ ajoute une liste de diffusion pour un groupe """
        if 'add_maillist' not in self.form_result:
            raise MissingValue("Erreur : il manque une clé à la validation du formulaire")
        resultat = tools.format_form_result(self.form_result['add_maillist'])
        if 'add_mail_group' not in resultat or \
            'domain' not in resultat:
            raise MissingValue("Erreur : il manque une clé à la validation du formulaire")
        group = resultat['add_mail_group']
        domain = resultat['domain']
        grouptype = Group().get_group_type(group)
        Group().add_maillist(grouptype, group, domain)
        return "La liste de diffusion %s a été créée dans le domaine %s." % (group, domain)

    def _get_add_maillist_form(self, name):
        """
        renvoie la description du formulaire d'ajout de liste de diffusion
        au groupe de nom :name:
        """
        add_mail_group = F.Input(name='add_mail_group',
                            libelle="Nom du groupe", inline=True,
                            disabled=True, default=name)
        domain = F.Select(name='domain',
                          libelle="Domaine de la liste",
                          inline=True)
        for code, libelle in LISTE_TYPES:
            domain.add_option(code, libelle=libelle)
        return dict(add_mail_group=add_mail_group, domain=domain,
                    validate=self._get_maillist_valid_btn(),
                    close_btn=_get_close_btn('mod_group_div_container'))

    def _get_maillist_valid_btn(self):
        """ renvoie la description du bouton valider pour une maillist """
        href = tools.make_form_link(self.server_nb, self.name, True,
                         ['add_maillist'], "mod_group_div_container")
        title = "Créer les liste de diffusion pour ce groupe"
        return M.Bouton(href=href, libelle="Créer", title=title)

    def add_groups_to_posh(self):
        """ ajoute des groupes dans le gestionnaire de profil posh """
        if 'posh_groups' not in self.form_result:
            raise Exception("Erreur: il manque des données pour l'export de \
données vers le gestionnaire de profil du portail.")
        groups = list(tools.format_form_result(self.form_result['posh_groups'],
                                          check=False).keys())
        if not groups:
            raise Exception("Erreur: sélectionnez des groupes à exporter.")
        message = "Export de groupe vers le gestionnaire de profil:\\n"
        for group in groups:
            try:
                userattr_dict = {'attrname':'user_groups', 'attrvalue':group}
                profile_dict = {'name':'gr_%s' % group,
                                'description':'Groupe %s' % group}
                #Ajout de l'attribut et du profil associé dans la base
                db_mapper.add_userattr(userattr_dict)
                db_mapper.add_profile(profile_dict)
                # Recupération des ids pour la jointure
                userattrid = db_mapper.get_userattr(**userattr_dict)[0]['userattrid']
                profileid = db_mapper.get_profile(**profile_dict)[0]['profileid']
                db_mapper.add_link('userattrprofile', userattrid, profileid)
                message += "Le groupe %s a bien été exporté.\\n" % group
            except:
                log.err()
                message += "Échec de l'ajout de %s ( y est-il déjà ?)\\n" % group
        return dict(message=message)
