# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# liste des fichiers utilises par les actions du serveur de commande
#
###########################################################################

from os.path import join
from ead2.backend.config.config import CONFIG_DIR, TEMP_DIR, BAREOS_TEMP_DIR, \
EOLE_REPORTS_DIR, EOLE_CONFIG_DIR, SCRIPT_DIR
from ead2.config.config import CONTAINER_PATH_PROXY, EOLE_MODULE

# fichier de configuration pour la page de service simplifiee
simple_services = join(CONFIG_DIR, 'simple_services.ini')

# fichier de configuration pour la gestion de profils
role_filename = "/usr/share/ead2/backend/config/roles_local.ini"
perm_filename = "/usr/share/ead2/backend/config/perm_local.ini"
ldapkeys_filename = "/usr/share/ead2/backend/config/ldapkeys.txt"

ajout_filtres = '/usr/share/eole/ajout_filtres.sh'

index = {'blacklist':join(EOLE_REPORTS_DIR, 'maj-blacklist.txt')}

navigation_filters = { 'filtres_opt':join(CONFIG_DIR, 'filtres-opt'),
                       'list_mime':join(CONFIG_DIR, 'mime_liste.txt'),
                       'signalement_msg':join(CONFIG_DIR, 'signalement_msg.txt')
                     }

journal_filename = join(TEMP_DIR, 'journal')

maj = {'rapport':join(EOLE_REPORTS_DIR, 'rapport-maj.log')}

reconf = { 'log':join('/usr/share/ead2/backend/tmp', 'reconf.log')}

bareos = {#'distant':join(BAREOS_CONFIG_DIR, 'bareos-distant.txt'),
          #  'usb':join(BAREOS_CONFIG_DIR, 'bareos-usb.txt'),
           'rapport':join(BAREOS_TEMP_DIR, 'rapport-bareos.txt'),
           'rapport_simple':join(BAREOS_TEMP_DIR, 'resultat-bareos'),
        }

# fichier de config pour les reglages de securite
securite = {'p2p':join(EOLE_CONFIG_DIR, 'killp2p.conf'),
            'horaire':join(EOLE_CONFIG_DIR, 'horaires.txt')
            }

# fichier de config du serveur de test de bande passante
bande_passante = {'server':join(EOLE_CONFIG_DIR, 'bp_server.conf'),
                  'record':join(EOLE_REPORTS_DIR, 'bp_record.txt')}

# outil de recuperation des clients connectes au domaine samba
get_client_scribe_script = "/usr/share/eole/controlevnc/manage_stations.py"

## script pour la gestion des imprimantes
printers_conf = {'script':join(SCRIPT_DIR, 'printers.sh')}
# modification groupée de mot de passe
pwd_dir = {'rapport' : join(TEMP_DIR, 'passwords')}

squidexceptions = {'noauth': join('/', CONTAINER_PATH_PROXY, "var/lib/eole/domaines_noauth_user"),
                 'noauth_squid': join('/', CONTAINER_PATH_PROXY, "etc/squid/domaines_noauth_user"),
                 'noauth_e2guardian': join('/', CONTAINER_PATH_PROXY, "etc/guardian/common/domaines_noauth_user"),
                 'nocache': join('/', CONTAINER_PATH_PROXY, "etc/squid/domaines_nocache_user"),
                 'srcnoauth': join('/', CONTAINER_PATH_PROXY, "var/lib/eole/src_noauth_user"),
                 'srcnocache': join('/', CONTAINER_PATH_PROXY, "etc/squid/src_nocache_user"),
                 }
# chemin des répertoires utilisateurs
if EOLE_MODULE == 'esbl':
    acl_root_dir = "/data/bureautique"
else:
    acl_root_dir = "/home/workgroups/"
