#-*-coding:utf-8-*-
"""
    Test de la librairie ajax
"""
from . import autopath
from widgets import ajax

def test_popup():
    assert ajax.popup('http://www.google.fr', 'Google') == "javascript:OuvreFenetre('http://www.google.fr', 'Google', 600, 500);"

def test_call():
    call = ajax.call(1, 'action_test', container='div_container', cle1="valeur1", cle2="valeur2")
    assert call == "javascript:call_plugin('1', 'action_test', [['cle1', 'valeur1'],['cle2', 'valeur2']], 'div_container');"

def test_valid():
    valid = ajax.valid(1, 'action_test', ['form1', 'form2'], container='div_container', cle1="valeur1", cle2="valeur2")
    assert valid == "javascript:formValidForm('1', 'action_test', ['form1', 'form2'], 'div_container', [['cle1', 'valeur1'],['cle2', 'valeur2']]);"
