# -*- coding: utf-8 -*-
from ldap import modlist
from pyeole.process import system_code
from scribe.eoleldap import Ldap
from scribe.ldapconf import SUFFIX, acad, AD_PUBLIC_ADDRESS, AD_USERS_ETAB


def add_etab(uai):
    conn = Ldap()
    conn.connect()
    suffix = "ou=%s,ou=%s,ou=education,%s" % (uai, acad, SUFFIX)
    #les groupes
    suffix_group = "ou=groupes,%s" % suffix
    suffix_group_local = 'ou=local,%s' % suffix_group
    #les partages
    suffix_share = "ou=partages,%s" % suffix
    suffix_share_local = "ou=local,%s" % suffix_share
    #les utilisateurs
    suffix_user = "ou=utilisateurs,%s" % suffix
    suffix_user_perso = "ou=personnels,%s" % suffix_user
    suffix_user_perso_local = "ou=local,%s" % suffix_user_perso
    suffix_user_eleve = "ou=eleves,%s" % suffix_user
    suffix_user_eleve_local = "ou=local,%s" % suffix_user_eleve
    suffix_user_autre = "ou=autres,%s" % suffix_user
    suffix_user_autre_local = "ou=local,%s" % suffix_user_autre
    suffix_user_responsable = "ou=responsables,%s" % suffix_user
    suffix_user_responsable_local = "ou=local,%s" % suffix_user_responsable

    etab = {}
    etab['objectclass'] = ['organizationalUnit']
    ldif = modlist.addModlist(etab)
    conn._add(suffix, ldif)
    conn._add(suffix_group, ldif)
    conn._add(suffix_group_local, ldif)
    conn._add(suffix_share, ldif)
    conn._add(suffix_share_local, ldif)
    conn._add(suffix_user, ldif)
    conn._add(suffix_user_perso, ldif)
    conn._add(suffix_user_eleve, ldif)
    conn._add(suffix_user_autre, ldif)
    conn._add(suffix_user_responsable, ldif)
    conn._add(suffix_user_perso_local, ldif)
    conn._add(suffix_user_eleve_local, ldif)
    conn._add(suffix_user_autre_local, ldif)
    conn._add(suffix_user_responsable_local, ldif)
    conn.close()

    # conteneur addc local
    if AD_PUBLIC_ADDRESS != '':
        ret = 0
        cmd = ['lxc-attach', '-n', 'addc']
        ret += system_code(cmd, stdin="samba-tool ou create 'OU={}'".format(uai))
        ret += system_code(cmd, stdin="samba-tool ou create '{},OU={}'".format(AD_USERS_ETAB, uai))
        ret += system_code(cmd, stdin="samba-tool ou create 'OU=Ordinateurs,OU={}'".format(uai))
        if ret != 0:
            raise Exception("Erreur : la création des unités organisationnelles dans AD a échoué")
