#!/usr/bin/python
#-*-coding:utf-8-*-
"""
    Script d'activation d'action ead
    (crée un lien symbolique de l'action vers le répertoire cible)
"""
import getopt, sys
from os import system, listdir
from os.path import join, isfile, isdir

sys.path.append('/usr/share')

from ead2.backend.config.config import (ENABLED_ACTION_DIR,
                                        AVAILABLE_ACTION_DIR)
DOC = """
Usage : enable_action.py [ACTIONNAME]
Active l'importation d'un fichier d'action par l'ead.
Crée un lien entre pointant vers /etc/ead/sites-available/actionname depuis /etc/ead/sites-enabled/.
Ce fichier sera alors chargé automatiquement au redémarrage du service ead-server.

Ex :
1) enable_action.py monaction.py
Crée un lien symbolique de /etc/ead/sites-enabled/monaction.py vers /etc/ead/sites-available/monaction.py

NB:
    Le fichier action doit être enregistré avant d'être activé
"""

def usage():
    """
        print la doc
    """
    print(DOC)

def mkdir(dirname):
    """
        Crée les repertoires si besoin
    """
    if not isdir(dirname):
        if system("/bin/mkdir -p %s" % (dirname,)) != 0:
            print(("Une erreur est survenue à la création du répertoire \
\"%s\"" % (dirname,)))
            usage()
            exit(2)

def test_target(target):
    """
        Teste la destination
    """
    if not isfile(target):
        print(("-- WRONG ORDER : THE ACTION \"%s\" MUST BE REGISTERED \
(see register_action.py) --" % (target,)))
        usage()
        sys.exit(2)

def test_linkname(linkname):
    """
        Teste si l'action n'est pas encore active
    """
    if isfile(linkname):
        print(("L'action a déjà été activée (\"%s\"), \
renommez votre fichier." % (linkname,)))
        usage()
        sys.exit(2)

def main():
    """
        lance la commande
    """
    try:
        opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
    except getopt.GetoptError as err:
        print(str(err))
        usage()
        sys.exit(2)
    for option, value in opts:
        if option in ('-h', '--help'):
            usage()
            sys.exit(0)


    # on crée les répertoires si ils n'existent pas
    mkdir(ENABLED_ACTION_DIR)
    mkdir(AVAILABLE_ACTION_DIR)

    try:
        actionfilename = args[0]
        if actionfilename.startswith('/'):
            print(("Erreur : l'action \"%s\" n'est pas encore enregistrée." % (
                                                             actionfilename,)))
            usage()
            sys.exit(2)
    except:
        avlble = [aname for aname in listdir(AVAILABLE_ACTION_DIR)
                           if aname.endswith('.py') and \
                              aname not in listdir(ENABLED_ACTION_DIR)]
        if len(avlble) < 1:
            print("-- NO ACTION HAS BEEN REGISTERED : \
(see register_action.py) --")
            usage()
            sys.exit(2)
        print("Fichiers actions disponibles :")
        for indice, actionname in enumerate(avlble):
            print(("[%s] %s" % (indice, actionname,)))
        action_indice = -1
        while action_indice not in list(range(len(avlble))):
            try:
                action_indice = int(input("Numéro du fichier action à activer : "))
            except:
                action_indice = -1
        actionfilename = avlble[action_indice]

    target = join(AVAILABLE_ACTION_DIR, actionfilename)
    linkname = join(ENABLED_ACTION_DIR, actionfilename)

    test_target(target)
    test_linkname(linkname)
    # on crée le lien symbolique
    exit(system("/bin/ln -s '%s' '%s'" % (target, linkname)) )

if __name__ == '__main__':
    main()
