# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Utilitaire pour les actions de gestion de navigation web
#
###########################################################################

""" outil pour l'interface d'observation web """
from os.path import isfile
import subprocess

from twisted.python import log

from ead2.config.config import (DANSGUARDIAN_EAD_FILTRE1,
 DANSGUARDIAN_EAD_FILTRE2, DANSGUARDIAN_EAD_FILTRE3)
from ead2.backend.config.filenames import navigation_filters
from ead2.backend.config.config import debug

# fonction de redemarrage
def service(service_name, cmd='restart'):
    """
        Redémarre un service
    """
    ret_code, ret_value = subprocess.getstatusoutput(
                    'service %s %s > /dev/null' % (service_name, cmd))
    if debug:
        log.msg('%sing %s ||||%s,|||| %s' % (cmd, service_name,
                                        ret_code, ret_value))
    if ret_code == 0:
        return True
    else:
        return False

def bastion_restart():
    """
    Redémarre Bastion
    Force restart via la commande bastion (CreoleService utilise stop/start à la place)
    """
    # relance de bastion dans tous les conteneurs
    ret_code, ret_value = subprocess.getstatusoutput(
                    'CreoleRun "bastion restart" root no yes')
    if debug:
        log.msg('restart bastion in root : %s' % str(ret_value))
    if ret_code != 0:
        return False
    ret_code, ret_value = subprocess.getstatusoutput(
                    'CreoleRun "bastion restart" all no yes')
    if debug:
        log.msg('restart bastion in containers : %s' % str(ret_value))
    if ret_code != 0:
        return False
    return True

# fonction de gestion de fichiers texte #

def get_lines(filename):
    """ renvoit le contenu d'un fichier sous forme de tableau """
    if isfile(filename):
        return open(filename).read().splitlines()
    else:
        return []

def write_file(filename, lines):
    """
        écrit les lignes lines dans filename
    """
    fileobj = open(filename, 'w')
    fileobj.writelines('\n'.join(lines))
    fileobj.write('\n')
    fileobj.close()

def test_line(line):
    """ remplace les caractères ' et " en plaçant des anti-slashs """
    line = line.replace('"', r"'")
    line = line.replace("'", r"'")
    return line

def add_lines(filename, lines):
    """ ajoute une ligne dans un fichier (sans doublon) """
    if type(lines) != list:
        lines = [lines]
    oldies = get_lines(filename)
    for line in lines:
        if line and line not in oldies:
            line = test_line(line)
            oldies.append(line)
    try:
        write_file(filename, oldies)
    except:
        return False
    return True

def del_lines(filename, lines):
    """ supprime des lignes dans un fichier """
    if type(lines) != list:
        lines = [lines]
    oldies = get_lines(filename)
    for line in lines:
        if line in oldies:
            oldies.remove(line)
    try:
        write_file(filename, oldies)
    except:
        return False
    return True

def get_hours(default=''):
    """
        renvoie les heures (et demi-heure) de la journée formatées
        pour la présentation dans une balise select
    """
    # évitons les cagades ipttime ne gère pas bien le from 0:00 to 0:00
    hours = [{'libelle':'0:01', 'name':'0:01'},
             {'libelle':'0:30', 'name':'0:30'}]
    if default == '0:01':
        hours[0]['default'] = 'ok'
    elif default == '0:30':
        hours[1]['default'] = 'ok'

    for i in range(1, 24):
        val1  = '%d:00' % i
        val2 = '%d:30' % i
        hour = {'libelle':val1, 'name':val1}
        halfandhour = {'libelle':val2, 'name':val2}
        if default == val1:
            hour['default'] = 'ok'
        elif default == val2:
            halfandhour['default'] = 'ok'
        hours.append(hour)
        hours.append(halfandhour)
    return hours

def get_days(default=''):
    """
        renvoie les jours de la semaine formatés
        pour la présentation dans une balise select
    """
    days = ['lundi', 'mardi', 'mercredi', 'jeudi',
            'vendredi', 'samedi', 'dimanche']
    ret_days = []
    for day in days:
        if day == default:
            ret_days.append({'name':day, 'libelle':day, 'default':'ok'})
        else:
            ret_days.append({'name':day, 'libelle':day})
    return ret_days

def format_value(value):
    """
        formatte une valeur (gestion des ' et "")
    """
    return test_line(value)

def format_url(url):
    """
        formatte une url
    """
    url = test_line(url)
    if ' ' in url:
        url = url.strip()
        url = url.replace(' ', '')
    if url.startswith('http://'):
        url = url.replace('http://', '', 1)
    elif url.startswith('https://'):
        url = url.replace('https://', '', 1)
    return url

def format_ext(extension):
    """
        formatte une extension
    """
    extension = test_line(extension)
    if not extension.startswith('.'):
        extension = ".%s" % extension
    return extension

def get_filtres_options():
    """
        recupere les filtres optionnels disponibles
        depuis le fichier filtres-opt
    """
    filtres_opt_filename = navigation_filters['filtres_opt']
    options = []
    if not isfile(filtres_opt_filename):
        return options
    opts = open(filtres_opt_filename, 'r').read().splitlines()
    for opt in opts:
        clef = opt.split('#')[0]
        desc = opt.split('#')[1]
        options.append({'name':clef, 'libelle':desc})
    return options

def get_zone_libelle(num_zone):
    """
        Renvoie le libellé des zones pour l'ead
    """
    if num_zone == 1:
        libelle = DANSGUARDIAN_EAD_FILTRE1
    elif num_zone == 2:
        libelle = DANSGUARDIAN_EAD_FILTRE2
    else:
        libelle = DANSGUARDIAN_EAD_FILTRE3
    return(libelle)
