#-*-coding:utf-8-*-
###########################################################################
#
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""
    Importation Texte (version 2)
"""
from ead2.backend.lib.action import Dict

from ead2.backend.actions.lib.importation.fichier import BaseImportationFichier
from scribe.importation.config import (CSV2_FILES,
                                       CSV2_FILEVARNAMES)

class ImportationCsv(BaseImportationFichier):
    """
        Importation de type CSV
        Téléchargement / Parsing / Importation
    """
    data_type = 'csv2'
    name = 'scribe_extraction_csv2'
    description = 'Importation de fichiers CSV'
    libelle = description
    all_file_descriptions = CSV2_FILES
    request_keys = ['server',
                    'action',
                    'category_type',
                    'import_type',
                    'data_type',
                    'nomdefichier',
                    'filename',
                    'finished',
                    'parse',
                    'refresh_parse',
                    'importation',
                    'refresh_importation',
                    ]

    # variable de reception du contenu de fichier (original)
    origfilevarnames  = CSV2_FILEVARNAMES

    # pool pour les noms de variables de réception
    filevarnames = []
    request_keys.extend(CSV2_FILEVARNAMES['eleve_ss_resp'])
    request_keys.extend(CSV2_FILEVARNAMES['enseignant'])
    request_keys.extend(CSV2_FILEVARNAMES['administratif'])
    request_keys.extend(CSV2_FILEVARNAMES['autre'])
    request = Dict(default={}, keys=request_keys)
    file_download_entete = "Importation de '%s' au format : CSV"
