# -*- coding: UTF-8 -*-
"""Définition et enregistrement des actions"""

# imports ead
from ead2.backend.config.help import help_templates
from ead2.backend.actions import tools

from ead2.lib.libead import uni
# Import lié au refactoring

# FIXME : permet de conserver la compatibilité avec les actions déjà développé
from ead2.backend.lib.typedobjects import * # Text, Dict ...
from ead2.backend.lib.metaclass import ActionMetaclasse, REGISTERED_ACTIONS

def get_action_classes():
    """
    :return: l'ensemble des noms des actions possibles
    """
    return list(REGISTERED_ACTIONS.values())

def get_action_dict():
    """
        l'ensemble des actions possibles
    """
    return REGISTERED_ACTIONS

def get_action(action_name):
    """
        Renvoie la classe d'action action_name
    """
    return REGISTERED_ACTIONS[action_name]

class Action(metaclass=ActionMetaclasse):
    """classe de base pour les actions"""

    url = Text(default={}, doc="url de l'api")

    def send_all(self, result, template, templates=[]):
        """
            renvoie les données au frontend pour toute la page
        """
        if self.name in help_templates:
            result['help'] = {'href':tools.make_help_link(self.server_nb,
                                                          'help',
                                                          help_page=self.name)}
        if 'main' not in templates:
            templates.append('main')

        data = {'content':result}
        data['templates'] = templates
        d = {'template':template, 'data':data}
        return 0, uni(str(d))

    def send_frag(self, result, template, templates=[]):
        """ renvoie les données au frontend pour un fragment de page """
        data = {'content':result}
        if 'main' not in templates:
            templates.append('main')
        data['templates'] = templates
        d = {'template':template, 'data':data}
        return 0, uni(str(d))
