# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2017
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
###########################################################################
"""
    Action d'édition des listes pour le filtrage utilisateurs
"""
from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
import ead2.backend.actions.amon.amon_tools as t
from ead2.backend.actions.amon import user

used_templates = ['main', 'form', 'formselect', 'accordion']
zone_libelle = t.get_zone_libelle(3)

class Userweb3(Action):
    """
        interface de gestion des utilisateurs
        sur l'instance 1 de guardian
    """
    user_description = Dict(default={},
                            doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'user_web3'
    libelle = 'Utilisateurs'
    description = "Gestion des utilisateurs sur '%s'" % (
                                    zone_libelle.lower(),)
    category = zone_libelle.capitalize()
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'todel', 'policy', 'user'])
    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['create_user'])

    def execute(self):
        """ renvoit les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if 'create_user' in self.form_result:
            try:
                datas = user.add_user('web3',
                                        tools.format_form_result(
                                         self.form_result['create_user']))
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_user',
                                         templates=used_templates)

        elif 'policy' in params:
            if 'user' in params:
                u = params['user'][0]
                policy = params['policy'][0]
                try:
                    datas = user.mod_user('web3', policy, u)
                    datas['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True)
                except Exception as msg:
                    log.err()
                    datas = dict(message=str(msg))
                self.form_result = {}
                return self.send_frag(datas, template='amon_user',
                                             templates=used_templates)
        elif 'todel' in params:
            u = params['todel'][0]
            try:
                datas = user.del_user('web3', u)
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True)
            except Exception as msg:
                log.err()
                datas = dict(message=str(msg))
            self.form_result = {}
            return self.send_frag(datas, template='amon_user',
                                         templates=used_templates)

        result = {'titre': self.description}
        result.update(user.add_form('web3'))
        result.update(user.get_list('web3', self.server_nb, self.name))
        result['validate'] = user.get_validate(self.server_nb, self.name)
        return self.send_all(result, template='amon_user',
                                     templates=used_templates)
