# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Outil de gestion des entrées utilisateurs 'bizarres'
    (doublons, utilisateurs non retrouvés)...
"""
from twisted.python import log
from twisted.internet.defer import Deferred

from scribe.linker import get_userclass_instance

from ead2.backend.config.config import debug
from ead2.backend.lib.action import Dict
from ead2.backend.actions.tools import format_form_result
from ead2.backend.actions.lib.main import Main
from ead2.backend.actions.lib.error import _clean_errors
from ead2.backend.actions.lib.widgets import main as M, ajax

from ead2.backend.actions.scribe.tool import userpurge

class UserPurge(Main):
    """
        Classes d'action Ead2
    """
    # definition de l'action
    name = 'scribe_user_purge'
    description = "Purge des comptes utilisateurs"
    libelle = "Purge des comptes"
    category = "Gestion/Utilisateurs/"
    # templates utilisés
    template = 'scribe_userpurge'
    widget_templates = ['main', 'form', 'formselect', 'form_gen']
    usertype_formname = userpurge.FORMNAMES['usertype_formname']
    userlist_action_formname = userpurge.FORMNAMES['userlist_action_formname']

    # entrées de requête
    request = Dict(default={},
            doc="arguments de la requete en cours cote frontend",
            keys=['server', 'action', 'purge_action', 'user_uid'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=userpurge.FORMNAMES)

    def execute(self):
        """
            Répond à la demande d'action
        """
        self.parse_request()
        if debug:
            log.msg("# Gestion des comptes utilisateurs hors d'usage #")
            log.msg(" ->> Les paramètres : %s" % self.params)
        return_dict = dict(titre=self.description)
        if not self.form_result:
            if debug:
                log.msg(" + Entrée de l'action")
            deferred = Deferred()
            deferred.callback(return_dict)
            deferred.addCallback(self.get_usertype_formulaire)
        elif self.usertype_formname in list(self.form_result.keys()):
            if debug:
                log.msg(" + On s'apprête à lister les utilisateurs")
            deferred = self.get_user_list()
            deferred.addErrback(_clean_errors,
                    "Erreur au listing des utilisateurs")
        elif self.userlist_action_formname in list(self.form_result.keys()) \
                                    and self.params.get('purge_action'):
            actionname = self.params['purge_action'][0]
            if debug:
                log.msg(" + On va exécuter une action : %s" % actionname)
            formulaire = format_form_result(self.form_result[
                                            self.userlist_action_formname])
            self.form_result = {}
            ldapuser = get_userclass_instance(self.memory['usertype'])
            deferred = userpurge.valid_action(actionname,
                                              ldapuser,
                                              formulaire)
            deferred.addCallback(self.add_toexec_link)
        deferred.addCallback(self.main)
        deferred.addErrback(self.send_error)
        return deferred

    def main(self, return_dict):
        """
            Renvoie les informations
        """
        return self.send_all(return_dict,
                             template=self.template,
                             templates=self.widget_templates)

    def send_error(self, error, message=None):
        """
            Lancé en cas d'erreur dans l'éxécution
        """
        if debug:
            log.msg(" - Dans send_error -")
        if not message:
            message = error.getErrorMessage()
            if debug:
                log.msg(error.getErrorMessage())
        return_dict = dict(message=message)
        return self.send_all(return_dict,
                             template=self.template,
                             templates=self.widget_templates)

    def get_usertype_form_link(self):
        """
            Renvoie le lien pour la validation du formulaire usertype
        """
        return ajax.valid(self.server_nb,
                          self.name,
                          formnames=[self.usertype_formname],
                          container="div_userlist")

    def get_usertype_formulaire(self, return_dict):
        """
            Renvoie le formulaire de sélection
            des types d'utilisateur et de la date
        """
        formulaire = dict(name=self.usertype_formname)
        formulaire['select_usertype'] = userpurge.get_select_usertype()
        formulaire['date_input'] = userpurge.get_date_input()
        formulaire['bouton_valider'] = M.Submit(href=
                                        self.get_usertype_form_link())
        return_dict['formulaire'] = formulaire
        return return_dict

    def save(self, xxx_todo_changeme):
        """
            Enregistre les données pour le listing des utilisateurs
        """
        (filtertype, usertype, lastupdate) = xxx_todo_changeme
        self.remember('usertype', usertype)
        self.remember('filtertype', filtertype)
        self.remember('lastupdate', lastupdate)
        return filtertype

    def _split_callback_chain(self, filtertype):
        """
            Split la chaine d'éxécution entre fantom et doublon
        """
        deferred = Deferred()
        deferred.callback(self.memory)
        deferred.addCallback(userpurge.__getattribute__('_list_%s' % (
                                                            filtertype,)))
        return deferred

    def get_user_list(self):
        """
            Renvoie la liste des utilisateurs
        """
        deferred = Deferred()
        deferred.callback(self.form_result.pop(self.usertype_formname))
        deferred.addCallback(format_form_result)
        deferred.addCallback(userpurge.get_search_vars)
        deferred.addErrback(_clean_errors,
                "Erreur à la récupération des critères de recherche")
        deferred.addCallback(self.save)
        deferred.addErrback(_clean_errors,
                "Erreur à l'enregistrement des critères de recherche")
        deferred.addCallback(self._split_callback_chain)
        deferred.addCallback(userpurge.make_ret_dict,
                            server_nb=self.server_nb,
                                actionname=self.name,
                 usertype=self.memory.get('usertype'))

        return deferred

    def add_toexec_link(self, return_dict):
        """
            Rajoute un appel de rafraichissement
            de la liste d'utilisateur
        """
        return_dict['toexec'] = self.get_usertype_form_link()
        return return_dict

