# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Actions permettant de gérer les groupes """
from twisted.python import log
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.actions import tools
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.scribe.tool import getform
from ead2.backend.actions.lib.widgets import main as M
from ead2.backend.actions.scribe.tool.group import (used_templates,
     typedict, _get_menu, groupe_create, classe_create, etab_create)
from scribe.ldapconf import SUPPORT_ETAB

class GroupCreate(Action):
    """ creation de groupe
        :_type: type de groupe à créer (clés de typedict)
    """
    user_description = Dict(default={}, doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_group_create'
    libelle = "Création de groupe"
    category = "Gestion/Groupes/"
    description = 'Créer un groupe'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', '_type'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['current_type', 'add_group'])

    def execute(self):
        """ renvoit les données pour l'affichage
            1 - récupération du type de groupe à créer
            2 - renvoie le formulaire de création de groupe
            3 - valide la création de groupe
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':"Gestion des groupes"}
        self._type = "groupe"
        ## 1 -
        if '_type' in params:
            self._type = params['_type'][0].strip()
        if self.form_result != {}:
            ## 1 -
            if 'current_type' in self.form_result:
                self._type = tools.format_form_result(self.form_result['current_type'])['_type']
                self.form_result.pop('current_type')
            ## 3 -
            try:
                result['message'] = self._valid_form()
            except (MissingValue, MissingKey, Exception) as mess:
                log.err("Erreur dans group.py : %s"%mess)
                log.err()
                result['message'] = str(mess)
            self.form_result = {}
        ## 2 -
        typedico = {'classe':'une classe', 'niveau':'un niveau',
                    'groupe':'un groupe de travail', 'matiere':'une matière',
                    'option':'une option', 'service':'un service administratif',
                   }
        if SUPPORT_ETAB:
            typedico['etablissement'] = 'un établissement'
        # titre principal
        result['sstitre'] = "Créer %s" % typedico[self._type]
        # sous-menu
        result.update(_get_menu(self.server_nb, self._type))
        # champs du formulaire
        result.update(getform.groupe_form(self._type,
                                          typedict[self._type]['message']))
        # bouton de validation
        result.update(self._get_valid_btn())
        result['_type'] = {'name':'_type', 'default_value':self._type }
        return self.send_all(result, template='scribe_group',
                             templates=used_templates)

    def _valid_form(self):
        """ valide la création de groupe """
        if self._type == 'classe':
            return self._valid_classe()
        elif self._type == 'etablissement':
            return self._valid_etab()
        else:
            return self._valid_groupe()

    def _valid_classe(self):
        """ ajoute une classe dans l'annuaire """
        if 'add_group' not in self.form_result:
            raise MissingKey("Le résultat de formulaire est vide")
        creation = tools.format_form_result(self.form_result['add_group'])
        return classe_create(creation)

    def _valid_etab(self):
        """ ajoute un etab dans l'annuaire """
        if 'add_group' not in self.form_result:
            raise MissingKey("Le résultat de formulaire est vide")
        creation = tools.format_form_result(self.form_result['add_group'])
        return etab_create(creation, typedict[self._type]['tgroupe'],
                            typedict[self._type]['message'])

    def _valid_groupe(self):
        """ ajoute un groupe dans l'annuaire """
        if 'add_group' not in self.form_result:
            raise MissingKey("Le résultat de formulaire est vide")
        creation = tools.format_form_result(self.form_result['add_group'])
        return groupe_create(creation, typedict[self._type]['tgroupe'],
                            typedict[self._type]['message'])

    def _get_valid_btn(self):
        """
        bouton valider pour la creation d'user
        passe en meme temps le type en cours (classe, nivo...)
        """
        href = tools.make_form_link(self.server_nb, self.name, True,
                                    ['current_type', 'add_group'])
        return dict(validate=M.Submit(href=href))

