#! /usr/bin/perl -w
##-IEcoStations-2.0
# Laurent Guinard - Académie de Reims
#
# Script d'insertion de ecostation_start dans le cron de root
# à partir du fichier (ecostations_start.txt) produit par l'outil d'administration web..
#
# Attention ecoStations_start.txt doit être au format Unix.
# aucun controle n'est fait sur le format des paramètres, on assume qu'ils sont toujours correctement présentés


$REP_ECOSTATION="/var/www/html/outils/ecoStations";

# On lit les paramètres du fichier ecostations_start.txt
if (open(FIC_ECOSTAT_START, "$REP_ECOSTATION/config/ecoStations_start.txt")){ 
	$i_start=0;
	while ($ligne_start = <FIC_ECOSTAT_START>) {
		chomp($ligne_start);
		if ($ligne_start =~ /(.+)\|(.+)\|(.+)/) {
			$horaire_start = $1;
			$jours_start = $2;
			#on vérifie le format de l'horaire pour ne pas prendre la ligne d'entête
			if ( $horaire_start =~ /^([0-9][0-9]):([0-9][0-9])$/ ) {
				$PARAM_START{horaire}[$i_start] = $horaire_start;
				$PARAM_START{jours}[$i_start] = $jours_start;
				$i_start++;
			}
		}
	}
	close(FIC_ECOSTAT_START);
} else {
	`rm -f $REP_ECOSTATION/cron/ecoStations_start.cron`;
	`rm -f /etc/cron.d/ecoStations_start`;
}

# Création du fichier cron/ecoStations_start.cron qui va déclencher start_stations.pl
# s'il y a au moins une planification de démarrage
if ( defined($PARAM_START{horaire}[0]) ) {
	open (FIC_CRON_START, "> $REP_ECOSTATION/cron/ecoStations_start.cron");
	print FIC_CRON_START "# ECOSTATION: déclenchement du script permettant le démarrage de stations\n";
	# ajout d'une ligne pour chaque planification dans le fichier ecoStations.cron
	for( my $k=0; $k<$i_start; $k++) {
		if ($PARAM_START{horaire}[$k] =~ /^([0-9][0-9]):([0-9][0-9])$/ ) {
			$heure_start = $1;
			$min_start = $2;
			$jours = $PARAM_START{jours}[$k];
			$jours =~ s/Lu/1/;
			$jours =~ s/Ma/2/;
			$jours =~ s/Me/3/;
			$jours =~ s/Je/4/;
			$jours =~ s/Ve/5/;
			$jours =~ s/Sa/6/;
			$jours =~ s/Di/0/;
			$l = $k + 1;
			print FIC_CRON_START "$min_start $heure_start * * $jours root $REP_ECOSTATION/start_stations.pl H$l >& /dev/null\n";
		}
	}
	`/bin/cp -f $REP_ECOSTATION/cron/ecoStations_start.cron /etc/cron.d/ecoStations_start`;
	close(FIC_CRON_START);
	`/usr/bin/crontab -l|crontab -`;
	`/etc/init.d/cron restart`;
} else {
	`rm -f $REP_ECOSTATION/cron/ecoStations_start.cron`;
	`rm -f /etc/cron.d/ecoStations_start`;
}