<?php
//Inspiré du Fichier original trouvé dans CdT sur Scribe / Eole

//client CAS utilisé par index.php pour la connexion et logout.php pour la déconnexion
$envole_cas = null;

//présent dans l'include_path du php.ini (/usr/share/php)
include_once("CAS/eoleCAS.php");
include_once("configCAS/cas.inc.php");

//instanciation du client CAS
function envole_cas_instance()
	{
	global $envole_cas;
	if(empty($envole_cas))
		{
		$envole_cas = new eolephpCAS();
		$envole_cas->client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
		if(method_exists($envole_cas,'setNoCasServerValidation')) $envole_cas->setNoCasServerValidation();
		if(method_exists($envole_cas,'EoleLogoutRequests')) $envole_cas->EoleLogoutRequests(false);
		}
	}

//authentification et récupération des informations sur l'utilisateur
function envole_cas_auth()
	{
	global $envole_cas;

	//instanciation
	envole_cas_instance();

	//forcer à redemander les infos auprès du serveur CAS (au lieu de les lire en session alors que ce serait les infos d'une autre appli...)
	if(isset($_SESSION["phpCAS"])) unset($_SESSION["phpCAS"]);

	//authentification
	$envole_cas->forceAuthentication();
	
	//récupération des informations de l'utilisateur
	return $envole_cas->getDetails();
	}

//déconnexion
function envole_cas_logout($urlRedir)
	{
	global $envole_cas;

	//instanciation
	envole_cas_instance();
	
	//procédure de déconnexion du serveur CAS
	$url = (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS'])) ? "https://" : "http://";
	if(empty($_SERVER['SERVER_NAME'])) $url .= $_SERVER['HTTP_HOST'];
	else $url .= $_SERVER['SERVER_NAME'];
	$url .= $urlRedir; //"/outils/quotas/index.php?envole_logout=5"; //variable "envole_logout" pour identifier la redirection
	if(method_exists($envole_cas,'logoutWithUrl')) $envole_cas->logoutWithUrl($url);
	else $envole_cas->logout($url);
	}
?>
