#! /usr/bin/perl -w
##-IEcoStations-2.0
# Académie de Besançon - PR
#
#

sub stop_ordi {
	my $ip = shift(@_);
	`/usr/share/eole/controlevnc/cliscribe.py $ip -execute 'shutdown -s -f -t 0' HIDE >/dev/null 2>&1 &`;
}

$REP_ECOSTATION="/var/www/html/outils/ecoStations";

# On lit les paramètres du fichier ecostations.txt
open(FIC_ECOSTAT, "$REP_ECOSTATION/config/ecoStations.txt") or die "ouverture impossible ecoStations.txt";
while ($ligne = <FIC_ECOSTAT>) {
        chomp($ligne);
        if ( $ligne =~ /\[(.+)\]/ ) {
                $section=$1;
		$PARAM{$section}.=" ";
        } else {
                if ( $ligne =~ /(.+)/ ) {
                        $PARAM{$section}.="$ligne ";
                }
        }
}
close(FIC_ECOSTAT);
$HR_PROG="";
	if ( $ARGV[0] =~ /H1/) {
		$HORAIRE="horaire1_exclusions";
		$INFO_HORAIRE="1";
		if ( $PARAM{horaires} =~ /^ (..:..) (..:..) $/ ){ $HR_PROG = $1; }
	} else {
		$HORAIRE="horaire2_exclusions";
		$INFO_HORAIRE="2";
		if ( $PARAM{horaires} =~ /^ (..:..) (..:..) $/ ){ $HR_PROG = $2; }
	}



$ORDI{exclus}="";
$ORDI{eteint}="";
$ORDI{inactifs}="";
open(FIC_MACHINES, "/usr/share/eole/controlevnc/machines.db") or die "ouverture impossible machines.db";
while ($ligne = <FIC_MACHINES>) {
	chomp($ligne);
	if ( $ligne =~ /(.+)[:|;]([0-9.]{7,15})[;|:](.+)/ ) {
		$machine=$1;
		$ip=$2;
			if ( $PARAM{$HORAIRE} =~ / $machine /i ){
				$ORDI{exclus}.="$machine, ";
			} else {
	                	if (system("tcpcheck 1 $ip:8788 | grep -q alive")>0){
					$ORDI{inactifs}.="$machine ";
			       } else {
					$ORDI{eteint}.="$machine ";
					stop_ordi($ip);
				}
			}
	}
}
close(FIC_MACHINES);

if ( ! -f "$REP_ECOSTATION/log/ecoStations.log" ) { `touch $REP_ECOSTATION/log/ecoStations.log`; }
$taille=(stat("$REP_ECOSTATION/log/ecoStations.log"))[7];
if ( $taille > 100000 ) { `mv $REP_ECOSTATION/log/ecoStations.log $REP_ECOSTATION/log/ecoStations.log.1`; }
open(FIC_LOG,">> $REP_ECOSTATION/log/ecoStations.log") or die "ouverture impossible log/ecoStations.log";
$DATE=`date '+%d/%m/%y %H:%M:%S'`;
chomp($DATE);
print FIC_LOG "--------------------------------------------------------------------------\n";
print FIC_LOG "$DATE - Arret des stations à $HR_PROG (Horaire $INFO_HORAIRE)\n";
print FIC_LOG "Ordi exclus : $PARAM{$HORAIRE}\n";
print FIC_LOG "Ordi exclus trouvés dans la base : $ORDI{exclus}\n";
print FIC_LOG "Ordi trouvés dans la base mais testés inactifs : $ORDI{inactifs}\n";
print FIC_LOG "Ordi trouvés dans la base, actifs, ayant reçu l'ordre de s'éteindre : $ORDI{eteint}\n";
print FIC_LOG "\n\n";
close(FIC_LOG);

