<?php
/*---------------------------------------------------------------
		f_scribe.inc.php
-----------------------------------------------------------------
	Librairie de fonctions pour les services installés
   sur les serveurs Eole Scribe
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/

//*------------------=O===================O----------------------
$_charset_="UTF-8";


/*------------------------------------------
 Fonction : headerPage
-------------------------------------
 Envoie les infos header pour la page
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function headerPage() {
	global $_charset_;
	
	$now = gmdate('D, d M Y H:i:s') . ' GMT';
	//Entête page
	header('Expires: ' . $now);
	header('Last-Modified: ' . $now);
	header('Cache-Control: no-store, no-cache, must-revalidate'); // HTTP/1.1
	header('Cache-Control: pre-check=0, post-check=0, max-age=0'); // HTTP/1.1
	header('Pragma: no-cache'); // HTTP/1.0
	header("Content-Type: text/html; charset=$_charset_");
} //fin de fonction

/*------------------------------------------
 Fonction : enteteHTML
-------------------------------------
 Envoie les infos d'entête de la page HTML
-------------------------------------
 - Entrée : le titre de la page
 						si souhaité, une liste (un tableau) de fichier(s) a rajouter dans l'entête. Traîter différement suivant l'extension du fichier (ico,css,js)
 - Sortie :
---------------------------------------------*/
function enteteHTML($titrePage="titre de la page", $lignesHeader=false) {
	global $_charset_;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
	<title><?php echo $titrePage; ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo 	$_charset_ ;?>">
<?php
	if (is_array($lignesHeader)) foreach ($lignesHeader as $_ligneH) {
		switch(strtolower(substr($_ligneH,-3))) {
			case "css":
				$_laLigne='<LINK rel="stylesheet" type="text/css" href="'.$_ligneH.'" />';
				break;
			case ".js":
				$_laLigne='<script type="text/javascript" src="'.$_ligneH.'"></script>';
				break;
			case "ico":
				$_laLigne='<link href="'.$_ligneH.'" rel="shortcut icon" type="image/x-icon" />';
				break;
			case "png":
				$_laLigne='<link href="'.$_ligneH.'" rel="icon" type="image/png" />';
				break;
		}
		echo $_laLigne.CR;
	}
?>	
</head>
<body>

<?php
} //fin de fonction

/*------------------------------------------
 Fonction : finHTML
-------------------------------------
 Envoie le code de fin de code HTML
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function finHTML() {
?>
</body>
</html>
<?php
} //fin de fonction 

/*------------------------------------------
 Classe : tableau_HTML
-------------------------------------
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/

define ('CNT',0); //index pour le contenu de la cellule du tableau
define ('FMT',1); //index pour le format de la cellule du tableau

class tableau_HTML {
	var $nbLig,$nbCol;
	//var $header,$nbLigH; //indique s'il y a ou non une ligne header, ainsi que le nombre de lignes
	//var $contTabH;
	var $contTab,$tabFmtLig; //tableau avec le contenu, le format des lignes
	var $style,$fmtTab;
	
	/*-----------------------------
	// constructeur - initialise le tableau 
	------------------------------*/
	function tableau_HTML($nbCol=1,$style=0) { //,$header=false,$nbLigHeader=0) {
		$this->nbCol=$nbCol;
		$this->nbLig=0;
		$this->style=$style;
		$this->fmtTab=array();
		//$this->header=$header;
		//$this->nbLigH=$nbLigHeader;
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function ajoute1Ligne() {
		$tabLigne=func_get_args();
		//si le premier paramètre est un  tableau on le prend comme la liste des valeurs de la ligne
		if (isset($tabLigne[0])) if (is_array($tabLigne[0])) $tabLigne=$tabLigne[0];
		for ($idxC=0;$idxC<($this->nbCol);$idxC++) {
			$_cont=(isset($tabLigne[$idxC]))?$tabLigne[$idxC]:'';
			$this->contTab[$this->nbLig][$idxC][CNT]=$_cont;
		}
		$this->nbLig++;
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function ajouteLignes($tabL) { 
		if (!is_array($tabL)) return false;
		if (count($tabL)<1) return false;
		foreach ($tabL as $_ligne) {
			$this->ajoute1Ligne($_ligne);
		}
	}
	

	/*-----------------------------
	// fabrique une chaine d'attribut HTML à partir d'un tableau de valeur 
	------------------------------*/
	function chaineAttributs($tabAttr) {
		if (!is_array($tabAttr)) return false;
		if (count($tabAttr)==0) return false;
		$nbAttr=count($tabAttr);
		$chaineFmt="";
		foreach($tabAttr as $attr=>$val) { //chaque couple d'attribut=valeur
			if ($chaineFmt!="") $chaineFmt.=' ';
			$chaineFmt.=$attr.'="'.$val.'"';
		}
		return $chaineFmt;
	}
	
	/*-----------------------------
	// formate le tableau 
	------------------------------*/
	function formatTableau() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		for($idx=0; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->fmtTab[$format[$idx]]);
			else $this->fmtTab[$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function formatLigne() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par défaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numéro de ligne
		}
		$chaineFmt="";
		for($idx=$premArg; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->tabFmtLig[$laLigne][$format[$idx]]);
			else $this->tabFmtLig[$laLigne][$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// formate la ligne cellule par cellule avec le même format
	------------------------------*/
	function formatLigneParCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par défaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numéro de ligne
		}
		for ($idxC=0;$idxC<($this->nbCol);$idxC++) {
			for($idx=$premArg; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
				if ($format[$idx+1]===null) unset($this->contTab[$laLigne][$idxC][FMT][$format[$idx]]);
				else $this->contTab[$laLigne][$idxC][FMT][$format[$idx]]=$format[$idx+1];
			}
		}
	}
	
	/*-----------------------------
	// formate la ligne cellule par cellule
	------------------------------*/
	function formatLigneParMultiCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par défaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numéro de ligne
		}
		$col=-1;
		for($idx=$premArg;$idx<$nbArgs; $idx++) { //chaque entrée contient un tableau où se succèdent les couples d'attribut=valeur
			//$chaineFmt="";
			$col++;
			if (is_array($format[$idx])) {
				$nbOptFormat=count($format[$idx]);
				for ($idxF=0;($idxF<$nbOptFormat && ($nbOptFormat-$idxF)>1);$idxF+=2) {
					if ($format[$idx][$idxF+1]===null) unset($this->contTab[$laLigne][$col][FMT][$format[$idx][$idxF]]);
					else $this->contTab[$laLigne][$col][FMT][$format[$idx][$idxF]]=$format[$idx][$idxF+1];
				}
			} else continue; 
		}
	}
	
	
	/*-----------------------------
	// formate la colonne cellule par cellule
	------------------------------*/
	function formatColonneParCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		if (is_numeric($format[0])) {
			$laColonne=$format[0]-1; //on prend le premier argument comme numéro de colonne
		} else return false; //on doit forcément fournir le n° de colonne en premier pour affecter le format
		$chaineFmt="";
		for ($idxL=0;$idxL<($this->nbLig);$idxL++) {
			for($idx=1; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
				if ($format[$idx+1]===null) unset($this->contTab[$idxL][$laColonne][FMT][$format[$idx]]);
				else $this->contTab[$idxL][$laColonne][FMT][$format[$idx]]=$format[$idx+1];
			}
		}
	}
	
	/*-----------------------------
	// formate la cellule souhaitée
	------------------------------*/
	function formatCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		if (is_numeric($format[0]) && is_numeric($format[1])) { //ligne et colonne passées en 1er et 2ème argument
			$laLigne=$format[0]-1; //on prend le premier argument comme numéro de ligne
			$laColonne=$format[1]-1; //on prend le second argument comme numéro de colonne
		} else return false; //on doit forcément fournir le n° de colonne en premier pour affecter le format
		$chaineFmt="";
		for($idx=2; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->contTab[$laLigne][$laColonne][FMT][$format[$idx]]);
			else $this->contTab[$laLigne][$laColonne][FMT][$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// applique le style au tableau
	------------------------------*/
	function appliqueStyle() {
		switch ($this->style) {
			case 1: 
				$this->fmtTab=array('class'=>"tTab_1",'cellpadding'=>0,'cellspacing'=>0,'style'=>"white-space:nowrap");
				for ($idxL=2,$_idxL=1;$idxL<=$this->nbLig;$idxL++,$_idxL=(3-$_idxL)) {
					$this->formatLigne($idxL,'class',"tLig".$_idxL."_1",'height',24,'valign',"middle");
					$this->formatCellule($idxL,1,'class',"tCol1_".$_idxL."_1 pad3_10");
				}
				for ($idxC=2;$idxC<=$this->nbCol;$idxC++) {
					$this->formatColonneParCellule($idxC,'class',"tBG_1 pad3_10");
				}
				//$this->formatColonneParCellule(1,'class',"tCol1_1");
				$this->formatLigne(1,'class',"tTitre_1",'height',24);
				break;
			
			case 2: 
				$this->fmtTab=array('class'=>"tTab_2",'cellpadding'=>0,'cellspacing'=>0,'style'=>"white-space:nowrap");
				for ($idxL=2,$_idxL=1;$idxL<=$this->nbLig;$idxL++,$_idxL=(3-$_idxL)) {
					$this->formatLigne($idxL,'class',"tLig".$_idxL."_2",'height',20,'valign',"middle");
					$this->formatCellule($idxL,1,'class',"tCol1_".$_idxL."_2 pad3_10");
				}
				for ($idxC=2;$idxC<=$this->nbCol;$idxC++) {
					$this->formatColonneParCellule($idxC,'class',"tBG_2 pad3_10");
				}
				//$this->formatColonneParCellule(1,'class',"tCol1_1");
				$this->formatLigne(1,'class',"tTitre_2",'height',20);
				break;
			
			case 0:
			default:break;
		}
	}
	
	/*-----------------------------
	// génère le code HTML du tableau
	------------------------------*/
	function rendu() {
		
		//applique le style au tableau 
		$this->appliqueStyle();
		//echo tab2html($this->contTab);
		if ($this->nbLig==0) return false;
		$_fmtTab=$this->chaineAttributs($this->fmtTab);
		if ($_fmtTab!="") $_fmtTab=' '.$_fmtTab;
		$tab='<table'.$_fmtTab.'>'.CR;
		//contenu du tableau
		for ($idxL=0;$idxL<($this->nbLig);$idxL++) {
			if (isset($this->tabFmtLig[$idxL])) $_style=' '.$this->chaineAttributs($this->tabFmtLig[$idxL]); else $_style="";
			$tab.='<tr'.$_style.'>'.CR;
			for ($idxC=0;$idxC<($this->nbCol);$idxC++) {
				$_cont=(isset($this->contTab[$idxL][$idxC][CNT]))?$this->contTab[$idxL][$idxC][CNT]:'';
				$_format=(isset($this->contTab[$idxL][$idxC][FMT]))?' '.$this->chaineAttributs($this->contTab[$idxL][$idxC][FMT]):'';
				$tab.='<td'.$_format.'>'.(($_cont!='')?$_cont:'&nbsp;').'</td>'.CR;
			}
			$tab.='</tr>'.CR;
		}
		$tab.='</table>'.CR;
		return $tab;
	}
} //fin de classe tableau_HTML


//----------------- partie de programme toujours chargée ------------------------------
define('CR', "\n");
define('BR', "<br/>");
define('CRLF', "\r\n");
define('BRCR', "<br/>\n");
define('NBSP', "&nbsp;");
define('NBSP2', "&nbsp;&nbsp;");
define('NBSP3', "&nbsp;&nbsp;&nbsp;");
define('NBSP4', "&nbsp;&nbsp;&nbsp;&nbsp;");
define('NBSP5', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");

//charge le fichier de définition du service
if (file_exists('./config/infoService.inc.php')) require ('./config/infoService.inc.php'); 
if (file_exists('./config/config.inc.php')) require ('./config/config.inc.php'); 
$_version_="";
if (file_exists('./_version.inc.php')) require ('./_version.inc.php'); 

$tabCiv=array(
	'.'=>"M.",
	'1'=>"M.",
	'2'=>"Mme",
	'3'=>"Mlle",
	'L'=>"Mlle",
	'M'=>"Mme"	
);

?>