<?php
/*---------------------------------------------------------------
		ecoStations.php
-----------------------------------------------------------------
	
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon
	modification : Laurent GUINARD - Académie de Reims
---------------------------------------------------------------*/
include ('./inc/f_session_scribe.inc.php');
include ('./inc/f_ldap_scribe.inc.php');

//initialisation de la Session et recup de l'uid
recupUid();

//sonde piwik
//include("/var/www/html/piwik/envoleProfil.php");
echo "<script src='/piwik/envoleTrackeur.js.php?appli=ecoStations&profil=$uid'></script>";

include ('./inc/f_scribe.inc.php');

//-- gestion des paramètres et des droits --
require ('./inc/c_parametres.inc.php');
require ('./inc/f_droits.inc.php');
require ('./inc/f_groupes.inc.php');

//require ('./inc/f_onglets.inc.php');

//verifie si l'utilisateur connecté est du login ou du groupe mis dans la liste (ELEVES, PROFS, etc...)
//verifAccesPage("admin");
verifAccesPage($comptesAutorises);

$titrePage="EcoStations";

$ficConf='config/confEcoStations.inc.php';
$ficConfstart='config/confEcoStations_start.inc.php';
$ficL1='config/liste1.txt';
$ficL2='config/liste2.txt';
$ficEcoStations='config/ecoStations.txt';
$ficEcoStationstart='config/ecoStations_start.txt';
$ficMachines='config/copie_machines.db';

include ('./incAppli/f_ecoStations.inc.php');

//copie du fichier /usr/share/eole/controlevnc/machines.db dans le répertoire /config
copieMachinesdb();

//------------------- Controler ----------------------
$compoGrp=false;
$msgErreur='';
$mode='rien';
$onglet='tab-conf';
$ligneCron="";
$jours = "";
$horaireplan = "";
$stationplan = "";
$jourplan = "";
$nbplan = 0;
$verroumodifstop = 0;
$verroumodif = 0;
$verroumodifparam = 0;
$verrouajout = 0;

if (isset($_POST['valstop'])) {
	$mode='validstop';
} else if (isset($_POST['modifstop'])) {
	$mode='modifstop';
} else if (isset($_POST['modifparam'])) {
	$mode='modifparam';
} else if (isset($_POST['valparam'])) {
	$mode='validparam';
} else if (isset($_POST['Annuleparam'])) {
	$mode='annulparam';
} else if (isset($_POST['valstart'])) {
	$mode='validstart';
} else if (isset($_POST['ajoutstart'])) {
	$mode='ajoutstart';
} else if (isset($_POST['modifstart'])) {
	$mode='modifstart';
} else if (isset($_POST['supprstart'])) {
	$mode='supprstart';
} else if (isset($_POST['AnnuleConfstart'])) {
	$mode='annulstart';
} else if (isset($_POST['btactivestop'])) {
	$mode='activationstop';
} else if (isset($_POST['supprstop'])) {
	$mode='supprstop';
} else if (isset($_POST['btactiveplan'])) {
	$mode='activationplan';
}

//---------------------------------- Module ---------------------------------------------------

if (!file_exists($ficConf)) ecritConfHoraires('','','off');
include ($ficConf);
if (!file_exists($ficConfstart)) ecritConfstart('pedagogique','','off');
include ($ficConfstart);

//choix de l'action
switch ($mode) {
			//enregistrement des horaires d_extinction
			case "validstop": 
				//si aucune planification n'existe
				if (!file_exists($ficEcoStations)) {
					//activation de la planification
					$etat_plan_stop='on';
				}
				//enregistrement des horaires d'extinction dans le fichier config/confEcoStations.inc.php
				ecritConfHoraires($_POST['hor1'],$_POST['hor2'],$etat_plan_stop);
				$horaire1=$_POST['hor1'];
				$horaire2=$_POST['hor2'];
				//modification du fichier ecoStations.txt
				ecritFicEcoStations($_POST['hor1'],$_POST['hor2'],$_POST['liste1'],$_POST['liste2']);
				//si la planifcation est activée, modification du fichier ecoStations.cron
				if ($etat_plan_stop=="on") {
					lanceModifCron();
				}
				$onglet="tab-conf";
				break;
			//modification horaire extinction
			case "modifstop":
				$verroumodifstop = 1;
				$onglet="tab-conf";
				break;
			//modification paramétrage
			case "modifparam":
				$verroumodifparam = 1;
				$onglet="tab-conf-start";
				break;
			//validation paramétrage
			case "validparam":
				//modification du fichier config/confEcoStations_start.inc.php
				$zone=$_POST['btzone'];
				$ip=$_POST['IP_peda'];
				ecritConfstart($zone,$ip,$etat_plan);
				$onglet="tab-conf-start";
				break;
			//ajout d'une programmation
			case "ajoutstart":
				$verrouajout = 1;
				$onglet="tab-conf-start";
				break;
			//validation d'une planification de démarrage
			case "validstart":
				$jours = implode(",", $_POST['days']);
				//si aucune planification n'existe
				if (!file_exists($ficEcoStationstart)) {
					//activation de la planification
					$etat_plan="on";
					ecritConfstart($zone,$ip,$etat_plan);
					//include ($ficConfstart);
				}
				//modification du fichier ecoStations_start.txt
				ecritFicEcoStationstart($_POST['hor_start'],$jours,$_POST['nomsStart'],$_POST['num_prog'][0]);
				//si la planification est activée
				if ($etat_plan=="on"){
					//modification du fichier ecoStations_start.cron
					lanceModifCronstart();
				}
				$onglet="tab-conf-start";
				break;
			//suppression de la planification d'arrêt
			case "supprstop":
				unlink($ficConf);
				unlink($ficEcoStations);
				supprcronstop();
				$onglet="tab-conf";
				break;
			//suppression d'une planification de démarrage
			case "supprstart":
				//suppression d'une ligne dans le fichier ecoStations_start.txt
				supprLigneEcoStationstart($_POST['num_prog'],$zone,$ip);
				//si la planification est activée
				if ($etat_plan=="on"){
					//modification du fichier ecoStations_start.cron
					lanceModifCronstart();
				}
				$onglet="tab-conf-start";
				break;
			//modification d'une planification
			case "modifstart":
				//insertion des données du fichier ecoStations_start.txt dans le planificateur
				modifLigneEcoStationstart($_POST['num_prog']);
				$onglet="tab-conf-start";
				break;
			//annulations
			case "annulparam":
				$onglet="tab-conf-start";
				break;
			case "annulstart":
				$onglet="tab-conf-start";
				break;
			//activations désactivations
			case "activationstop":
				activestop($horaire1,$horaire2,$etat_plan_stop);
				//include ($ficConf);
				$etat_plan_stop=($etat_plan_stop=="on")?"off":"on";
				$onglet="tab-conf";
				break;
			case "activationplan":
				activeplan($zone,$ip,$etat_plan);
				$etat_plan=($etat_plan=="on")?"off":"on";
				//include ($ficConfstart);
				$onglet="tab-conf-start";
				break;
}
if (isset($_GET['onglet'])) if ($_GET['onglet']==2) $onglet="tab-conf-start";


//------------------- View -------------------------
headerPage();
enteteHTML($titrePage,array("./jquery/js/jquery-1.7.1.min.js", //jquery-1.11.0.min.js",
							"./jquery/js/jquery-ui-1.8.17.custom.min.js", //jquery-ui-1.10.4.custom.min.js",
							"./jquery/css/custom-theme2/jquery-ui-1.8.17.custom.css",
							"./inc/scribe.css","./inc/tabHTML.css","./incAppli/ecoStations.css",
							"./images/pFavicon.ico.png"));

//$nomUser=$_SESSION['_user_']['prenom']." ".$_SESSION['_user_']['nom'];
?>
<script language="JavaScript">
	var valChange=false;
	var valChange1=false;
	
	//vérification des checkbox des jours à programmer
	function verifchecked() {		
		var i = 0;
		var COCHE = false;
		
		for (i=0;i<document.getElementsByName('days[]').length;i++) {
			if(document.getElementsByName('days[]').item(i).checked) {
				COCHE = true;
				break;
			}
		}
		if (COCHE)
			return true;
		else
			return false;
	} 
	
	//vérification de changement dans la page
	function previentPerteSauve() {
		<?php if ($verroumodifstop == 1 || $verroumodif == 1 || $verroumodifparam == 1 || $verrouajout == 1) echo "valChange=true;" ?>
		if (valChange) {
			alert("Les modifications apportées n'ont pas été sauvegardées.\nVous devez enregistrer ou annuler les changements !");
			return false;
		} else {
			videcheck();
			return true;
		}
	}
	
	function verifsupprstop() {
		if (confirm("Supprimer la planification d'arrêt des stations ?"));
		else return false;
	}
	
	//vérification du nombre de cases cochées pour la suppression de programmation
	function verifsuppr() {
		var i;
		var j;
		var choix = false;
		for (i=0;i<document.getElementsByName('num_prog[]').length;i++){
			if(document.getElementsByName('num_prog[]').item(i).checked) {
				choix = true;
				break;
			}
		}
		if (choix) {
			if (confirm('Supprimer la ou les programmation(s) sélectionnée(s) ?'));
			else {
				//effacer les checkbox
				tags = document.getElementsByTagName('input');
				for (j=0;j<tags.length;j++){
					if (tags[j].type == 'checkbox') {
						tags[j].checked = false;
					}
				}
				//effacer les textarea
				tags = ele.getElementsByTagName('textarea');
				for(j = 0; j < tags.length; j++) {
					tags[j].value = '';
				}
				return false;
			}
		} else {
			alert("Vous devez sélectionner au moins une programmation à supprimer.");
			return false;
		}
	}
	
	//vérification du nombre de cases cochées pour la modification de programmation
	function verifmodifstop() {
		var j = 0;
		var nb_check = 0;
		for (j=0;j<document.getElementsByName('checkhorstop').length;j++){
			if(document.getElementsByName('checkhorstop').item(j).checked) {
				nb_check++;
			}
		}
		if (nb_check == 0) {
			alert("Vous devez sélectionner une programmation à modifier.");
			return false;
		} else {
			if (nb_check == 1) {
				return true;
			} else {
				alert("Vous ne devez cocher qu'une seule programmation à modifier.");
				return false;
			}
		}
	}	
	
	//vérification du nombre de cases cochées pour la modification de programmation
	function verifmodif() {
		var j = 0;
		var nb_check = 0;
		for (j=0;j<document.getElementsByName('num_prog[]').length;j++){
			if(document.getElementsByName('num_prog[]').item(j).checked) {
				nb_check++;
			}
		}
		if (nb_check == 0) {
			alert("Vous devez sélectionner une programmation à modifier.");
			return false;
		} else {
			if (nb_check == 1) {
				return true;
			} else {
				alert("Vous ne devez cocher qu'une seule programmation à modifier.");
				videcheck();
				return false;
			}
		}
	}
	
	//vérification format heure
	function verif_time(inputTime) {
		var timeformat = /^(2[0-3]|[01][0-9]):[0-5][0-9]$/;
		if (inputTime.value.match(timeformat)) {  
			return true;  
		} else {
			return false;  
		}
	}
	
	function verif_stop() {
		//vérification uniquement pour clic sur "Enregistrer"
		if (document.getElementById('actionstop').value=='_valstop') {
			if (verif_time(document.getElementById('_hor1'))) {
				if (verif_time(document.getElementById('_hor2'))) {
					return true;
				} else {
					alert("L'horaire 2 doit être de la forme hh:mm et compris entre 00:00 et 23:59");  
					document.getElementById('_hor2').focus();
					return false;
				}
			} else {  
				alert("L'horaire 1 doit être de la forme hh:mm et compris entre 00:00 et 23:59");  
				document.getElementById('_hor1').focus();
				return false;
			}
		}
	}
	
	//vérification des données de programmation de démarrage
	function verif_program() {
		//vérification uniquement pour clic sur "Enregistrer"
		if (document.getElementById('actionplan').value=='_valstart') {
			if (verif_time(document.getElementById('hor_start'))) {
				if (verifchecked()) {
					if (document.getElementById('_nomsStart').value != '') {
						return true;
					} else {
						alert("Vous devez sélectionner au moins une station à démarrer !");
						return false;
					}
				} else {
					alert("Vous devez cocher au moins un jour de démarrage !");
					return false;
				}
			} else {  
				alert("L'horaire doit être de la forme hh:mm et compris entre 00:00 et 23:59");
				document.getElementById('hor_start').focus();
				return false;  
			}
		}
	}
	
	//affichage zone de saisie d'IP après clic sur bouton "DMZ"
	function affiche_ip() {
		document.getElementById('_IP_peda').style.display = '';
		document.getElementById('_IP_peda').style = 'width:120px;text-align:center;';
		document.getElementById('_text_ip_peda').style = 'color:black';
	}
	
	//cache zone de saisie d'IP après clic sur bouton "péda"
	function cache_ip() {
		document.getElementById('_IP_peda').value = '';
		document.getElementById('_IP_peda').style.display = 'none';
		document.getElementById('_text_ip_peda').style = 'color:grey';
	}
	
	//vérification de la forme de l'adresse IP saisie pour la réservation sur le réseau péda
	function verif_ip() {
		var ipformat = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
		
		//vérification uniquement pour clic sur "Enregistrer"
		if (document.getElementById('action').value=='_valparam') {
			//si dmz cochée
			if (document.getElementById('_dmz').checked) {
				if(document.getElementById('_IP_peda').value.match(ipformat)) {  
					return true;  
				} else {  
					alert("L'adresse IP saisie n'est pas valide !");  
					document.getElementById('_IP_peda').focus();
					return false;  
				}
			}
		}
	}
	
	function annuleoupas() {
		if (valChange1) {
			if (confirm('Annuler les modifications ?')) valChange1 = false;
			else return false;
		}
	}
	
	$(function() {
	$( "#test" ).click(function() {$( "#dialog-message" ).dialog('open');});
	
		//-------- boutons --------------------------------
		$( "#btnAnnuleConfstart" ).click(
			function() {
				if (document.getElementById('hor_start').value!="" || document.getElementById('_nomsStart').value!="" || verifchecked()) {
					if (confirm('Annuler les modifications ?'));
					else return false;
				}
			}
		);
		var laissePasser=false;
		var aideNoMac=false;
		//-------- onglets --------------------------------
		$("#tabs").tabs({hide: 'fade', show: 'fade'});
		$("#tabs").tabs("select", "<?php echo $onglet; ?>");
		$("#tabs").tabs({select:function(event,ui) {if (!laissePasser && !aideNoMac) return previentPerteSauve(); else {laissePasser=false;return true;}}});
		
		function scrollToAnchor(aid){
    	var aTag = $("a[name='"+ aid +"']");
    	$('html,body').animate({scrollTop: aTag.offset().top},'slow');
		}
		
		// permet d'aller sur le lien d'aide pour les postes qui n'ont pas d'adresse MAC
		$(".va_sur_aide").click(function() {
			if (!confirm("Les modifications apportées n'ont pas été sauvegardées.\nVoulez vous quitter cet onglet sans Enregistrer ?")) return false;//alert("cool !");
			laissePasser=true;
			aideNoMac=true;
			$("#tabs").tabs( "select", "#tab-aide" );
			scrollToAnchor('tests');
		});
		
		
		//-------- fenêtre d'avertissement ----------------
		$( "#dialog:ui-dialog" ).dialog( "destroy" );
		$( "#dialog-message" ).dialog({
			autoOpen: <?php if ($msgErreur!="") echo "true"; else echo "false"; ?>,
			dialogClass : 'ft08',
			modal: true,
			buttons: {
				Ok: function() {
					$( this ).dialog( "close" );
				}
			}
		});

	
		//-------- gestion de la fenêtre crédit ------------
		var togCredit=false;
		var hautCredit=$( "#credit" ).height();
		var decalCredit=hautCredit-$( "#contCredit" ).outerHeight()-3;
		var coulCredit=$( "#clickCredit" ).css("color");
		$( "#credit" ).animate({ top: (-hautCredit+12)+"px" }, 200 );
		$( "#credit" ).click(function(){
			if (!togCredit) $( "#credit" ).animate({ top: (-decalCredit+10)+"px" }, 200 );
			else $( "#credit" ).animate({ top: (-hautCredit+12)+"px" }, 200 );
			togCredit=!togCredit;	
		});
		$( "#credit" ).hover(
		function() {
			$( "#clickCredit" ).css({'font-weight':'bold','color':'black'});
		}, function() {
			$( "#clickCredit" ).css({'font-weight':'normal','color':coulCredit});
		});
	});//ui-widget-content 
</script>

<div id="contGlobal">

<div id="dialog-message" title="Erreur !" style="font-size:0.9em" >
	<p>
		<span class="ui-icon ui-icon-circle-check" style="float:left; margin:0 7px 50px 0"></span>
		<?php echo $msgErreur; ?>
	</p>
</div>

	<div id="contOutil" class="ui-corner-all">
<?php
//titre de la page
//echo cadreTitrePage($titrePage);

//afichage des icônes param
//$icoParam=codeJQIconeParam("./param.php", 2, 3, 0);
//if ($icoParam!='') echo '<div id="contIcones">'.$icoParam.'</div>';
echo cadreLoginDeconnexion($uid, 6, 6); //46);

//prépare la fenêtre de saisie du mot de passe
//echo codeJQsaisieMdP("./param.php", "./param.php?onglet=2");

if ($retour!="") echo $retour; //affichage de la fenêtre d'avertissement ou changement de page si nécessaire


?>
		<h1>EcoStations</h1>
		<div id="lesTabs" style="margin:20px 0 0 0">
			<div id="tabs">
				<ul>
					<li><a href="#tab-conf">Configuration d'arrêt des stations</a></li>
					<li><a href="#tab-conf-start">Configuration de démarrage des stations</a></li>
					<li><a href="#tab-aide">Aide</a></li>
				</ul>
				
			<!-- Formulaire -->
			<form action="ecoStations.php" method="POST" id="formHor" onsubmit="return verif_stop()">
				
				<!-- config extinction                 -->
				<div id="tab-conf" class="contTabs">
					
					 
					<?php 
					//si le fichier config/ecoStations.txt existe 
					if(file_exists($ficEcoStations)) {
						//si la planification d'arrêt est activée
						if($etat_plan_stop=='on') {
							$statut_stop = 'activée';
							$action_stop = 'Désactiver';
						//sinon
						} else {
							$statut_stop = 'désactivée';
							$action_stop = 'Activer';
						}?>
						<h2>Planification <?php echo $statut_stop;?></h2>
						<center>
						<table class="tabeco">
							<th style="text-align:center;width:60px;">Horaire</th>
							<th style="text-align:left;padding-left:20px;">Stations à ne pas arrêter</th>
							</tr>
							<tr>
								<td style="text-align:center;padding-top:5px;"><?php echo $horaire1;?></td>
								<td style="text-align:left;padding-left:20px;padding-top:5px;"><?php echo afficheListe(litListe($ficEcoStations,'1')); ?></td>
							</tr>
							<tr>
								<td style="text-align:center;padding-top:5px;"><?php echo $horaire2;?></td>
								<td style="text-align:left;padding-left:20px;padding-top:5px;"><?php echo afficheListe(litListe($ficEcoStations,'2')); ?></td>
							</tr>
						</table>
						<!-- boutons mofifier, supprimer, activer-->
						<!-- si on est en modification on verrouille les boutons -->
						<?php if ($verroumodifstop == 1) {?>
						<input type="submit" id="_modifstop" name="modifstop" value="Modifier" style="margin-right:20px;" disabled="disabled">
						<input type="submit" id="_supprstop" name="supprstop" value="Supprimer" style="margin-right:20px;" disabled="disabled">
						<input type="submit" id="_btactivestop" name="btactivestop" value="<?php echo $action_stop;?>" disabled="disabled">
						<!-- sinon les boutons sont actifs -->
						<?php } else {?>
						<input type="submit" id="_modifstop" name="modifstop" style="margin-right:20px;" value="Modifier" title="Paramétrer les horaires d'extinction ainsi que les listes des machines à ne pas arrêter">
						<input type="submit" id="_supprstop" name="supprstop" value="Supprimer" style="margin-right:20px;" onClick="return verifsupprstop();" title="Supprimer la planification d'arrêt des stations">
						<input type="submit" id="_btactivestop" name="btactivestop" value="<?php echo $action_stop;?>" title="Activer ou désactiver la planification sans supprimer les programmations enregistrées">
						<?php }?>
						<br/><br/>
						</center>
					<!-- si le fichier config/ecoStations.txt n'existe pas -->
					<?php } else {?>
						<h2>Planification désactivée</h2>
						Aucune programmation d'arrêt des stations n'est planifiée<br/><br/>
						<!-- bouton mofifier horaire extinction -->
						<center>
						<?php if ($verroumodifstop == 1) {?>
						<input type="submit" id="_modifstop" name="modifstop" value="Modifier" disabled="disabled">
						<?php } else {?><input type="submit" id="_modifstop" name="modifstop" value="Modifier" title="Paramétrer les horaires d'extinction ainsi que les listes des machines à ne pas arrêter">
						<?php }?>
						<br/><br/>
						</center>
					<?php }?>
					
					
					
					<!-- programmation d'extinction -->					
					<!-- affichage uniquement si modification -->
					<?php if ($verroumodifstop==1) {?>
					<center>					
						<table class="tabeco" style="text-align:center;">
							<!-- case : horaire d'extinction -->
							<tr>
								<td style="width:50%;">Horaire 1</td>
								<td style="width:50%;">Horaire 2</td>
							</tr>
							<tr>
								<td><center><input type="text" style="width:80px;text-align:center;" id="_hor1" name="hor1" value="<?php echo $horaire1;?>" title="De la forme hh:mm et compris entre 00:00 et 23:59" onChange="valChange1=true;"></center></td>
								<td><center><input type="text" style="width:80px;text-align:center;" id="_hor2" name="hor2" value="<?php echo $horaire2;?>" title="De la forme hh:mm et compris entre 00:00 et 23:59" onChange="valChange1=true;"></center></td>
							</tr>
							<!-- case : liste des stations à ne pas éteindre -->
							<tr>
								<td style="padding-top:10px;">Liste des stations à ne pas arrêter</td>
								<td style="padding-top:10px;">Liste des stations à ne pas arrêter</td>
							</tr>
							<tr>
								<td><select id="_liste1" name="liste1[]" title="Utilisez les touches Maj ou Ctrl pour sélectionner plusieurs stations" size="10" style="width:300px" onChange="valChange1=true;" onClick="aideNoMac=false;" multiple><?php echo listeStations($ficMachines,litListe($ficEcoStations,'1'));?></select></td>
								<td><select id="_liste2" name="liste2[]" title="Utilisez les touches Maj ou Ctrl pour sélectionner plusieurs stations" size="10" style="width:300px" onChange="valChange1=true;" onClick="aideNoMac=false;" multiple><?php echo listeStations($ficMachines,litListe($ficEcoStations,'2'));?></select></td>
							</tr>
							<tr><td colspan="2"><span style="font-weight:bold;font-size:0.9em;font-style:italic;color:#678">Si une station de la liste est désactivée et marquée (adresse inconnue)<br/>on peut résoudre le problème à l'aide <a href="#" class="va_sur_aide" style="color:#567">des indications suivantes.</a></span></td></tr>
						</table>
										
						<!-- bouton enregistrer extinction -->
						<input type="submit" id="_valstop" name="valstop" value="Enregistrer" style="margin-right:20px;" onClick="document.getElementById('actionstop').value=this.id;">
						
						<!-- bouton annuler extinction -->
						<input type="submit" id="btnAnnulestop" name="Annulestop" value="Annuler" onClick="annuleoupas();document.getElementById('actionstop').value=this.id;">
						<input type="hidden" id="actionstop" value="">
						<br/><br/>
					</center>
					<?php }?>
					
				</div>
			</form>

			
				<!-- config démarrage                 -->
				<div id="tab-conf-start" class="contTabs">
					<form action="ecoStations.php" method="POST" id="formParam" onsubmit="return verif_ip()">
						<h2>Paramétrage</h2>
						<center>
							
							<!-- paramétrage enregistré -->
							<table class="tabeco">
							<tr>
								<td>Le serveur SCRIBE est dans la zone <b><?php echo $zone; ?></b></td>
							</tr>
								<?php if ($zone=='DMZ') {?><tr><td>Adresse IP du réseau pédagogique réservée pour envoyer les paquets WOL à travers AMON : <b><?php echo $ip; ?></b></td></tr><?php }?>
							</table>
							<!-- bouton mofifier parametrage -->
							<?php if ($verroumodif == 1 || $verroumodifparam == 1 || $verrouajout == 1) {?>
							<input type="submit" id="_modifparam" name="modifparam" value="Modifier" disabled="disabled">
							<?php } else {?><input type="submit" id="_modifparam" name="modifparam" value="Modifier" title="Modifer la zone du serveur Scribe">
							<?php }?>
							<br/><br/>
							
							<!-- modification du paramétrage -->
							<!-- affichage uniquement si modification du paramétrage -->
							<?php if ($verroumodifparam==1) {?>
							<table class="tabeco">
								<tr>
									<td>Zone du serveur SCRIBE <input type="radio" id="_pedago" name="btzone" <?php if ($zone=='pedagogique') {?>checked="checked"<?php }?> onClick="cache_ip()" value="pedagogique" onChange="valChange1=true;">Pédagogique
									<input type="radio" id="_dmz" name="btzone" <?php if ($zone=='DMZ') {?>checked="checked"<?php }?> onClick="affiche_ip()" value="DMZ" onChange="valChange1=true;">DMZ</td>
								</tr>
								<tr>
									<td id="_text_ip_peda" height="25" <?php if ($zone=='pedagogique') {?>style="color:grey"<?php }?>>Adresse IP du réseau pédagogique réservée pour envoyer les paquets WOL à travers AMON 
									<!-- case : IP pedago -->
									<input type="text" <?php if ($zone=='DMZ') {?>style="width:120px;text-align:center;"<?php }?> <?php if ($zone=='pedagogique') {?>style="display:none"<?php }?> id="_IP_peda" name="IP_peda" value="<?php echo $ip;?>" onChange="valChange=true;"></td>
								</tr>
							</table>
							
							<!-- bouton enregistrer parametrage -->
							<input type="submit" id="_valparam" name="valparam" value="Enregistrer" style="margin-right:20px;" onClick="document.getElementById('action').value=this.id;">
							
							<!-- bouton annuler parametrage -->
							<input type="submit" id="btnAnnuleparam" name="Annuleparam" value="Annuler" onClick="annuleoupas();document.getElementById('action').value=this.id;">
							<br/><br/>
							<input type="hidden" id="action" value="">
							<?php }?>
						</center>
					</form>
					
					<form action="ecoStations.php" method="POST" id="formStart" onsubmit="return verif_program()">
						
						<?php echo tabplanstart($ficEcoStationstart,$etat_plan); ?>
						
						<!-- programmation de démarrage -->					
						<!-- affichage uniquement si ajout ou modification -->
						<?php if ($verrouajout==1 || $verroumodif==1) {?>
						<center>					
							<table class="tabeco">
							<tr>
								<!-- case : horaire de démarrage -->
								<td style="width:20%;">
									<center>
										<table style="font-size:10pt">
											<tr><td style="text-align:center;">Horaire</td></tr>
											<tr><td><center><input type="text" style="width:80px;text-align:center;" id="hor_start" name="hor_start" value="<?php echo $horaireplan;?>" title="De la forme hh:mm et compris entre 00:00 et 23:59"></center></td></tr>
										</table>
									</center>
								<!-- cases à cocher : choix des jours de démarrage -->
								<td>
									<center>
										<table style="font-size:10pt">
											<tr><td style="text-align:center;">Lu</td>
											<td style="text-align:center;">Ma</td>
											<td style="text-align:center;">Me</td>
											<td style="text-align:center;">Je</td>
											<td style="text-align:center;">Ve</td>
											<td style="text-align:center;">Sa</td>
											<td style="text-align:center;">Di</td>
											</tr>
											<tr><td><input type="checkbox" id="checklu" name="days[]" value="Lu" <?php if (in_array("Lu", $jourplan)) {?>checked="checked"<?php }?>></td>
											<td><input type="checkbox" id="checkma" name="days[]" value="Ma" <?php if (in_array("Ma", $jourplan)) {?>checked="checked"<?php }?>></td>
											<td><input type="checkbox" id="checkme" name="days[]" value="Me" <?php if (in_array("Me", $jourplan)) {?>checked="checked"<?php }?>></td>
											<td><input type="checkbox" id="checkje" name="days[]" value="Je" <?php if (in_array("Je", $jourplan)) {?>checked="checked"<?php }?></td>
											<td><input type="checkbox" id="checkve" name="days[]" value="Ve" <?php if (in_array("Ve", $jourplan)) {?>checked="checked"<?php }?>></td>
											<td><input type="checkbox" id="checksa" name="days[]" value="Sa" <?php if (in_array("Sa", $jourplan)) {?>checked="checked"<?php }?>></td>
											<td><input type="checkbox" id="checkdi" name="days[]" value="Di" <?php if (in_array("Di", $jourplan)) {?>checked="checked"<?php }?>></td>
											</tr>
										</table>
									</center>
								</td>
								<!-- case : liste des stations à démarrer -->
								<td style="width:33%;">
									<table style="font-size:10pt">
										<tr><td style="text-align:center;">Liste des stations à démarrer</td></tr>
										<tr><td>
										<select id="_nomsStart" name="nomsStart[]" title="Utilisez les touches Maj ou Ctrl pour sélectionner plusieurs stations" size="10" style="width:200px" multiple onClick="aideNoMac=false;">
										<?php echo listeStations($ficMachines,$stationplan);?>
										</select>
										</td></tr>
									</table>
								</td>
							</tr>
							<tr><td colspan="3" style="text-align:center"><span style="font-weight:bold;font-size:0.9em;font-style:italic;color:#678">Si une station de la liste est désactivée et marquée comme <span style="color:#456">(adresse inconnue)</span><br/>on peut résoudre le problème à l'aide <a href="#" class="va_sur_aide" style="color:#567">des indications suivantes.</a></span></td></tr>
							</table>
							<!-- bouton enregistrer planification -->
							<input type="submit" id="_valstart" name="valstart" value="Enregistrer" style="margin-right:20px;" onClick="devercheck();document.getElementById('actionplan').value=this.id;">
							
							<!-- bouton annuler planification -->
							<input type="submit" id="btnAnnuleConfstart" name="AnnuleConfstart" value="Annuler" onClick="document.getElementById('actionplan').value=this.id;">
							<input type="hidden" id="actionplan" value="">
							<br/><br/>
						</center>
						<?php }?>
						
					</form>	
					
					<br/>
				<h2>Calendrier d'empêchement de l'allumage</h2>
			<center>
				<image style="cursor:pointer" onClick="window.location='./calend.php'" src="./images/calpetit.gif" title="Editer le calendrier" /><br/>
				</center>
				<br/>
				</div>
				
				
				
				<!-- page d'aide                 -->
				<div id="tab-aide" class="contTabs">
					<?php include("aide.php"); ?>
				</div>
				
			</div>
		</div>
		
	</div>
	<div id="credit" class="ui-corner-all fondRayeBleu" style="height:100px;line-height:13px">
		<div id="contCredit" style="position:absolute;bottom:10px;width:100%;padding:5px 0 0 0">
		<center><table cellpadding="0" cellspacing="0" style="margin:0 0 5px 0;padding:0;font-size:1em;"><tr><td><center>Développement : <a href="mailto:olivier.hacquard@ac-besancon.fr?subject=ecoStations">Olivier HACQUARD</a>, <a href="mailto:laurent.guinard@ac-reims.fr?subject=ecoStations">Laurent GUINARD</a>, <a href="mailto:jerome.labriet@ac-besancon.fr?subject=ecoStations">Jérôme LABRIET</a>.</center></td></tr><tr><td><center>Contributions : <a href="mailto:laurent.etignard@ac-besancon.fr?subject=ecoStations">Laurent ETIGNARD</a>, <a href="mailto:frederic.lamy@ac-besancon.fr?subject=ecoStations">Frédéric LAMY</a>, <a href="mailto:arnaud.grossir@ac-besancon.fr?subject=ecoStations">Arnaud GROSSIR</a>.</center></td></tr><tr><td><center>Documentations : <a href="mailto:pierre.mariot@ac-besancon.fr?subject=ecoStations">Pierre MARIOT</a>, <a href="mailto:jean-marc.bruot@ac-besancon.fr?subject=ecoStations">Jean-Marc BRUOT</a>.</center></td></tr><tr><td><center>dans le cadre du projet&nbsp;&nbsp;<a href="http://eole.orion.education.fr/" target="_blank"><image src="./images/pt_logo_eole.png" title="Projet EOLE - Ensemble Ouvert Libre Evolutif" border="0"/></a></center></td></tr></table></center>
		</div>
		<div id="leCredit" style="margin:0;position:absolute;bottom:0px;width:100%"><i><?php if ($_version_!="") echo "version $_version_ |"; ?></i> <span id="clickCredit">Crédit</span></div>
	</div>

</div>

<script language="JavaScript">
	//vider les checkbox
	function videcheck() {
		for (j=1;j<=<?php echo $nbplan; ?>;j++){
			document.getElementById('check'+j).checked=false;
		}
	}
	
	//déverrouiller les checkbox
	function devercheck(){
		for (j=1;j<=<?php echo $nbplan; ?>;j++){
			document.getElementById('check'+j).disabled=false;
		}
	}
</script>

<?php
if ($ligneCron!="") echo "Ecriture de ligne dans le Cron : <b>".$ligneCron."</b>".BRCR;

 
finHTML(); 

?>