<?php
/*---------------------------------------------------------------
		f_scribe.inc.php
-----------------------------------------------------------------
	Librairie de fonctions pour les services installés
   sur les serveurs Eole Scribe
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/

//*------------------=O===================O----------------------
$_charset_="UTF-8";


/*------------------------------------------
 Fonction : headerPage
-------------------------------------
 Envoie les infos header pour la page
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function headerPage() {
	global $_charset_;
	
	$now = gmdate('D, d M Y H:i:s') . ' GMT';
	//Entête page
	header('Expires: ' . $now);
	header('Last-Modified: ' . $now);
	header('Cache-Control: no-store, no-cache, must-revalidate'); // HTTP/1.1
	header('Cache-Control: pre-check=0, post-check=0, max-age=0'); // HTTP/1.1
	header('Pragma: no-cache'); // HTTP/1.0
	header("Content-Type: text/html; charset=$_charset_");
} //fin de fonction

/*------------------------------------------
 Fonction : enteteHTML
-------------------------------------
 Envoie les infos d'entête de la page HTML
-------------------------------------
 - Entrée : le titre de la page
 						si souhaité, une liste (un tableau) de fichier(s) a rajouter dans l'entête. Traîter différement suivant l'extension du fichier (ico,css,js)
 - Sortie :
---------------------------------------------*/
function enteteHTML($titrePage="titre de la page", $lignesHeader=false) {
	global $_charset_;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
	<title><?php echo $titrePage; ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo 	$_charset_ ;?>">
<?php
	if (is_array($lignesHeader)) foreach ($lignesHeader as $_ligneH) {
		switch(strtolower(substr($_ligneH,-3))) {
			case "css":
				$_laLigne='<LINK rel="stylesheet" type="text/css" href="'.$_ligneH.'" />';
				break;
			case ".js":
				$_laLigne='<script type="text/javascript" src="'.$_ligneH.'"></script>';
				break;
			case "ico":
				$_laLigne='<link href="'.$_ligneH.'" rel="shortcut icon" type="image/x-icon" />';
				break;
			case "png":
				$_laLigne='<link href="'.$_ligneH.'" rel="icon" type="image/png" />';
				break;
		}
		echo $_laLigne.CR;
	}
?>	
</head>
<body>

<?php
} //fin de fonction

/*------------------------------------------
 Fonction : finHTML
-------------------------------------
 Envoie le code de fin de code HTML
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function finHTML() {
?>
</body>
</html>
<?php
} //fin de fonction 


/*------------------------------------------
 Fonction : alertJS
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function alertJS($texte) {
	echo '<script language="JavaScript">alert(\''.addslashes($texte).'\')</script>';
}

/*------------------------------------------
 Fonction : affVersion
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function affVersion() {
	global $_nomAppli, $_version, $_dateVersion;
	return "<b>$_nomAppli</b> | <i>version <b>$_version</b> du $_dateVersion</i>";
}

/*------------------------------------------
 Fonction : afficheVersionAppli
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function afficheVersionAppli() {
/*return "<table width=\"452\" align=\"center\" style=\"\">
	<tr valign=\"top\">
		<td style=\"\">".affVersion()."
		</td>
	</tr>
</table>\n";*//*background-color:#565859*/
return '<div style="width:700px;margin:0 auto;font-size:8pt;color:#002040;padding:0 8px 0 0;text-align:right">'.affVersion().'</div>';
}


/*------------------------------------------
 Fonction : fenetreAvert
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function fenetreAvert($titre, $texte, $temps=0) {
	
	//-- partie JavaScript JQuery -- 
return '
<script language="JavaScript">
	function fermeAvert() {
		//$( "#fenetreAvert" ).dialog.("close");
		alert("coucou");
	}
	$(function() {
    $( "#fenetreAvert" ).dialog({
      autoOpen: true,
      dialogClass: "txt75" ,
      height: 150,
      width: 350,
      modal: true,
      resizable:false,
      close: function() {
      },
      open: function() {
      	//window.setTimeout(fermeAvert, 2000);
      },
       hide: {effect: "fadeOut", duration: 0}
		}
		'.(($temps>0)?', 
		setTimeout(function(){
			$("#fenetreAvert").dialog("close");
			},'.$temps.')
		':'').');
	});
</script>

	<!-- -- partie HTML utilisée par le code JQuery -- -->

<div id="fenetreAvert" title="'.$titre.'">
  '.$texte.'
</div>
';
}

/*------------------------------------------
 Fonction : divAttenteChargement
-------------------------------------
 affiche une div demandant de patienter
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function divAttenteChargement($txt='Page en cours de chargement.<br/><br/>Merci de patienter...') {
	return '<div id="repereChargement"><div id="dChargement"><div id="contChargement">'.$txt.'</div></div></div>';
} //fin de fonction

/*------------------------------------------
 Fonction : cacheDivChargement
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function cacheDivChargement() {
	return '<script language="JavaScript">
	document.getElementById("dChargement").style.display="none";
</script>';
}

/*--------------------
 fonction ligneSeparatrice 
----------------------*/
function ligneSeparatrice($largeur=500, $hauteur=2, $couleur="#400040") {
	$demiLargeur=intval($largeur/2);
	return '<div style="position:relative;left:50%;"><div style="position:relative;background-color:'.$couleur.';width:'.$largeur.'px;left:-'.$demiLargeur.'px;height:'.$hauteur.'px;font-size:1px;"></div></div>';
}


/*------------------------------------------
 Fonction : codeJQsaisieMdP
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function codeJQsaisieMdP($url, $urlSiNonDefini) {
	global $_nomAppli;
	
	$visible=false; //fenêtre non montrée par défaut
	$msgSupp="";
	$erreurMdp=false;
	$mdpDejaOk=false;
	$md5Pass=litParam("motDePasse"); //on va chercher le md5 du mot de passe dans la base
	if (isset($_GET['pbPass'])) {$visible=true;$msgSupp="Mot de passe incorrect";$erreurMdp=true;}
	if ($md5Pass===false) {
		$msgSupp="Attention : mot de passe non défini !";
		$url=$urlSiNonDefini;
		
	}
	else {
		if (isset($_SESSION[$_nomAppli]['passParam'])) 
			if ($md5Pass==$_SESSION[$_nomAppli]['passParam']) 
				$mdpDejaOk=true;
	}


	//-- partie JavaScript JQuery -- 
return '
<script language="JavaScript">
	var voirQuneFois='.(($erreurMdp)?"true":"false").';
	$(function() {
    $( "#dialog-form" ).dialog({
      autoOpen: '.(($visible)?"true":"false").',
      dialogClass: "txt75" ,
      height: 170,
      width: 350,
      modal: true,
      resizable:false,
      buttons: {
        "Valider": function() {
          document.getElementById("formPass").submit();
 					$( this ).dialog( "close" );
        },
        "Annuler": function() {
          $( this ).dialog( "close" );
          if (voirQuneFois) {
          	$( "#txtSuppMdp" ).html("");
          	voirQuneFois=false;
          }
        }
      },
      close: function() {
      },
      open: function() {
      	'.(($mdpDejaOk)?'window.location="'.$url.'";':'').' //on va directement à la page si le mot de passe est déja ok
      }
    });
	});
</script>

	<!-- -- partie HTML utilisée par le code JQuery -- -->

<div id="dialog-form" title="Accès au paramètrage">
  <form id="formPass" method="POST" action="'.$url.'">
  <fieldset>
    <label for="password">Mot de passe</label>
    <input type="password" name="password" id="password" value="" class="text ui-widget-content ui-corner-all">
  </fieldset>
   '.(($msgSupp!="")?'<div id="txtSuppMdp" style="text-align:center;font-weight:bold;color:red;font-size:1.2em">'.$msgSupp.'</div>':'').' 
  </form>
</div>
';
}

/*------------------------------------------
 Fonction : saisieNouveauMotdePasse
-------------------------------------
 affiche les 2 cases permettant de saisir le mot de passe
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function saisieNouveauMotdePasse($url, $txt, $couleur, $motDePasseIndefini) {
?>
	<script langage="JavaScript">
		var valideVide=false;
	
		function verifMp(pass1, pass2) {
			if (valideVide) return true;
			if (pass1!=pass2) {
				alert('Les mots de passe saisis sont différents.');
				return false;
			}
			if (pass1.length<6) {
				alert('Le mot de passe saisi doit avoir au moins 6 caractères.');
				return false;
			}
			return true;
		}
	</script>
  <form name="formPass" method="post" action="<? echo $url; ?>" onSubmit="return verifMp(document.formPass.mpasse1.value, document.formPass.mpasse2.value);">
  <table width="400" border="0" cellpadding="3" align="center" style="border:1px SOLID #000000; background-color:<? echo $couleur; ?>">
  <tr><td align="center" style="padding:20px;">
  <p>Pour changer le mot de passe<? echo " $txt"; ?>,<br />
  écrire 2 fois le mot de passe puis valider<br /><br/>
 	<?php
 	 if ($motDePasseIndefini) echo '<div style="color:red;font-size:1.2em;margin:0 0 5px 0">Mot de passe non défini...</div>'; ?>
    <input type="password" name="mpasse1" size="12" />
    <input type="password" name="mpasse2" size="12" />
    <input type="submit" name="sauvePass" value="Valider" onMouseDown="return verifMp(document.formPass.mpasse1.value, document.formPass.mpasse2.value);"/><br /><br />
    <? 
    if (!$motDePasseIndefini) echo "<input type=\"submit\" name=\"videPass\" value=\"Supprimer le mot de passe\" onClick=\"valideVide=true;if(confirm('Voulez mettre un mot de passe vide pour accéder à cette page ?')) return true;else {valideVide=false;return false}\" />"; 
    ?> 
  </td></tr></table>
  </form>

<?php
}

/*------------------------------------------
 Fonction : verifOuEnregistreMotdePasse
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function verifOuEnregistreMotdePasse($pageEnvoyantVersCettePage, $pageBase) {
	global $_nomAppli, $tabProfils, $_isPersonnel;
	
	//il faudra vérifier que la page appelante est bien autorisée à le faire...
	$retourPageBase=false;
	$fenAlert="";
	$pageEnCours=pageEnCours();
	$pageOrigine=pageDorigine();
	//print_r($_SERVER);
	//echo "cettePage:$pageEnCours origine:$pageOrigine";print_r($pageEnCours);exit();
	//echo $pageOrigine.BR;
	
	$md5MotDePasseGenerique="d5fdd93d7c709688d640ff851756c188";
	//on vide le mot de passe ?
	if (isset($_POST['videPass'])) { //on demande de vider le mot de passe
		if ($pageOrigine==$pageEnCours) { //on vient de la page courante
			supprimeParam("motDePasse");
			unset($_SESSION[$_nomAppli]['passParam']);
			$retour=fenetreAvert("Gestion du mot de passe", "Mot de passe vidé",1000);
		} else { //on vient d'ailleurs... anormal
			$retourPageBase=true;
		}
	} else {
	//on enregistre le mot de passe ?
		if (isset($_POST['mpasse1'])) { //on reçoit le nouveau mot de passe
			if ($pageOrigine==$pageEnCours) { //on vient de la page courante
				ecritParam("motDePasse", md5($_POST['mpasse1']));
				$_SESSION[$_nomAppli]['passParam']=md5($_POST['mpasse1']);
				$retour=fenetreAvert("Gestion du mot de passe", "Mot de passe enregistré",1000);
			} else { //on vient d'ailleurs... anormal
				$retourPageBase=true;
			}
		}
	}
	//echo '-testEgalitée:';echo $pageOrigine."$page1;$pageOrigine;$pageEnCours;".BR;
	
	$vientDunePageEnvoyanteAutorisee=false;
	if (is_array($pageEnvoyantVersCettePage)) { //plusieurs pages passées dans un tableau
		foreach($pageEnvoyantVersCettePage as $_page) {
			if ($pageOrigine==$_page) $vientDunePageEnvoyanteAutorisee=true;
		}
	} else { //une seule page passée en argument
		$vientDunePageEnvoyanteAutorisee=($pageOrigine==$pageEnvoyantVersCettePage);
	}
	$vientDunePageEnvoyanteAutorisee|=($pageOrigine==$pageEnCours);
	
	//echo '-vientDunePageEnvoyanteAutorisee:';print_r($vientDunePageEnvoyanteAutorisee);echo BR;
	//echo '-testEgalitée:';echo $pageOrigine."$page1;$pageOrigine;$pageEnCours;".BR;
	
	if ($vientDunePageEnvoyanteAutorisee || $pageOrigine==$pageEnCours) { //on vient de la page de base ou de param
		//prise en compte du mot de passe d'arrivée dans la page, et retour si pas bon
		$md5Pass=litParam("motDePasse");
		if ($md5Pass!==false) { //mot de passe défini
			if (isset($_SESSION[$_nomAppli]['passParam'])) {//mot de passe déja lu
				if ($_SESSION[$_nomAppli]['passParam']!=$md5Pass && $_SESSION[$_nomAppli]['passParam']!=$md5MotDePasseGenerique) { //si le mot de passe ne correspond pas
					unset($_SESSION[$_nomAppli]['passParam']);
					$retourPageBase=true;
				}
			} else { //premier accès par le mot de passe
				if (md5($_POST['password'])!=$md5Pass && md5($_POST['password'])!=$md5MotDePasseGenerique) { //mot de passe ne colle pas
					$retourPageBase=true;
				} else { //mot de passe correct
					$_SESSION[$_nomAppli]['passParam']=$md5Pass;
				}
			}
		} else { //mot de passe non défini
			if (!$_isPersonnel) $retourPageBase=true;
		}
	} else { //on ne vient pas de la bonne page
		$retourPageBase=true;
	}
	
	if ($retourPageBase) changePage($pageBase.'?pbPass');
	return $retour;
}



/*------------------------------------------
 Fonction : codeJQIconeParam
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function codeJQIconeParam($url, $typeC=1, $top=-1, $right=-1) {
	global $_nomAppli;
	
	$leStyle='';
	if (($top!=-1) && ($right!=-1)) {
		$leStyle=' style="margin:'.$top.'px '.$right.'px 0 0"';
	}
	
	switch ($typeC) {
		case 1:
			$class1='fdParam1';
			$class2='fdParam2';
			break;
		case 2:
			$class1='fdParam2-1';
			$class2='fdParam1';
			break;
	}
	$mdpDejaOk="false";
	$md5Pass=litParam("motDePasse");
	if (isset($_SESSION[$_nomAppli]['passParam'])) 
		if ($md5Pass==$_SESSION[$_nomAppli]['passParam']) 
			$mdpDejaOk="true";
return '
<script language="JavaScript">
	$(function() {
		$( "#icoParam" )
	      .click(function() {
	      	if ('.$mdpDejaOk.') window.location="'.$url.'";
	        else $( "#dialog-form" ).dialog( "open" );
	      }).hover(function() {
	    	$( this ).removeClass( "'.$class1.'" );
	    	$( this ).addClass( "'.$class2.'" );
			}, function() {
	    	$( this ).removeClass( "'.$class2.'" );
	    	$( this ).addClass( "'.$class1.'" );
			});

	});
</script>
<span id="icoParam" class="'.$class1.'"'.$leStyle.' title="Paramètrer le logiciel"></span>
';
}

/*------------------------------------------
 Fonction : codeJQIconeParam
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function codeJQIconeParam2($url) {
	global $_nomAppli;
	
	$mdpDejaOk="false";
	$md5Pass=litParam("motDePasse");
	if (isset($_SESSION[$_nomAppli]['passParam'])) 
		if ($md5Pass==$_SESSION[$_nomAppli]['passParam']) 
			$mdpDejaOk="true";
return '
<script language="JavaScript">
	$(function() {
		$( "#icoParam2" )
	      .click(function() {
	      	if ('.$mdpDejaOk.') window.location="'.$url.'";
	        else $( "#dialog-form" ).dialog( "open" );
	      }).hover(function() {
	    	$( this ).removeClass( "fdParam2-1" );
	    	$( this ).addClass( "fdParam2-2" );
			}, function() {
	    	$( this ).removeClass( "fdParam2-2" );
	    	$( this ).addClass( "fdParam2-1" );
			});

	});
</script>
<span id="icoParam2" class="fdParam2-1" title="Paramètrer le logiciel"></span>
';
}

/*--------------------
 fonction db2html 
 -----------------------
 convertit une chaine venant de la base en htmlentities (&#39; au lieu de ' ou " par exemple)
 Nécessaire pour affiche des " ou des <> dans un input text
----------------------*/
function db2html($elem) {
	return htmlentities($elem, ENT_QUOTES);
}

/*------------------------------------------
 Fonction : cadreTitrePage
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function cadreTitrePage($titrePage) {
	return  '<div id="titrePage" class="ui-corner-all fondRayeBleu">'.$titrePage.'</div>';
}

/*------------------------------------------
 Fonction : icoRetour
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function icoRetour($urlRetour, $txtRetour='Retour à la page précédente', $codeJSavantClick='') {
	return '<script language="JavaScript">
		$(function() {
	    $( "#icoRetour" ).hover(function() {
	    	$( this ).removeClass( "fdRetour1" );
	    	$( this ).addClass( "fdRetour2" );
			}, function() {
	    	$( this ).removeClass( "fdRetour2" );
	    	$( this ).addClass( "fdRetour1" );
			}).click(function() {
				'.$codeJSavantClick.';
				window.location="'.$urlRetour.'";
			});
		});	
</script>
<div id="icoRetour" title="'.$txtRetour.'" class="fdRetour1"></div>';
}
 
/*------------------------------------------
 Fonction : decortiqueURL
-------------------------------------
 Extrait la page dans une URL
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function decortiqueURL($adresse) {
	//echo "-"; echo $adresse;
	$posDerSlash=strrpos($adresse, '/');
	//echo "-".$posDerSlash;
	$laPage=substr($adresse, $posDerSlash+1); //garde la page sans l'adresse complète du site
	$leChemin=substr($adresse, 0,$posDerSlash); //garde le chemin sans la page
	//echo "-".$laPage; 
	$posPointInter=strpos($laPage, '?');
	//echo "-".$posPointInter; 
	if ($posPointInter!==false) $laPage=substr($laPage, 0, $posPointInter); //supprime ce qu'il y aurait après un ? (variables get)
	//echo "-"; echo $laPage;
	$posDiese=strpos($laPage, '#');
	//echo "-".$posPointInter; 
	if ($posDiese!==false) $laPage=substr($laPage, 0, $posDiese); //supprime ce qu'il y aurait après un #
	//echo "-page:$laPage chemin:$leChemin".BR;
	return (array($laPage,$leChemin));
}

/*------------------------------------------
 Fonction : pageDorigine
-------------------------------------
 Retourne la page appelante
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function pageDorigine() {
	list($laPage,)=decortiqueURL($_SERVER[HTTP_REFERER]);
	return $laPage;
}

/*------------------------------------------
 Fonction : pageDorigine
-------------------------------------
 Retourne la page appelante
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function pageEnCours() {
	list($laPage,)=decortiqueURL($_SERVER[PHP_SELF]);
	return $laPage;
}

/*------------------------------------------
 Fonction : changePage
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function changePage($url) {
	if (!headers_sent()) header('Location: '.$url);
	else echo '<script language="JavaScript">window.location="'.$url.'"</script>';
}


/*------------------------------------------
 Fonction : convertir_fichier_utf8
-------------------------------------
 Convertir un fichier en utf8
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function convertir_fichier_utf8($fichierAConvertir, $bavard=false){
    $file_content = file_get_contents($fichierAConvertir);
    if(preg_match('/./u', $file_content)){
      if ($bavard) echo 'Fichier déjà en UTF-8...';
      return true;
    } else {
        if ($bavard) echo('Fichier non en UTF-8<br />');
        
        if (file_exists($fichierAConvertir)) {
        		if ((copy($fichierAConvertir,$fichierAConvertir.'.old'))===false) if ($bavard) echo "Impossible de sauvegarder le fichier...";
            $inF = fopen($fichierAConvertir,"r");
            if ($inf===false) if ($bavard) echo "Fichier $fichierAConvertir impossible à ouvrir en lecture...";
            while (!feof($inF)) {
                $contenu_fichier_non_utf8.= fgets($inF, 4096);
            }
        $contenu_fichier_modifier_en_utf8 = utf8_encode ($contenu_fichier_non_utf8);
        }
        $fichier = fopen($fichierAConvertir,'w+');
        if ($fichier===false) if ($bavard) echo "Fichier $fichierAConvertir impossible à ouvrir en écriture...";
        fputs($fichier,$contenu_fichier_modifier_en_utf8);
        fclose($fichier);
        if ($bavard) echo 'Fichier Converti en UTF-8 !';
        return true;
    }
}

    /** 
    * Encodes an ISO-8859-1 mixed variable to UTF-8 (PHP 4, PHP 5 compat)
    * @param    mixed    $input An array, associative or simple
    * @param    boolean  $encode_keys optional
    * @return    mixed     ( utf-8 encoded $input)
    */
function utf8_encode_mix($input, $encode_keys=false)
    {
        if(is_array($input))
        {
            $result = array();
            foreach($input as $k => $v)
            {                
                $key = ($encode_keys)? utf8_encode($k) : $k;
                $result[$key] = utf8_encode_mix( $v, $encode_keys);
            }
        }
        else
        {
            $result = utf8_encode($input);
        }

        return $result;
    }
/*--------------------
 fonction mkRequeteIN 
 ---------------------------
 fabrique une requête du type nomval IN ('val1','val2') à partir de nomval et d'un tableau contenant les valeurs
----------------------*/
function mkRequeteIN($nomVal, $tabVal) {
	$prempass=true;
	$req="$nomVal IN (";
	foreach ($tabVal as $_val) {
		if (!$prempass) {
			$req.=",";
		}
		$req.="'$_val'";
		$prempass=false;
	}
	$req.=")";
	
	return $req;
}

/*--------------------
 fonction mkRequeteOR 
 ---------------------------
 fabrique une requête du type (nomval='val1' OR nomval='val2') à partir de nomval et d'un tableau contenant les valeurs
----------------------*/
function mkRequeteOR($nomVal, $tabVal) {
	$prempass=true;
	$req="(";
	foreach ($tabVal as $_val) {
		if (!$prempass) {
			$req.=" OR ";
		}
		$req.="$nomVal='$_val'";
		$prempass=false;
	}
	$req.=")";
	
	return $req;
}

/*------------------------------------------
 Fonction : makeSelect
-------------------------------------
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function makeSelect($nom, $tabOption, $valSel="", $classNonSel="", $classSel="", $styleSel="", $codeJS="") {
	if ($styleSel=="") $styleSel='font-size:10px;background-color:#C0D0E0';
	$sel="<select style=\"$styleSel\" name=\"$nom\" $codeJS>\n";
	foreach ($tabOption as $_value=>$_option) {
		$_isSel="";
		$laClasse="";
		if ($classNonSel!="") $laClasse="class=\"$classNonSel\"";
		if ($_value==$valSel) {
			$_isSel="SELECTED";
			if ($classSel!="") $laClasse="class=\"$classSel\"";
		}
		$sel.="	<option $laClasse value=\"$_value\" $_isSel>$_option</option>\n";
	}
	$sel.="</select>\n";
	return $sel;
} //fin de fonction

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function prepareDivAide($num, $contenu) {
	static $inclureJQ=true;
	if ($inclureJQ) { //à n'inclure qu'une seule fois...
?>
<script>
		var divAide=new Array();
		$(function() {
    $( ".iconeAide" ).tooltip({ 
    	tooltipClass: "bulleAide",
    	show: { effect: "blind", duration: 400 },
    	items: "[aide]",
      content: function() {
        var element = $( this );
        if ( element.is( "[aide]" ) ) {
        	numAide=element.attr("aide");
        	//alert(numAide);
          return divAide[numAide];
        }
      }
    	 						});
  });
  </script>
<?php
	}
	$inclureJQ=false; //comme ça on ne l'incluera plus...
	echo '<script language="JavaScript">
		divAide['.$num.']=\'<div class="icoEnteteHelp"></div><div class="contDivAide">'.addcslashes($contenu, "'").'</div>\';
	</script>';
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function iconeAide($num) {
	return '<image src="./images/helpPt1.gif" class="iconeAide" aide="'.$num.'" />';
}

/*--- Fonction ----------------------------------------------------------
  scriptJS
 ----------------------
    génère une ligne de code pour insérer du code JavaSCript dans la page
 ----------------------
  Entrée :
		$source : code JSà incorporer
  Sortie :
	 	la chaine contenant le code à insérer
 ----------------------
 Remarques :

-------------------------------*/
function scriptJS($source) {
	
	$chaine="<script language=\"JavaScript\">$source</script>";
	return $chaine;
}

/*--------------------
 fonction encodeURL_OH
---------------------*/
function encodeURL_OH($str) {
	$str=str_replace("&", "_~_", $str);
	$str=str_replace("?", "_~~_", $str);
	return $str;
}

/*--------------------
 fonction decodeURL_OH
---------------------*/
function decodeURL_OH($str) {
	$str=str_replace("_~_", "&", $str);
	$str=str_replace("_~~_", "?", $str);
	return $str;
}

/*------------------------------------------
 Fonction : debugSessionCommentHTML
-------------------------------------
 ajoute le contenu de $_SESSION en commentaire HTML dans la page
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function debugSessionCommentHTML() {
	echo "<!--".CR;
	print_r($_SESSION);
	echo "-->".CR;
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 
-------------------------------------
 - Entrée : 
 - Sortie :
---------------------------------------------*/
function formateDateNaissance($laDate) {
	return substr($laDate,6,2).'/'.substr($laDate,4,2).'/'.substr($laDate,0,4);
} //fin de fonction

/*------------------------------------------
 Fonction : cadreLoginDeconnexion
-------------------------------------
  
-------------------------------------
 - Entrée :
 - Sortie :
---------------------------------------------*/
function cadreLoginDeconnexion($uid, $top, $right) {
	if ($uid=='admin') $nomUser='Admin';
	else $nomUser=$_SESSION['_user_']['prenom']." ".$_SESSION['_user_']['nom'];
	return '
	<script language="JavaScript">$(function() {
		$("#iconeDeconnexion").mouseenter(function() {
			$(this).toggleClass("iconeDecnx1");
			$(this).toggleClass("iconeDecnx2");
		});
		$("#iconeDeconnexion").mouseleave(function() {
			$(this).toggleClass("iconeDecnx1");
			$(this).toggleClass("iconeDecnx2");
		});
	});</script>	
	<div id="cadreLogin" style="top:'.$top.'px;right:'.$right.'px">&nbsp;&nbsp;<i>'.$nomUser.'</i>&nbsp;&nbsp;<span id="sepCadreLogin">|</span> <div id="iconeDeconnexion" class="iconeDecnx1" title="Se déconnecter" onClick="window.location=\'./index.php?logout\'"></div></div>';
} // fin de fonction cadreLoginDeconnexion


//----------------- partie de programme toujours chargée ------------------------------
define('CR', "\n");
define('BR', "<br/>");
define('CRLF', "\r\n");
define('BRCR', "<br/>\n");
define('NBSP', "&nbsp;");
define('NBSP2', "&nbsp;&nbsp;");
define('NBSP3', "&nbsp;&nbsp;&nbsp;");
define('NBSP4', "&nbsp;&nbsp;&nbsp;&nbsp;");
define('NBSP5', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");

include('./inc/c_tabHTML.inc.php');

//charge le fichier de définition du service
if (file_exists('./_infoAppli.inc.php')) require ('./_infoAppli.inc.php'); 
if (file_exists('./config/config.inc.php')) require_once ('./config/config.inc.php'); 
$_version_="";
if (file_exists('./_version.inc.php')) require ('./_version.inc.php'); 

$tabCiv=array(
	'.'=>"M.",
	'1'=>"M.",
	'2'=>"Mme",
	'3'=>"Mlle",
	'L'=>"Mlle",
	'M'=>"Mme"	
);

$tabProfils=array(
		"administrateur"=>"administrateur",
		"administratif"=>"administratif",
		"professeur"=>"professeur",
		"eleve"=>"élève",
		"responsable"=>"responsable",
		"autre"=>"autre"
);

$_isAdmin=($_SESSION['_user_']['profil']=="administrateur");
$_isProf=($_SESSION['_user_']['profil']=="professeur");
$_isAdministratif=($_SESSION['_user_']['profil']=="administratif");
$_isEleve=($_SESSION['_user_']['profil']=="eleve");
$_isResponsable=($_SESSION['_user_']['profil']=="responsable");
$_isAutre=($_SESSION['_user_']['profil']=="autre");
$_isPersonnel=$_isAdmin || $_isProf || $_isAdministratif;
?>