<?php
/*------------------------------------------
 Classe : tableau_HTML_OLD
-------------------------------------
ancienne implmentation du tableau HTML
-------------------------------------
 - Entre :
 - Sortie :
---------------------------------------------*/

define ('CNT',0); //index pour le contenu de la cellule du tableau
define ('FMT',1); //index pour le format de la cellule du tableau

class tableau_HTML_OLD {
	var $nbLig,$nbCol;
	//var $header,$nbLigH; //indique s'il y a ou non une ligne header, ainsi que le nombre de lignes
	//var $contTabH;
	var $contTab,$tabFmtLig; //tableau avec le contenu, le format des lignes
	var $style,$fmtTab;
	
	/*-----------------------------
	// constructeur - initialise le tableau 
	------------------------------*/
	function tableau_HTML_OLD($nbCol=1,$style=0) { //,$header=false,$nbLigHeader=0) {
		$this->nbCol=$nbCol;
		$this->nbLig=0;
		$this->style=$style;
		$this->fmtTab=array();
		//$this->header=$header;
		//$this->nbLigH=$nbLigHeader;
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function ajoute1Ligne() {
		$tabLigne=func_get_args();
		//si le premier paramtre est un  tableau on le prend comme la liste des valeurs de la ligne
		if (isset($tabLigne[0])) if (is_array($tabLigne[0])) $tabLigne=$tabLigne[0];
		for ($idxC=0;$idxC<($this->nbCol);$idxC++) {
			$_cont=(isset($tabLigne[$idxC]))?$tabLigne[$idxC]:'';
			$this->contTab[$this->nbLig][$idxC][CNT]=$_cont;
		}
		$this->nbLig++;
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function ajouteLignes($tabL) { 
		if (!is_array($tabL)) return false;
		if (count($tabL)<1) return false;
		foreach ($tabL as $_ligne) {
			$this->ajoute1Ligne($_ligne);
		}
	}
	

	/*-----------------------------
	// fabrique une chaine d'attribut HTML  partir d'un tableau de valeur 
	------------------------------*/
	function chaineAttributs($tabAttr) {
		if (!is_array($tabAttr)) return false;
		if (count($tabAttr)==0) return false;
		$nbAttr=count($tabAttr);
		$chaineFmt="";
		foreach($tabAttr as $attr=>$val) { //chaque couple d'attribut=valeur
			if ($chaineFmt!="") $chaineFmt.=' ';
			$chaineFmt.=$attr.'="'.$val.'"';
		}
		return $chaineFmt;
	}
	
	/*-----------------------------
	// formate le tableau 
	------------------------------*/
	function formatTableau() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		for($idx=0; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->fmtTab[$format[$idx]]);
			else $this->fmtTab[$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// formate la ligne 
	------------------------------*/
	function formatLigne() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par dfaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numro de ligne
		}
		$chaineFmt="";
		for($idx=$premArg; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->tabFmtLig[$laLigne][$format[$idx]]);
			else $this->tabFmtLig[$laLigne][$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// formate la ligne cellule par cellule avec le mme format
	------------------------------*/
	function formatLigneParCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par dfaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numro de ligne
		}
		for ($idxC=0;$idxC<($this->nbCol);$idxC++) {
			for($idx=$premArg; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
				if ($format[$idx+1]===null) unset($this->contTab[$laLigne][$idxC][FMT][$format[$idx]]);
				else $this->contTab[$laLigne][$idxC][FMT][$format[$idx]]=$format[$idx+1];
			}
		}
	}
	
	/*-----------------------------
	// formate la ligne cellule par cellule
	------------------------------*/
	function formatLigneParMultiCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		$premArg=0;
		$laLigne=$this->nbLig; //ligne en cours par dfaut
		if (is_numeric($format[0])) {
			$premArg=1;
			$laLigne=$format[0]-1; //on prend le premier argument comme numro de ligne
		}
		$col=-1;
		$formatEnTableau=false;
		if (is_array($format[$premArg])) {
			$tCont=each($format[$premArg]);
			reset($format[$premArg]);
			if (is_array($format[$premArg][$tCont['key']])) { //$tCont['value'])) { //les tableaux d'attibuts/valeurs sont eux mme placs dans un tableau pour toutes les cellules de la ligne
				$nbArgs=count($format[$premArg]); //$tCont['key']]);
				$formatEnTableau=true;
				$format=$format[$premArg]; //$tCont['key']];
				$premArg=0;
			}
		} 
		
		for($idx=$premArg;$idx<$nbArgs; $idx++) { //chaque entre contient un tableau o se succdent les couples d'attribut=valeur
			$col++;
			if (is_array($format[$idx])) {
				$nbOptFormat=count($format[$idx]);
				for ($idxF=0;($idxF<$nbOptFormat && ($nbOptFormat-$idxF)>1);$idxF+=2) {
					if ($format[$idx][$idxF+1]===null) unset($this->contTab[$laLigne][$col][FMT][$format[$idx][$idxF]]);
					else $this->contTab[$laLigne][$col][FMT][$format[$idx][$idxF]]=$format[$idx][$idxF+1];
				}
			} else continue; 
		}
	}
	
	
	/*-----------------------------
	// formate la colonne cellule par cellule
	------------------------------*/
	function formatColonneParCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		if (is_numeric($format[0])) {
			$laColonne=$format[0]-1; //on prend le premier argument comme numro de colonne
		} else return false; //on doit forcment fournir le n de colonne en premier pour affecter le format
		$chaineFmt="";
		for ($idxL=0;$idxL<($this->nbLig);$idxL++) {
			for($idx=1; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
				if ($format[$idx+1]===null) unset($this->contTab[$idxL][$laColonne][FMT][$format[$idx]]);
				else $this->contTab[$idxL][$laColonne][FMT][$format[$idx]]=$format[$idx+1];
			}
		}
	}
	
	/*-----------------------------
	// formate la cellule souhaite
	------------------------------*/
	function formatCellule() {
		$format=func_get_args();
		$nbArgs=func_num_args();
		if (is_numeric($format[0]) && is_numeric($format[1])) { //ligne et colonne passes en 1er et 2me argument
			$laLigne=$format[0]-1; //on prend le premier argument comme numro de ligne
			$laColonne=$format[1]-1; //on prend le second argument comme numro de colonne
		} else return false; //on doit forcment fournir le n de colonne en premier pour affecter le format
		$chaineFmt="";
		for($idx=2; ($idx<$nbArgs && ($nbArgs-$idx)>1); $idx+=2) { //chaque couple d'attribut=valeur
			if ($format[$idx+1]===null) unset($this->contTab[$laLigne][$laColonne][FMT][$format[$idx]]);
			else $this->contTab[$laLigne][$laColonne][FMT][$format[$idx]]=$format[$idx+1];
		}
	}
	
	/*-----------------------------
	// applique le style au tableau
	------------------------------*/
	function appliqueStyle() {
		switch ($this->style) {
			case 1: 
				$this->fmtTab=array('class'=>"tTab_1",'cellpadding'=>0,'cellspacing'=>0,'style'=>"white-space:nowrap");
				for ($idxL=2,$_idxL=1;$idxL<=$this->nbLig;$idxL++,$_idxL=(3-$_idxL)) {
					$this->formatLigne($idxL,'class',"tLig".$_idxL."_1",'height',24,'valign',"middle");
					$this->formatCellule($idxL,1,'class',"tCol1_".$_idxL."_1 pad3_10");
				}
				for ($idxC=2;$idxC<=$this->nbCol;$idxC++) {
					$this->formatColonneParCellule($idxC,'class',"tBG_1 pad3_10");
				}
				//$this->formatColonneParCellule(1,'class',"tCol1_1");
				$this->formatLigne(1,'class',"tTitre_1",'height',24);
				break;
			
			case 2: 
				$this->fmtTab=array('class'=>"tTab_2",'cellpadding'=>0,'cellspacing'=>0,'style'=>"white-space:nowrap");
				for ($idxL=2,$_idxL=1;$idxL<=$this->nbLig;$idxL++,$_idxL=(3-$_idxL)) {
					$this->formatLigne($idxL,'class',"tLig".$_idxL."_2",'height',20,'valign',"middle");
					$this->formatCellule($idxL,1,'class',"tCol1_".$_idxL."_2 pad3_10");
				}
				for ($idxC=2;$idxC<=$this->nbCol;$idxC++) {
					$this->formatColonneParCellule($idxC,'class',"tBG_2 pad3_10");
				}
				//$this->formatColonneParCellule(1,'class',"tCol1_1");
				$this->formatLigne(1,'class',"tTitre_2",'height',20);
				break;
			
			case 0:
			default:break;
		}
	}
	
	/*-----------------------------
	// gnre le code HTML du tableau
	------------------------------*/
	function rendu() {
		
		//applique le style au tableau 
		$this->appliqueStyle();
		//echo tab2html($this->contTab);
		if ($this->nbLig==0) return false;
		$_fmtTab=$this->chaineAttributs($this->fmtTab);
		if ($_fmtTab!="") $_fmtTab=' '.$_fmtTab;
		$tab='<table'.$_fmtTab.'>'.CR;
		//contenu du tableau
		for ($idxL=0;$idxL<($this->nbLig);$idxL++) {
			if (isset($this->tabFmtLig[$idxL])) $_style=' '.$this->chaineAttributs($this->tabFmtLig[$idxL]); else $_style="";
			$tab.='<tr'.$_style.'>'.CR;
			$_nbCol=$this->nbCol;
			for ($idxC=0;$idxC<$_nbCol;$idxC++) {
				if (isset($this->contTab[$idxL][$idxC][FMT]['colspan'])) $_nbCol=$_nbCol-$this->contTab[$idxL][$idxC][FMT]['colspan']+1;
				$_cont=(isset($this->contTab[$idxL][$idxC][CNT]))?$this->contTab[$idxL][$idxC][CNT]:'';
				$_format=(isset($this->contTab[$idxL][$idxC][FMT]))?' '.$this->chaineAttributs($this->contTab[$idxL][$idxC][FMT]):'';
				$tab.='<td'.$_format.'>'.(($_cont!='')?$_cont:'&nbsp;').'</td>'.CR;
			}
			$tab.='</tr>'.CR;
		}
		$tab.='</table>'.CR;
		return $tab;
	}
} //fin de classe tableau_HTML_OLD
?>