<?php
/**
 * @class Affichage
 * Pour un affichage commun au niveau des applications présente sur le Scribe
 * Initialement : stopper une application si le serveur CAS a bien authentifié l'utilisateur mais renvoie le filtre pas défaut à la place de celui attendu...
 * Appel : new Affichage("echecCAS","index.php");
 */
class Affichage
	{
	/**
	 * Type du message demandé 
	 */
	private $type = "default";

	/**
	 * Types de message possibles
	 */	
	private $types = array
		(
		"default"
		=>
		"Message d&rsquo;avertissement inexistant.",
		
		"echecCAS"
		=>
		"<p><u>Probl&egrave;me de connexion</u> :</p>
		<p>Le serveur d&rsquo;authentification n&rsquo;a pas renvoy&eacute; les informations attendues.<br/>
		Veuillez r&eacute;essayer ult&eacute;rieurement.</p>"		
		);

	/**
	 * Chaîne de caractères précédent le message
	 */
	private $preString = '
	<html>
	<head>
		<style>
		body {text-align:center; background:#99ccff; font-size:16px; line-height:1.2em; font-family:verdana, sans-serif;}
		p {margin:10px;}
		a {text-decoration:none;}
		a:link, a:visited, a:active {color:#3333CC;}
		a:hover {color:#ff3333;}
		#div_message {width:800px; text-align:center; border:1px solid #3333CC; color:#3333CC; background-color:#ffdd99; padding:10px; margin:50px auto;}
		.gras {font-weight:bold;}
		.souligne {text-decoration:underline;}
		</style>
	</head>
	<body>
	<div id="div_message">';

	/**
	 * Chaîne de caractères suivant le message
	 */
	private $postString = '
	</div>
	</body>
	</html>';

	/**
	 * Lien de redirection
	 */
	private $link = '';

	/**
	 * Actions lors de l'instanciation
	 *
	 * @param String  $type   message demandé
	 * @param String  $link   redirection éventuelle
	 * @param String  $before chaîne à faire précéder au message (vide => affichage par défaut sinon exemple : <div>)
	 * @param String  $after  chaîne à faire suivre au message (vide => affichage par défaut sinon exemple : </div>)
	 * @param boolean $stop   mettre fin à l'exécution si besoin
	 */	
	public function __construct($type="",$link="",$before="",$after="",$stop=true)
		{
		$this->setType($type);
		$this->setPreString($before);
		$this->setPostString($post);
		$this->setLink($link);
		$this->setMessage($stop);
		}

	/**
	 * Enregistrement de $this->type
	 *
	 * @param String $type message demandé
	 */
	public function setType($type)
		{
		if(!empty($type) && array_key_exists($type,$this->types)) $this->type = $type;
		}

	/**
	 * Enregistrement de $this->link
	 *
	 * @param String $after chaîne à faire suivre au message (vide => affichage par défaut)
	 */
	public function setLink($link)
		{
		if(!empty($link)) $this->link = '<p>- <a href="'.$link.'">retour</a> -</p>';
		}

	/**
	 * Enregistrement de $this->preString
	 *
	 * @param String $before chaîne à faire précéder au message (vide => affichage par défaut)
	 */
	public function setPreString($before)
		{
		if(!empty($before)) $this->preString = $before;
		}

	/**
	 * Enregistrement de $this->postString
	 *
	 * @param String $after chaîne à faire suivre au message (vide => affichage par défaut)
	 */
	public function setPostString($after)
		{
		if(!empty($after)) $this->postString = $after;
		}

	/**
	 * Affichage du message
	 *
	 * @param boolean $stop   mettre fin à l'exécution si besoin
	 */
	public function setMessage($stop)
		{
		$output = $this->preString . $this->types[$this->type] . $this->link . $this->postString;
		echo $output;
		if($stop) die();
		}
	}
?>
