# -*- coding: UTF-8 -*-
from flask import Flask, Blueprint
import os
import importlib
import pkgutil

from eoleauthlib.authclient import init_authentication

app = Flask(__name__)

init_authentication(app)

# portion to be removed from each "complete" module path in get_modules
basename = os.path.dirname(os.path.abspath(__file__))

def get_modules(path):
    """
    Getting the list of all modules paths recursively from a given path
    """
    modules_list = []
    for _, name, ispkg in pkgutil.iter_modules([path]):
        if ispkg:
            modules_list.extend(get_modules(os.path.join(path, name)))
        else:
            complete_name = os.path.abspath(os.path.join(path, name))
            # should always be true
            if (complete_name.find(basename) >= 0):
                module_name = complete_name.replace(basename, '').replace(os.sep, '.')
                modules_list.append(module_name)

    return modules_list

# MODULES AND BLUEPRINTS

# base path for modules, also used to find conf files
modules_path = os.path.join(__path__[0], 'modules')

modules_list = get_modules(modules_path)

# loading modules and blueprints
for module in modules_list:
    mod = importlib.import_module(module, package='eoe')
    app.logger.info('Loading python module: ' + str(mod))
    for item in dir(mod):
        bp = getattr(mod, item)
        if isinstance(bp, Blueprint):
            app.register_blueprint(bp)
            app.logger.info('Registering blueprint: ' + bp.name)
