#!/usr/bin/env python
# -*- coding: utf-8 -*-

from distutils.core import setup
from os.path import dirname, abspath, join, normpath, isdir
from os import listdir

def return_storages():
    "returns all the storage plugins that are living in tiramisu/storage"
    here = dirname(abspath(__file__))
    storages_path = normpath(join(here, 'src', 'eoe', 'modules'))
    dir_content = [content for content in listdir(storages_path)]
    storages = filter(isdir, [join(storages_path, content)
                      for content in dir_content])
    storage_list = ['.'.join(storage.split('/')[-3:]) for storage in storages]
    return storage_list

packages = ['eoe', 'eoe.modules']
packages.extend(return_storages())

setup(
    author='Équipe Eole',
    author_email='eole@ac-dijon.fr',
    name='python-eole-eoe',
    version='2.7.2',
    description='eole-eoe',
    url='http://www.eole.orion.education.fr',
    package_dir={'':'src'},  # root
    packages=packages
)
