# -*- coding: UTF-8 -*-
import xmlrpc.client
from flask import current_app

class PasswordCheckError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

def check_password(username, password):
    """ Checking if a password is long enough and contains enough different kinds of characters
    """
    nb_car_min = current_app.config['NB_CAR_MIN']
    nb_classe_min = current_app.config['NB_CLASSE_MIN']
    no_username_in_pwd = current_app.config['NO_USERNAME_IN_PWD']
    if password.find(username) != -1:
        raise PasswordCheckError("Erreur : votre mot de passe ne doit pas contenir votre nom d'utilisateur")
    if len(password) < nb_car_min:
        raise PasswordCheckError("Erreur : votre mot de passe doit comporter au moins %s caractères." % nb_car_min)
    proxy = xmlrpc.client.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    if not proxy.remote_check_nb_min_classes(current_app.config['SECRET_KEY'], password, nb_classe_min):
        raise PasswordCheckError("Erreur : veuillez utiliser au moins %s classes de caractère." % nb_classe_min)
    return password
