from flask import Blueprint
from flask.views import MethodView
import json
from eoleauthlib.authclient import login_required
from eop.utils import secure_arg

devnameapi = Blueprint('devnameapi', __name__, url_prefix = '')

class DevNameAPI(MethodView):
    decorators = [ login_required]

    def get(self, devname):
        """Returns a list of members of the given groups with the given filter
        """
        if devname is None:
            return json.dumps('Error: You need a devname to talk to backend')
        return json.dumps(secure_arg(devname))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("devname_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET"],
                defaults={"devname": None})
        mod.add_url_rule('%s<devname>' % mod.url_prefix, view_func=f,
                        methods=['GET'])

DevNameAPI.register(devnameapi)
