import json
from flask import Blueprint, render_template, request, session, url_for
from eop.modelsForms import DocumentsForm, DocRamasserForm, DocRendreForm
from eoleauthlib.authclient import login_required
from eop.modules import usersapi
from eoleflask.util import get_proxy_url

documents = Blueprint('documents', __name__)

@documents.route('')
@login_required
def show():

    username = session["username"]

    user = usersapi.UsersAPI()
    is_prof = json.loads(user.get())    # user.get() returns a string containing "true" or "false" and json.loads convert it in a python boolean

    if not is_prof:
        return render_template('erreurs/non_prof.html', username=username)
    else:
        form = DocumentsForm(request.form)
        form4 = DocRamasserForm(request.form)
        form5 = DocRendreForm(request.form)
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("documents.show", _external=True)))
        return render_template('documents.html', username=username, form=form, form4=form4, form5=form5, url_logout=url_logout)
