from flask import Blueprint, current_app
from xmlrpclib import ServerProxy
from flask.views import MethodView
import json
from eoleauthlib.authclient import login_required

membersapi = Blueprint('membersapi', __name__, url_prefix = '')

class MembersAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])

    def get(self, groupname, filtrateon=None):
        """Returns a list of members of the given groups with the given filter
        """
        if groupname is None:
            return json.dumps('Error: You need a groupname to talk to backend')
        if filtrateon is not None:
            return json.dumps(self.proxy.remote_membres(groupname, filtrateon))
        return json.dumps(self.proxy.remote_membres(groupname))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("members_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET"],
                defaults={"groupname": None, "filtrateon": None})
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["POST"])
        mod.add_url_rule('%s<groupname>/<filtrateon>' % mod.url_prefix, view_func=f,
                        methods=['GET', 'PUT', 'DELETE'])
        mod.add_url_rule('%s<groupname>' % mod.url_prefix, view_func=f,
                        methods=['GET'])

MembersAPI.register(membersapi)
