import smtplib
from werkzeug import secure_filename
from email.mime.text import MIMEText

COMMASPACE = ', '

def send_mail(smtp_server="", mailFrom="", mailTo=[], mailSubject="", text=""):
    """Envoi simple de mail text
    """
    if len(mailTo) > 0:
        msg = MIMEText(text, "plain", "utf-8")
        msg['Subject'] = mailSubject
        msg['From'] = mailFrom
        msg['To'] = COMMASPACE.join(mailTo)
        msg.preamble = mailSubject

        s = smtplib.SMTP(smtp_server)
        s.sendmail(mailFrom, mailTo, msg.as_string())
        s.quit()

def secure_arg(arg=None):
    """Returns arg for secure file names
    """
    if arg is not None:
        return secure_filename(arg).lower()
    else:
        return None
