from flask import Flask, Blueprint
from flask.views import MethodView
from eop.modules.documentsapi import documentsapi
from eop.modules.groupsapi import groupsapi
from eop.modules.membersapi import membersapi
from eop.modules.usersapi import usersapi
from eop.modules.filesapi import filesapi
from eop.modules.ldapusersapi import ldapusersapi
from eop.modules.ldappasswordsapi import ldappasswordsapi
from eop.modules.devnameapi import devnameapi
from eop.modules.mailsapi import mailsapi
from eop.modules.documents import documents
from eoleauthlib.authclient import init_authentication

app = Flask(__name__)

init_authentication(app)

app.register_blueprint(documentsapi, url_prefix='/api/documents/')
app.register_blueprint(groupsapi, url_prefix='/api/groups/')
app.register_blueprint(membersapi, url_prefix='/api/members/')
app.register_blueprint(usersapi, url_prefix='/api/users/')
app.register_blueprint(filesapi, url_prefix='/api/files/')
app.register_blueprint(ldapusersapi, url_prefix='/api/ldapusers/')
app.register_blueprint(ldappasswordsapi, url_prefix='/api/ldappasswords/')
app.register_blueprint(devnameapi, url_prefix='/api/devname/')
app.register_blueprint(mailsapi, url_prefix='/api/mails/')

app.register_blueprint(documents, url_prefix='/documents')
