from flask import Blueprint, current_app
from xmlrpclib import ServerProxy
from flask.views import MethodView
import json
from eoleauthlib.authclient import login_required

groupsapi = Blueprint('groupsapi', __name__, url_prefix = '')

class GroupsAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])

    def get(self, typegroup):
        """Returns the list of groups with the given type
           Possible group types : "classe", "niveau", "matiere", "equipe", "groupe"
        """
        if typegroup is None:
            return json.dumps('Error: You need a typegroup to talk to backend')
        return json.dumps(self.proxy.remote_groupes(typegroup))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("groups_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET"],
                defaults={"typegroup": None})
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["POST"])
        mod.add_url_rule('%s<typegroup>' % mod.url_prefix, view_func=f,
                        methods=['GET', 'PUT', 'DELETE'])

GroupsAPI.register(groupsapi)
